/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.measurementsui.fileaccess;

import java.io.File;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.sirius.business.api.session.Session;
import org.palladiosimulator.edp2.models.measuringpoint.MeasuringPoint;
import org.palladiosimulator.edp2.models.measuringpoint.MeasuringPointRepository;
import org.palladiosimulator.edp2.models.measuringpoint.MeasuringpointPackage;
import org.palladiosimulator.measurementsui.datamanipulation.RepositoryCreator;
import org.palladiosimulator.monitorrepository.Monitor;
import org.palladiosimulator.monitorrepository.MonitorRepository;
import org.palladiosimulator.monitorrepository.MonitorRepositoryPackage;
import org.palladiosimulator.pcm.allocation.Allocation;
import org.palladiosimulator.pcm.allocation.AllocationPackage;
import org.palladiosimulator.pcm.repository.Repository;
import org.palladiosimulator.pcm.repository.RepositoryPackage;
import org.palladiosimulator.pcm.resourceenvironment.ResourceEnvironment;
import org.palladiosimulator.pcm.resourceenvironment.ResourceenvironmentPackage;
import org.palladiosimulator.pcm.subsystem.SubSystem;
import org.palladiosimulator.pcm.subsystem.SubsystemPackage;
import org.palladiosimulator.pcm.system.System;
import org.palladiosimulator.pcm.system.SystemPackage;
import org.palladiosimulator.pcm.usagemodel.UsageModel;
import org.palladiosimulator.pcm.usagemodel.UsagemodelPackage;
import org.palladiosimulator.servicelevelobjective.ServiceLevelObjectiveRepository;
import org.palladiosimulator.servicelevelobjective.ServicelevelObjectivePackage;

public class ModelAccessor {
    private List<ResourceEnvironment> resourceEnvironmentList = new LinkedList<ResourceEnvironment>();
    private List<System> systemList = new LinkedList<System>();
    private List<Allocation> allocationList = new LinkedList<Allocation>();
    private List<Repository> repositoryList = new LinkedList<Repository>();
    private List<UsageModel> usageModelList = new LinkedList<UsageModel>();
    private List<SubSystem> subsystemList = new LinkedList<SubSystem>();
    private List<MeasuringPointRepository> measuringPointRepositoryList = new LinkedList<MeasuringPointRepository>();
    private List<MonitorRepository> monitorRepositoryList = new LinkedList<MonitorRepository>();
    private List<ServiceLevelObjectiveRepository> sloRepositoryList = new LinkedList<ServiceLevelObjectiveRepository>();
    private List<String> sloRepositoryNameList = new LinkedList<String>();

    public static <T> Predicate<T> not(Predicate<T> t) {
        return t.negate();
    }

    public EList<MeasuringPoint> getUnassignedMeasuringPoints() {
        List measuringPointsFromAllRepositories = this.measuringPointRepositoryList.stream().flatMap(e -> e.getMeasuringPoints().stream()).collect(Collectors.toList());
        List measuringPointsFromMonitors = this.monitorRepositoryList.stream().flatMap(e -> e.getMonitors().stream().map(Monitor::getMeasuringPoint)).collect(Collectors.toList());
        List intersectionOfMeasuringPoints = measuringPointsFromAllRepositories.stream().filter(ModelAccessor.not(measuringPointsFromMonitors::contains)).collect(Collectors.toList());
        return new BasicEList(intersectionOfMeasuringPoints);
    }

    public void initializeModels(Session session) {
        this.clearModelAccess();
        List allModelResourcesInSession = session.getSemanticResources().stream().collect(Collectors.toList());
        List allModelObjectsInSession = allModelResourcesInSession.stream().flatMap(e -> e.getContents().stream()).collect(Collectors.toList());
        Collection measuringPointRepositories = EcoreUtil.getObjectsByType(allModelObjectsInSession, (EClassifier)MeasuringpointPackage.eINSTANCE.getMeasuringPointRepository());
        this.measuringPointRepositoryList.addAll(measuringPointRepositories);
        Collection monitorRepositories = EcoreUtil.getObjectsByType(allModelObjectsInSession, (EClassifier)MonitorRepositoryPackage.eINSTANCE.getMonitorRepository());
        this.monitorRepositoryList.addAll(monitorRepositories);
        Collection sloRepositories = EcoreUtil.getObjectsByType(allModelObjectsInSession, (EClassifier)ServicelevelObjectivePackage.eINSTANCE.getServiceLevelObjectiveRepository());
        this.sloRepositoryList.addAll(sloRepositories);
        Collection resourceEnvironments = EcoreUtil.getObjectsByType(allModelObjectsInSession, (EClassifier)ResourceenvironmentPackage.eINSTANCE.getResourceEnvironment());
        this.resourceEnvironmentList.addAll(resourceEnvironments);
        Collection systems = EcoreUtil.getObjectsByType(allModelObjectsInSession, (EClassifier)SystemPackage.eINSTANCE.getSystem());
        this.systemList.addAll(systems);
        Collection allocations = EcoreUtil.getObjectsByType(allModelObjectsInSession, (EClassifier)AllocationPackage.eINSTANCE.getAllocation());
        this.allocationList.addAll(allocations);
        Collection repositories = EcoreUtil.getObjectsByType(allModelObjectsInSession, (EClassifier)RepositoryPackage.eINSTANCE.getRepository());
        this.repositoryList.addAll(repositories);
        Collection usageModels = EcoreUtil.getObjectsByType(allModelObjectsInSession, (EClassifier)UsagemodelPackage.eINSTANCE.getUsageModel());
        this.usageModelList.addAll(usageModels);
        Collection subSystems = EcoreUtil.getObjectsByType(allModelObjectsInSession, (EClassifier)SubsystemPackage.eINSTANCE.getSubSystem());
        this.subsystemList.addAll(subSystems);
        for (ServiceLevelObjectiveRepository repo : this.sloRepositoryList) {
            String uri = EcoreUtil.getURI((EObject)repo).toString();
            String name = new File(uri).getName();
            this.sloRepositoryNameList.add(name);
        }
    }

    public void checkIfRepositoriesExist(IProject project) {
        if (!this.monitorRepositoryExists()) {
            this.addMonitorRepository(RepositoryCreator.getInstance().createMonitorRepository(project));
        }
        if (!this.measuringPointRepositoryExists()) {
            this.addMeasuringPointRepository(RepositoryCreator.getInstance().createMeasuringPointRepository(project));
        }
        if (!this.sloRepositoryExists()) {
            this.addSloRepository(RepositoryCreator.getInstance().createSLORepository(project));
        }
    }

    private void clearModelAccess() {
        this.allocationList.clear();
        this.repositoryList.clear();
        this.systemList.clear();
        this.resourceEnvironmentList.clear();
        this.usageModelList.clear();
        this.subsystemList.clear();
        this.monitorRepositoryList.clear();
        this.measuringPointRepositoryList.clear();
        this.sloRepositoryList.clear();
        this.sloRepositoryNameList.clear();
    }

    public boolean modelsExist() {
        return !this.allocationList.isEmpty() || !this.systemList.isEmpty() || !this.subsystemList.isEmpty() || !this.repositoryList.isEmpty() || !this.resourceEnvironmentList.isEmpty() || !this.usageModelList.isEmpty();
    }

    public boolean monitorRepositoryExists() {
        return this.monitorRepositoryList != null && !this.monitorRepositoryList.isEmpty();
    }

    public boolean measuringPointRepositoryExists() {
        return this.measuringPointRepositoryList != null && !this.measuringPointRepositoryList.isEmpty();
    }

    public boolean sloRepositoryExists() {
        return this.sloRepositoryList != null && !this.sloRepositoryList.isEmpty();
    }

    protected void addMonitorRepository(MonitorRepository monitorRepository) {
        this.monitorRepositoryList.add(monitorRepository);
    }

    protected void addMeasuringPointRepository(MeasuringPointRepository measuringPointRepository) {
        this.measuringPointRepositoryList.add(measuringPointRepository);
    }

    protected void addSloRepository(ServiceLevelObjectiveRepository sloRepository) {
        this.sloRepositoryList.add(sloRepository);
        String uri = EcoreUtil.getURI((EObject)sloRepository).toString();
        String name = new File(uri).getName();
        this.sloRepositoryNameList.add(name);
    }

    public List<ResourceEnvironment> getResourceEnvironmenList() {
        return this.resourceEnvironmentList;
    }

    public List<System> getSystemList() {
        return this.systemList;
    }

    public List<Allocation> getAllocationList() {
        return this.allocationList;
    }

    public List<Repository> getRepositoryList() {
        return this.repositoryList;
    }

    public List<UsageModel> getUsageModelList() {
        return this.usageModelList;
    }

    public List<SubSystem> getSubSystemList() {
        return this.subsystemList;
    }

    public List<MeasuringPointRepository> getMeasuringPointRepositoryList() {
        return this.measuringPointRepositoryList;
    }

    public List<MonitorRepository> getMonitorRepositoryList() {
        return this.monitorRepositoryList;
    }

    public List<ServiceLevelObjectiveRepository> getSLORepositoryList() {
        return this.sloRepositoryList;
    }

    public List<String> getSLORepositoryNameList() {
        return this.sloRepositoryNameList;
    }
}

