/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.measurementsui.wizardmodel.pages;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.palladiosimulator.edp2.models.measuringpoint.MeasuringPoint;
import org.palladiosimulator.measurementsui.datamanipulation.ResourceEditorImpl;
import org.palladiosimulator.measurementsui.dataprovider.DataApplication;
import org.palladiosimulator.measurementsui.dataprovider.MeasuringPointModelElementProvider;
import org.palladiosimulator.measurementsui.util.CreateMeasuringPointSwitch;
import org.palladiosimulator.measurementsui.wizardmodel.WizardModel;
import org.palladiosimulator.monitorrepository.Monitor;
import org.palladiosimulator.pcm.core.composition.AssemblyContext;
import org.palladiosimulator.pcm.repository.OperationProvidedRole;
import org.palladiosimulator.pcm.repository.OperationRequiredRole;
import org.palladiosimulator.pcm.repository.PassiveResource;
import org.palladiosimulator.pcm.subsystem.SubSystem;
import org.palladiosimulator.pcm.system.System;

public class MeasuringPointSelectionWizardModel
implements WizardModel {
    private static final String CREATE_MEASURINGPOINT_INFO_TEXT = "Select the element of your Models which should be monitored during a simulation run. Models for which a measuring point can be created are highlighted with a bold font.";
    private static final String EDIT_MEASURINGPOINT_INFO_TEXT = "Select a different measuring Point.";
    private static final String CREATE_MEASURINGPOINT_TITLE = "Create Measuring Point";
    private static final String EDIT_MEASURINGPOINT_TITLE = "Edit Measuring Point";
    private Monitor monitor;
    private boolean isEditing;
    private boolean finishable = true;
    private ResourceEditorImpl editor = ResourceEditorImpl.getInstance();
    private Object currentSelectionFirstMeasuringModel;
    private Object currentSecondStageModel;
    private Object currentThirdStageModel;
    private DataApplication dataApplication = DataApplication.getInstance();
    private MeasuringPointModelElementProvider measuringpointModelElementProvider = new MeasuringPointModelElementProvider();

    public MeasuringPointSelectionWizardModel(Monitor monitor, boolean isEditing) {
        this.monitor = monitor;
        this.isEditing = isEditing;
    }

    @Override
    public boolean canFinish() {
        return this.monitor.getMeasuringPoint() != null && this.finishable;
    }

    @Override
    public String getInfoText() {
        if (this.monitor.getMeasuringPoint() != null) {
            return EDIT_MEASURINGPOINT_INFO_TEXT;
        }
        return CREATE_MEASURINGPOINT_INFO_TEXT;
    }

    @Override
    public String getTitleText() {
        if (this.monitor.getMeasuringPoint() != null) {
            return EDIT_MEASURINGPOINT_TITLE;
        }
        return CREATE_MEASURINGPOINT_TITLE;
    }

    public void setMeasuringPointDependingOnEditMode(MeasuringPoint measuringPoint) {
        if (this.isEditing) {
            this.editor.setMeasuringPointToMonitor((EObject)this.monitor, measuringPoint);
        } else {
            this.monitor.setMeasuringPoint(measuringPoint);
        }
    }

    public void createMeasuringPoint(Object model) {
        CreateMeasuringPointSwitch measuringSwitch = new CreateMeasuringPointSwitch();
        measuringSwitch.setSecondStageModel(this.currentSecondStageModel);
        measuringSwitch.setThirdStageModel(this.currentThirdStageModel);
        MeasuringPoint measuringPoint = (MeasuringPoint)measuringSwitch.doSwitch((EObject)model);
        this.setMeasuringPointDependingOnEditMode(measuringPoint);
    }

    public Object[] getAllSecondPageObjects() {
        LinkedList<Object> allmodels = new LinkedList<Object>();
        this.addOnlyFilledLists(allmodels, this.dataApplication.getModelAccessor().getResourceEnvironmenList());
        this.addOnlyFilledLists(allmodels, this.dataApplication.getModelAccessor().getSystemList());
        this.addOnlyFilledLists(allmodels, this.dataApplication.getModelAccessor().getSubSystemList());
        this.addOnlyFilledLists(allmodels, this.measuringpointModelElementProvider.getAssemblyContexts());
        this.addOnlyFilledLists(allmodels, this.measuringpointModelElementProvider.getResourceContainer());
        this.addOnlyFilledLists(allmodels, this.measuringpointModelElementProvider.getActiveResources());
        this.addOnlyFilledLists(allmodels, this.measuringpointModelElementProvider.getLinkingResources());
        this.addOnlyFilledLists(allmodels, this.measuringpointModelElementProvider.getUsageScenarios());
        this.addOnlyFilledLists(allmodels, this.measuringpointModelElementProvider.getExternalCallActions());
        this.addOnlyFilledLists(allmodels, this.measuringpointModelElementProvider.getEntryLevelSystemCalls());
        return allmodels.toArray();
    }

    public Object[] getExistingMeasuringPoints() {
        if (this.isEditing()) {
            EList<MeasuringPoint> points = this.dataApplication.getModelAccessor().getUnassignedMeasuringPoints();
            if (this.getMonitor().getMeasuringPoint() != null) {
                points.add(this.getMonitor().getMeasuringPoint());
            }
            return points.toArray();
        }
        return this.dataApplication.getModelAccessor().getUnassignedMeasuringPoints().toArray();
    }

    public List<Object> addOnlyFilledLists(List<Object> fillerList, List<?> modelList) {
        if (!modelList.isEmpty()) {
            fillerList.add(modelList);
            return fillerList;
        }
        return fillerList;
    }

    public Object[] getAllAdditionalModels() {
        LinkedList<Object> elements = new LinkedList<Object>();
        if (this.currentSelectionFirstMeasuringModel instanceof AssemblyContext) {
            AssemblyContext context = (AssemblyContext)this.currentSelectionFirstMeasuringModel;
            elements.addAll((Collection<Object>)context.getEncapsulatedComponent__AssemblyContext().getProvidedRoles_InterfaceProvidingEntity());
            elements.addAll((Collection<Object>)context.getEncapsulatedComponent__AssemblyContext().getRequiredRoles_InterfaceRequiringEntity());
            int i = 0;
            while (i < context.getEncapsulatedComponent__AssemblyContext().eContents().size()) {
                if (context.getEncapsulatedComponent__AssemblyContext().eContents().get(i) instanceof PassiveResource) {
                    elements.add(context.getEncapsulatedComponent__AssemblyContext().eContents().get(i));
                }
                ++i;
            }
            return elements.toArray();
        }
        if (this.currentSelectionFirstMeasuringModel instanceof System) {
            System context = (System)this.currentSelectionFirstMeasuringModel;
            elements.addAll((Collection<Object>)context.getProvidedRoles_InterfaceProvidingEntity());
            elements.addAll((Collection<Object>)context.getRequiredRoles_InterfaceRequiringEntity());
            return elements.toArray();
        }
        if (this.currentSelectionFirstMeasuringModel instanceof SubSystem) {
            SubSystem context = (SubSystem)this.currentSelectionFirstMeasuringModel;
            elements.addAll((Collection<Object>)context.getProvidedRoles_InterfaceProvidingEntity());
            elements.addAll((Collection<Object>)context.getRequiredRoles_InterfaceRequiringEntity());
            return elements.toArray();
        }
        return elements.toArray();
    }

    public List<Object> getAlternativeModels() {
        LinkedList<Object> elementList = new LinkedList<Object>();
        elementList.addAll(this.dataApplication.getModelAccessor().getRepositoryList().stream().filter(e -> !e.getEntityName().equals("FailureTypes") && !e.getEntityName().equals("PrimitiveDataTypes")).collect(Collectors.toCollection(LinkedList::new)));
        elementList.addAll(this.dataApplication.getModelAccessor().getResourceEnvironmenList());
        elementList.addAll(this.dataApplication.getModelAccessor().getSubSystemList());
        elementList.addAll(this.dataApplication.getModelAccessor().getSystemList());
        elementList.addAll(this.dataApplication.getModelAccessor().getUsageModelList());
        return elementList;
    }

    public List<EObject> getSignatures() {
        if (this.currentSecondStageModel instanceof OperationProvidedRole) {
            OperationProvidedRole model = (OperationProvidedRole)this.currentSecondStageModel;
            LinkedList<EObject> list = new LinkedList<EObject>();
            list.addAll((Collection<EObject>)model.getProvidedInterface__OperationProvidedRole().getSignatures__OperationInterface());
            return list;
        }
        if (this.currentSecondStageModel instanceof OperationRequiredRole) {
            OperationRequiredRole model = (OperationRequiredRole)this.currentSecondStageModel;
            LinkedList<EObject> list = new LinkedList<EObject>();
            list.addAll((Collection<EObject>)model.getRequiredInterface__OperationRequiredRole().getSignatures__OperationInterface());
            return list;
        }
        return new LinkedList<EObject>();
    }

    public Object getCurrentSelection() {
        return this.currentSelectionFirstMeasuringModel;
    }

    public void setCurrentSelection(Object current) {
        this.currentSelectionFirstMeasuringModel = current;
    }

    public Monitor getMonitor() {
        return this.monitor;
    }

    public void setMonitor(Monitor monitor) {
        this.monitor = monitor;
    }

    public Object getCurrentSecondStageModel() {
        return this.currentSecondStageModel;
    }

    public void setCurrentSecondStageModel(Object currentSecondStageModel) {
        this.currentSecondStageModel = currentSecondStageModel;
    }

    public Object getCurrentThirdStageModel() {
        return this.currentThirdStageModel;
    }

    public void setCurrentThirdStageModel(Object currentThirdStageModel) {
        this.currentThirdStageModel = currentThirdStageModel;
    }

    public boolean isFinishable() {
        return this.finishable;
    }

    public void setFinishable(boolean finishable) {
        this.finishable = finishable;
    }

    public boolean isEditing() {
        return this.isEditing;
    }

    public void setEditing(boolean isEditing) {
        this.isEditing = isEditing;
    }
}

