/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.measurementsui.abstractviewer.listener;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.palladiosimulator.measurementsui.datamanipulation.ResourceEditorImpl;
import org.palladiosimulator.monitorrepository.MeasurementSpecification;
import org.palladiosimulator.monitorrepository.Monitor;

public class MeasurementTreeDoubleClickListener
implements MouseListener {
    private Tree measurementsTree;

    public MeasurementTreeDoubleClickListener(TreeViewer measurementsTreeViewer) {
        this.measurementsTree = measurementsTreeViewer.getTree();
    }

    public void mouseDoubleClick(MouseEvent e) {
        TreeItem[] treeItemArray = this.measurementsTree.getSelection();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem item = treeItemArray[n2];
            if (this.isClickedOnTreeItemSymbol(e, item)) {
                this.setChecked(item);
            }
            ++n2;
        }
    }

    public void mouseDown(MouseEvent e) {
    }

    public void mouseUp(MouseEvent e) {
    }

    private void toggleMonitorActive(Monitor monitor) {
        ResourceEditorImpl edit = ResourceEditorImpl.getInstance();
        edit.changeMonitorActive((EObject)monitor, monitor.isActivated());
    }

    private void toggleTriggersSelfAdaption(MeasurementSpecification measurement) {
        ResourceEditorImpl edit = ResourceEditorImpl.getInstance();
        edit.changeTriggersSelfAdapting(measurement);
    }

    private void setChecked(TreeItem item) {
        Object data = item.getData();
        if (data instanceof Monitor) {
            this.toggleMonitorActive((Monitor)data);
        }
        if (data instanceof MeasurementSpecification) {
            this.toggleTriggersSelfAdaption((MeasurementSpecification)data);
        }
    }

    private boolean isClickedOnTreeItemSymbol(MouseEvent e, TreeItem item) {
        return item.getImage() != null && e.x > item.getImageBounds((int)0).x && e.x < item.getImageBounds((int)0).x + item.getImage().getBounds().width && e.y > item.getImageBounds((int)0).y && e.y < item.getImageBounds((int)0).y + item.getImage().getBounds().height;
    }
}

