/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.measurementsui.wizard.main;

import java.beans.PropertyChangeListener;
import java.net.URL;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.internal.util.BundleUtility;
import org.osgi.framework.Bundle;
import org.palladiosimulator.measurementsui.wizard.pages.AdditionalModelsToMeasuringpointWizardPage;
import org.palladiosimulator.measurementsui.wizard.pages.ChooseMeasuringpointWizardPage;
import org.palladiosimulator.measurementsui.wizard.pages.FinalModelsToMeasuringpointWizardPage;
import org.palladiosimulator.measurementsui.wizard.pages.MetricDescriptionSelectionWizardPage;
import org.palladiosimulator.measurementsui.wizard.pages.MonitorCreationWizardPage;
import org.palladiosimulator.measurementsui.wizard.pages.ProcessingTypeSelectionWizardPage;
import org.palladiosimulator.measurementsui.wizardmodel.WizardModelManager;
import org.palladiosimulator.measurementsui.wizardmodel.WizardModelType;
import org.palladiosimulator.measurementsui.wizardmodel.pages.MeasuringPointSelectionWizardModel;
import org.palladiosimulator.measurementsui.wizardmodel.pages.MetricDescriptionSelectionWizardModel;
import org.palladiosimulator.measurementsui.wizardmodel.pages.MonitorCreationWizardModel;
import org.palladiosimulator.measurementsui.wizardmodel.pages.ProcessingTypeSelectionWizardModel;
import org.palladiosimulator.monitorrepository.Monitor;

public class MeasurementsWizard
extends Wizard {
    private WizardModelManager wizardManager;
    private WizardModelType startingPage;
    private MonitorCreationWizardPage monitorCreationWizardPage1;
    private ChooseMeasuringpointWizardPage chooseMeasuringpointWizardPage2;
    private AdditionalModelsToMeasuringpointWizardPage additionalModelsToMeasuringpointWizardPage2_2;
    private FinalModelsToMeasuringpointWizardPage finalModelsToMeasuringpointWizardPage2_3;
    private MetricDescriptionSelectionWizardPage metricDescriptionSelectionWizardPage3;
    private ProcessingTypeSelectionWizardPage processingTypeSelectionWizardPage4;
    private int windowWidth = 800;
    private int windowHeight = 400;

    public MeasurementsWizard() {
        this.wizardManager = new WizardModelManager();
        this.startingPage = WizardModelType.MONITOR_CREATION;
        this.setImage();
        this.createPages();
    }

    public MeasurementsWizard(WizardModelType startingPage) {
        this.setWindowTitle("Add new Measuring Point");
        this.wizardManager = new WizardModelManager();
        this.startingPage = startingPage;
        this.setImage();
        this.createPages();
    }

    public MeasurementsWizard(WizardModelType startingPage, Monitor monitor) {
        this.setWindowTitle("Add new Measuring Point");
        this.wizardManager = new WizardModelManager(monitor);
        this.startingPage = startingPage;
        this.setImage();
        this.createPages();
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.wizardManager.addPropertyChangeListener(listener);
    }

    private void setImage() {
        Bundle bundle = Platform.getBundle((String)"org.palladiosimulator.measurementsui.wizard");
        URL fullPathString = BundleUtility.find((Bundle)bundle, (String)"icons/wizardImage.png");
        ImageDescriptor imageDescriptor = ImageDescriptor.createFromURL((URL)fullPathString);
        ImageData imageData = imageDescriptor.getImageData();
        int scaledWidth = Math.round((float)imageData.width / (1.5f / this.getDPIScale()));
        int scaledHeight = Math.round((float)imageData.height / (1.5f / this.getDPIScale()));
        if (scaledWidth < 100) {
            scaledWidth = 100;
        }
        if (scaledHeight < 100) {
            scaledHeight = 100;
        }
        ImageData scaledImageData = imageData.scaledTo(scaledWidth, scaledHeight);
        ImageDescriptor resizedImageDescriptor = ImageDescriptor.createFromImageData((ImageData)scaledImageData);
        this.setDefaultPageImageDescriptor(resizedImageDescriptor);
    }

    private void createPages() {
        this.monitorCreationWizardPage1 = new MonitorCreationWizardPage((MonitorCreationWizardModel)this.wizardManager.getWizardModel(WizardModelType.MONITOR_CREATION));
        this.chooseMeasuringpointWizardPage2 = new ChooseMeasuringpointWizardPage((MeasuringPointSelectionWizardModel)this.wizardManager.getWizardModel(WizardModelType.MEASURING_POINT_SELECTION));
        this.additionalModelsToMeasuringpointWizardPage2_2 = new AdditionalModelsToMeasuringpointWizardPage((MeasuringPointSelectionWizardModel)this.wizardManager.getWizardModel(WizardModelType.MEASURING_POINT_SELECTION));
        this.finalModelsToMeasuringpointWizardPage2_3 = new FinalModelsToMeasuringpointWizardPage((MeasuringPointSelectionWizardModel)this.wizardManager.getWizardModel(WizardModelType.MEASURING_POINT_SELECTION));
        this.metricDescriptionSelectionWizardPage3 = new MetricDescriptionSelectionWizardPage((MetricDescriptionSelectionWizardModel)this.wizardManager.getWizardModel(WizardModelType.METRIC_DESCRIPTION_SELECTION));
        this.processingTypeSelectionWizardPage4 = new ProcessingTypeSelectionWizardPage((ProcessingTypeSelectionWizardModel)this.wizardManager.getWizardModel(WizardModelType.PROCESSING_TYPE));
    }

    public IWizardPage getStartingPage() {
        switch (this.startingPage) {
            case MONITOR_CREATION: {
                return this.monitorCreationWizardPage1;
            }
            case MEASURING_POINT_SELECTION: {
                return this.chooseMeasuringpointWizardPage2;
            }
            case METRIC_DESCRIPTION_SELECTION: {
                return this.metricDescriptionSelectionWizardPage3;
            }
            case PROCESSING_TYPE: {
                return this.processingTypeSelectionWizardPage4;
            }
        }
        return this.monitorCreationWizardPage1;
    }

    public void addPages() {
        this.addPage((IWizardPage)this.monitorCreationWizardPage1);
        this.addPage((IWizardPage)this.chooseMeasuringpointWizardPage2);
        this.addPage((IWizardPage)this.metricDescriptionSelectionWizardPage3);
        this.addPage((IWizardPage)this.processingTypeSelectionWizardPage4);
        this.addPage((IWizardPage)this.additionalModelsToMeasuringpointWizardPage2_2);
        this.addPage((IWizardPage)this.finalModelsToMeasuringpointWizardPage2_3);
    }

    public boolean performCancel() {
        this.wizardManager.cancel();
        return true;
    }

    public boolean performFinish() {
        this.chooseMeasuringpointWizardPage2.performAddingOperations();
        this.wizardManager.finish();
        return true;
    }

    public boolean canFinish() {
        return this.wizardManager.canFinish();
    }

    public int getWindowWidth() {
        return Math.round((float)this.windowWidth * this.getDPIScale());
    }

    public int getWindowHeight() {
        return Math.round((float)this.windowHeight * this.getDPIScale());
    }

    private float getDPIScale() {
        int currentDPI = Display.getDefault().getDPI().x;
        float defaultDPI = 96.0f;
        return (float)currentDPI / defaultDPI;
    }
}

