/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.measurementsui.datamanipulation;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.palladiosimulator.edp2.models.measuringpoint.MeasuringPoint;
import org.palladiosimulator.measurementsui.datamanipulation.DataEditor;
import org.palladiosimulator.measurementsui.datamanipulation.ResourceEditor;
import org.palladiosimulator.metricspec.MetricDescription;
import org.palladiosimulator.monitorrepository.MeasurementSpecification;

public final class ResourceEditorImpl
implements ResourceEditor {
    private final DataEditor editor = new DataEditor();
    private static ResourceEditorImpl instance;

    private ResourceEditorImpl() {
    }

    public static ResourceEditorImpl getInstance() {
        if (instance == null) {
            instance = new ResourceEditorImpl();
        }
        return instance;
    }

    @Override
    public void setResourceName(EObject resource, String newName) {
        this.editor.editResource(resource, "entityName", newName);
    }

    @Override
    public void changeMonitorActive(EObject monitor, boolean currentBool) {
        this.editor.editResource(monitor, "activated", !currentBool);
    }

    @Override
    public void changeTriggersSelfAdapting(MeasurementSpecification mspec) {
        this.editor.editResource((EObject)mspec, "triggersSelfAdaptations", !mspec.isTriggersSelfAdaptations());
    }

    @Override
    public void setMeasuringPointToMonitor(EObject monitor, MeasuringPoint mp) {
        this.editor.editResource(monitor, "measuringPoint", mp);
    }

    @Override
    public void setMeasuringPointToMonitor(EObject monitor, EObject mp) {
        this.editor.editResource(monitor, "measuringPoint", mp);
    }

    @Override
    public void addMeasuringPointToRepository(EObject mpRep, EObject mp) {
        this.editor.addResource(mpRep, "measuringPoints", mp);
    }

    @Override
    public void addServiceLevelObjectiveToRepository(EObject sloRep, EObject slo) {
        this.editor.addResource(sloRep, "servicelevelobjectives", slo);
    }

    @Override
    public void deleteResource(EObject objToDelete) {
        this.editor.deleteResource(objToDelete);
    }

    @Override
    public void deleteMultipleResources(EList<MeasurementSpecification> objsToDelete) {
        this.editor.deleteMultipleResources(objsToDelete);
    }

    @Override
    public void setMetricDescription(EObject aMeasurementSpecification, MetricDescription aMetricDescription) {
        this.editor.editResource(aMeasurementSpecification, "metricDescription", aMetricDescription);
    }

    @Override
    public void addMeasurementSpecificationToMonitor(EObject monitor, MeasurementSpecification mspec) {
        this.editor.addResource(monitor, "measurementSpecifications", mspec);
    }

    @Override
    public void addMeasurementSpecificationsToMonitor(EObject monitor, EList<MeasurementSpecification> mSpecList) {
        this.editor.addListOfResources(monitor, "measurementSpecifications", mSpecList);
    }

    @Override
    public void addMonitorToRepository(EObject monitorRepository, EObject monitor) {
        this.editor.addResource(monitorRepository, "monitors", monitor);
    }

    @Override
    public void setProcessingType(EObject measurementSpecification, EObject processingType) {
        this.editor.editResource(measurementSpecification, "processingType", processingType);
    }

    @Override
    public void setAProcessingTypeAttribute(EObject processingType, String processingTypeAttributeName, Object value) {
        this.editor.editResource(processingType, processingTypeAttributeName, value);
    }

    @Override
    public void setServiceLevelObjectiveName(EObject slo, String name) {
        this.editor.editResource(slo, "name", name);
    }

    @Override
    public void setServiceLevelObjectiveDescription(EObject slo, String description) {
        this.editor.editResource(slo, "description", description);
    }

    @Override
    public void setMeasurementSpecificationToServiceLevelObjective(EObject slo, EObject measurementSpec) {
        this.editor.editResource(slo, "measurementSpecification", measurementSpec);
    }
}

