/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.measurementsui.dataprovider;

import java.util.Collection;
import java.util.Map;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.palladiosimulator.edp2.models.measuringpoint.MeasuringPoint;
import org.palladiosimulator.measurementsui.datamanipulation.ResourceEditorImpl;
import org.palladiosimulator.measurementsui.extensionpoint.evaluation.EvaluateExtensions;
import org.palladiosimulator.metricspec.MetricDescription;
import org.palladiosimulator.metricspec.MetricSetDescription;
import org.palladiosimulator.metricspec.constants.MetricDescriptionConstants;
import org.palladiosimulator.monitorrepository.MeasurementSpecification;
import org.palladiosimulator.monitorrepository.Monitor;
import org.palladiosimulator.monitorrepository.MonitorRepositoryFactory;
import org.palladiosimulator.monitorrepository.MonitorRepositoryPackage;
import org.palladiosimulator.monitorrepository.ProcessingType;
import org.palladiosimulator.pcmmeasuringpoint.ActiveResourceMeasuringPoint;
import org.palladiosimulator.pcmmeasuringpoint.AssemblyOperationMeasuringPoint;
import org.palladiosimulator.pcmmeasuringpoint.AssemblyPassiveResourceMeasuringPoint;
import org.palladiosimulator.pcmmeasuringpoint.EntryLevelSystemCallMeasuringPoint;
import org.palladiosimulator.pcmmeasuringpoint.ExternalCallActionMeasuringPoint;
import org.palladiosimulator.pcmmeasuringpoint.LinkingResourceMeasuringPoint;
import org.palladiosimulator.pcmmeasuringpoint.ResourceContainerMeasuringPoint;
import org.palladiosimulator.pcmmeasuringpoint.ResourceEnvironmentMeasuringPoint;
import org.palladiosimulator.pcmmeasuringpoint.SubSystemOperationMeasuringPoint;
import org.palladiosimulator.pcmmeasuringpoint.SystemOperationMeasuringPoint;
import org.palladiosimulator.pcmmeasuringpoint.UsageScenarioMeasuringPoint;
import org.palladiosimulator.pcmmeasuringpoint.util.PcmmeasuringpointSwitch;

public class UnselectedMetricSpecificationsProvider {
    private ResourceEditorImpl editor = ResourceEditorImpl.getInstance();

    public void createMonitorWithMissingMetricDescriptions(Monitor passedMonitor, Monitor unusedMonitor, boolean expertMode) {
        MonitorRepositoryFactory monFactory = MonitorRepositoryPackage.eINSTANCE.getMonitorRepositoryFactory();
        MetricSetDescription dummyMetricDesc = MetricDescriptionConstants.COST_OVER_TIME;
        EList allMetricDescriptions = dummyMetricDesc.getRepository().getMetricDescriptions();
        BasicEList validMetricDescriptionList = new BasicEList();
        if (passedMonitor != null) {
            EList mSpecsOfPassedMonitor;
            if (this.getAllValidMetricDescriptionsForMeasuringPoint(passedMonitor) != null) {
                validMetricDescriptionList.addAll(this.getAllValidMetricDescriptionsForMeasuringPoint(passedMonitor).keySet());
            }
            if (!(mSpecsOfPassedMonitor = passedMonitor.getMeasurementSpecifications()).isEmpty()) {
                mSpecsOfPassedMonitor = passedMonitor.getMeasurementSpecifications();
                BasicEList metricDescriptionsInPassedMonitor = new BasicEList();
                for (MeasurementSpecification aMSpec : mSpecsOfPassedMonitor) {
                    metricDescriptionsInPassedMonitor.add((Object)aMSpec.getMetricDescription());
                }
                BasicEList nonMatchingMetricDesciptions = new BasicEList();
                if (expertMode) {
                    this.findNonMatchingMetricDescriptions((EList<MetricDescription>)metricDescriptionsInPassedMonitor, (EList<MetricDescription>)allMetricDescriptions, (EList<MetricDescription>)nonMatchingMetricDesciptions);
                } else {
                    this.findNonMatchingMetricDescriptions((EList<MetricDescription>)metricDescriptionsInPassedMonitor, (EList<MetricDescription>)validMetricDescriptionList, (EList<MetricDescription>)nonMatchingMetricDesciptions);
                }
                this.createMonitorWithMissingDescriptions(monFactory, (EList<MetricDescription>)nonMatchingMetricDesciptions, unusedMonitor);
            } else if (expertMode) {
                this.createMonitorWithMissingDescriptions(monFactory, (EList<MetricDescription>)allMetricDescriptions, unusedMonitor);
            } else {
                this.createMonitorWithMissingDescriptions(monFactory, (EList<MetricDescription>)validMetricDescriptionList, unusedMonitor);
            }
        }
    }

    public Map<MetricDescription, Boolean> getAllValidMetricDescriptionsForMeasuringPoint(Monitor passedMonitor) {
        if (passedMonitor.getMeasuringPoint() != null) {
            MeasuringPoint passedMP = passedMonitor.getMeasuringPoint();
            EvaluateExtensions evaluateExtensions = new EvaluateExtensions();
            evaluateExtensions.loadExtensions();
            PcmmeasuringpointSwitch<Map<MetricDescription, Boolean>> measuringPointSwitch = this.getPcmMeasuringPointSwitch(evaluateExtensions);
            return (Map)measuringPointSwitch.doSwitch((EObject)passedMP);
        }
        return null;
    }

    private PcmmeasuringpointSwitch<Map<MetricDescription, Boolean>> getPcmMeasuringPointSwitch(final EvaluateExtensions evaluateExtensions) {
        return new PcmmeasuringpointSwitch<Map<MetricDescription, Boolean>>(){

            public Map<MetricDescription, Boolean> caseActiveResourceMeasuringPoint(ActiveResourceMeasuringPoint object) {
                return evaluateExtensions.getMeasuringPointmetricsCombinations().getActiveResourceMeasuringPointMetrics();
            }

            public Map<MetricDescription, Boolean> caseAssemblyOperationMeasuringPoint(AssemblyOperationMeasuringPoint object) {
                return evaluateExtensions.getMeasuringPointmetricsCombinations().getAssemblyOperationMeasuringPointMetrics();
            }

            public Map<MetricDescription, Boolean> caseAssemblyPassiveResourceMeasuringPoint(AssemblyPassiveResourceMeasuringPoint object) {
                return evaluateExtensions.getMeasuringPointmetricsCombinations().getAssemblyPassiveResourceMeasuringPointMetrics();
            }

            public Map<MetricDescription, Boolean> caseEntryLevelSystemCallMeasuringPoint(EntryLevelSystemCallMeasuringPoint object) {
                return evaluateExtensions.getMeasuringPointmetricsCombinations().getEntryLevelSystemCallMeasuringPointMetrics();
            }

            public Map<MetricDescription, Boolean> caseExternalCallActionMeasuringPoint(ExternalCallActionMeasuringPoint object) {
                return evaluateExtensions.getMeasuringPointmetricsCombinations().getExternalCallActionMeasuringPointMetrics();
            }

            public Map<MetricDescription, Boolean> caseLinkingResourceMeasuringPoint(LinkingResourceMeasuringPoint object) {
                return evaluateExtensions.getMeasuringPointmetricsCombinations().getLinkingResourceMeasuringPointMetrics();
            }

            public Map<MetricDescription, Boolean> caseResourceContainerMeasuringPoint(ResourceContainerMeasuringPoint object) {
                return evaluateExtensions.getMeasuringPointmetricsCombinations().getResourceContainerMeasuringPointMetrics();
            }

            public Map<MetricDescription, Boolean> caseResourceEnvironmentMeasuringPoint(ResourceEnvironmentMeasuringPoint object) {
                return evaluateExtensions.getMeasuringPointmetricsCombinations().getResourceEnvironmentMeasuringPointMetrics();
            }

            public Map<MetricDescription, Boolean> caseSubSystemOperationMeasuringPoint(SubSystemOperationMeasuringPoint object) {
                return evaluateExtensions.getMeasuringPointmetricsCombinations().getSubSystemOperationMeasuringPointMetrics();
            }

            public Map<MetricDescription, Boolean> caseSystemOperationMeasuringPoint(SystemOperationMeasuringPoint object) {
                return evaluateExtensions.getMeasuringPointmetricsCombinations().getSystemOperationMeasuringPointMetrics();
            }

            public Map<MetricDescription, Boolean> caseUsageScenarioMeasuringPoint(UsageScenarioMeasuringPoint object) {
                return evaluateExtensions.getMeasuringPointmetricsCombinations().getUsageScenarioMeasuringPointMetrics();
            }
        };
    }

    private Monitor createMonitorWithMissingDescriptions(MonitorRepositoryFactory monFactory, EList<MetricDescription> listOfMetricDescriptions, Monitor tempMon) {
        BasicEList mSpecList = new BasicEList();
        this.createMeasurementSpecificationsForEveryMetricDescription(listOfMetricDescriptions, monFactory, (EList<MeasurementSpecification>)mSpecList);
        this.setMetricDescriptionForEveryMeasurementSpecification(listOfMetricDescriptions, (EList<MeasurementSpecification>)mSpecList);
        for (MeasurementSpecification aMSpec : mSpecList) {
            aMSpec.setProcessingType((ProcessingType)MonitorRepositoryFactory.eINSTANCE.createFeedThrough());
        }
        tempMon.eSet(tempMon.eClass().getEStructuralFeature("measurementSpecifications"), (Object)mSpecList);
        return tempMon;
    }

    public void moveMeasurementSpecificationToMonitor(MeasurementSpecification selectedMeasurementSpecification, Monitor receivingMonitor, boolean isInEditMode) {
        if (isInEditMode) {
            this.editor.addMeasurementSpecificationToMonitor((EObject)receivingMonitor, selectedMeasurementSpecification);
        } else {
            receivingMonitor.getMeasurementSpecifications().add((Object)selectedMeasurementSpecification);
        }
    }

    public void removeMeasurementSpecificationFromMonitor(MeasurementSpecification selectedMeasurementSpecification, Monitor receivingMonitor, boolean isInEditMode) {
        if (isInEditMode) {
            this.editor.deleteResource((EObject)selectedMeasurementSpecification);
            receivingMonitor.getMeasurementSpecifications().add((Object)selectedMeasurementSpecification);
        } else {
            receivingMonitor.getMeasurementSpecifications().add((Object)selectedMeasurementSpecification);
        }
    }

    public void moveAllMeasurementSpecificationsToMonitor(Monitor sendingMonitor, Monitor receivingMonitor, boolean isInEditMode) {
        if (isInEditMode) {
            this.editor.addMeasurementSpecificationsToMonitor((EObject)receivingMonitor, (EList<MeasurementSpecification>)sendingMonitor.getMeasurementSpecifications());
        } else {
            receivingMonitor.getMeasurementSpecifications().addAll((Collection)sendingMonitor.getMeasurementSpecifications());
        }
    }

    public void moveSuggestedMeasurementSpecificationsToMonitor(Monitor sendingMonitor, Monitor receivingMonitor, boolean isInEditMode) {
        EList allMSpecs = sendingMonitor.getMeasurementSpecifications();
        BasicEList moveList = new BasicEList();
        Map<MetricDescription, Boolean> validMap = this.getAllValidMetricDescriptionsForMeasuringPoint(receivingMonitor);
        EList mSpecsInReceivingMonitor = receivingMonitor.getMeasurementSpecifications();
        for (Map.Entry<MetricDescription, Boolean> entry : validMap.entrySet()) {
            if (!entry.getValue().booleanValue()) continue;
            for (MeasurementSpecification aMSpec : allMSpecs) {
                if (!aMSpec.getMetricDescription().getName().equals(entry.getKey().getName()) || mSpecsInReceivingMonitor.contains((Object)aMSpec)) continue;
                moveList.add((Object)aMSpec);
            }
        }
        if (isInEditMode) {
            this.editor.addMeasurementSpecificationsToMonitor((EObject)receivingMonitor, (EList<MeasurementSpecification>)moveList);
        } else {
            receivingMonitor.getMeasurementSpecifications().addAll((Collection)moveList);
        }
    }

    public void removeAllMeasurementSpecificationsFromMonitor(Monitor sendingMonitor, Monitor receivingMonitor, boolean isInEditMode) {
        if (isInEditMode) {
            Collection copy = EcoreUtil.copyAll((Collection)sendingMonitor.getMeasurementSpecifications());
            receivingMonitor.getMeasurementSpecifications().addAll(copy);
            this.editor.deleteMultipleResources((EList<MeasurementSpecification>)sendingMonitor.getMeasurementSpecifications());
        } else {
            receivingMonitor.getMeasurementSpecifications().addAll((Collection)sendingMonitor.getMeasurementSpecifications());
        }
    }

    public void setMetricDescriptionForEveryMeasurementSpecification(EList<MetricDescription> nonMatchingMetricDesciptions, EList<MeasurementSpecification> mSpecList) {
        int i = 0;
        while (i < mSpecList.size()) {
            ((MeasurementSpecification)mSpecList.get(i)).setMetricDescription((MetricDescription)nonMatchingMetricDesciptions.get(i));
            ++i;
        }
    }

    public void createMeasurementSpecificationsForEveryMetricDescription(EList<MetricDescription> nonMatchingMetricDesciptions, MonitorRepositoryFactory monFactory, EList<MeasurementSpecification> mSpecList) {
        int i = 0;
        while (i < nonMatchingMetricDesciptions.size()) {
            mSpecList.add((Object)monFactory.createMeasurementSpecification());
            ++i;
        }
    }

    private EList<MetricDescription> findNonMatchingMetricDescriptions(EList<MetricDescription> metricDescInPassedMonitor, EList<MetricDescription> allMetricDescriptions, EList<MetricDescription> nonMatchingMetricDesciptions) {
        for (MetricDescription allMetricDesc : allMetricDescriptions) {
            boolean nonMatching = true;
            for (MetricDescription aMetricDesc : metricDescInPassedMonitor) {
                if (!allMetricDesc.getName().equals(aMetricDesc.getName())) continue;
                nonMatching = false;
                break;
            }
            if (!nonMatching) continue;
            nonMatchingMetricDesciptions.add((Object)allMetricDesc);
        }
        return nonMatchingMetricDesciptions;
    }

    public String provideTextualDescriptionForMetricDescription(MetricDescription aMetricDescription) {
        return aMetricDescription.getTextualDescription();
    }
}

