/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simulizar.ui.measurementsdashboard.parts;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.e4.core.commands.ECommandService;
import org.eclipse.e4.core.commands.EHandlerService;
import org.eclipse.e4.ui.di.Persist;
import org.eclipse.e4.ui.internal.workbench.handlers.SaveAllHandler;
import org.eclipse.e4.ui.internal.workbench.handlers.SaveHandler;
import org.eclipse.e4.ui.model.application.ui.MDirtyable;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerDropAdapter;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.palladiosimulator.edp2.models.measuringpoint.MeasuringPoint;
import org.palladiosimulator.edp2.models.measuringpoint.MeasuringPointRepository;
import org.palladiosimulator.measurementsui.abstractviewer.MeasurementsTreeViewer;
import org.palladiosimulator.measurementsui.abstractviewer.listener.MeasuringpointDropListener;
import org.palladiosimulator.measurementsui.datamanipulation.ResourceEditorImpl;
import org.palladiosimulator.measurementsui.dataprovider.DataApplication;
import org.palladiosimulator.measurementsui.wizard.main.MeasurementsWizard;
import org.palladiosimulator.measurementsui.wizard.main.ServiceLevelObjectiveWizard;
import org.palladiosimulator.measurementsui.wizard.main.StandardSetWizard;
import org.palladiosimulator.measurementsui.wizardmodel.WizardModelType;
import org.palladiosimulator.monitorrepository.MeasurementSpecification;
import org.palladiosimulator.monitorrepository.Monitor;
import org.palladiosimulator.monitorrepository.MonitorRepository;
import org.palladiosimulator.monitorrepository.ProcessingType;
import org.palladiosimulator.servicelevelobjective.ServiceLevelObjective;
import org.palladiosimulator.servicelevelobjective.ServiceLevelObjectiveRepository;
import org.palladiosimulator.simulizar.ui.measurementsdashboard.filter.MeasurementsFilter;
import org.palladiosimulator.simulizar.ui.measurementsdashboard.handlers.RedoHandler;
import org.palladiosimulator.simulizar.ui.measurementsdashboard.handlers.RefreshHandler;
import org.palladiosimulator.simulizar.ui.measurementsdashboard.handlers.UndoHandler;
import org.palladiosimulator.simulizar.ui.measurementsdashboard.listeners.WorkspaceListener;
import org.palladiosimulator.simulizar.ui.measurementsdashboard.viewer.EmptyMeasuringPointsTreeViewer;
import org.palladiosimulator.simulizar.ui.measurementsdashboard.viewer.MonitorTreeViewer;
import org.palladiosimulator.simulizar.ui.measurementsdashboard.viewer.SloTreeViewer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MeasurementsDashboardView
implements PropertyChangeListener {
    private MeasurementsTreeViewer monitorTreeViewer;
    private MeasurementsTreeViewer measuringTreeViewer;
    private MeasurementsTreeViewer sloTreeViewer;
    private Combo projectsComboDropDown;
    private Combo monitorRepositoriesComboDropDown;
    private Combo sloRepositoriesComboDropbDown;
    private DataApplication dataApplication;
    private Button deleteButton;
    private Button editButton;
    private Button addSloButton;
    private Button editSloButton;
    private Button deleteSloButton;
    private Button templateSloButton;
    private Label buttonSpacer;
    private MeasurementsFilter filter;
    private Text searchText;
    private static final String DELETETEXT_MEASURINGPOINT = "Delete MeasuringPoint";
    private static final String EDITTEXT_GRAYEDOUT = "Edit...";
    private static final String DELETETEXT_GRAYEDOUT = "Delete...";
    private static final String EDITTEXT_MONITOR = "Edit Monitor";
    private static final String DELETETEXT_MONITOR = "Delete Monitor";
    private static final String EDITTEXT_MEASUREMENT = "Edit Measurement";
    private static final String DELETETEXT_MEASUREMENT = "Delete Measurement";
    private static final String EDITTEXT_PROCESSINGTYPE = "Edit ProcessingType";
    private static final String INFOTEXT_NO_PCM_MODELS = "You need to create your palladio core models before you can create measuring points. They are used to model your systems architecture and characteristics. Use the buttons on the toolbar on top to start creating.";
    private static final String ADDTEXT_SLO = "Add new SLO";
    private static final String EDITTEXT_SLO = "Edit SLO";
    private static final String DELETETEXT_SLO = "Delete SLO";
    private static final String TEMPLATE_SLO = "SLO Templates";
    private static final String SAVE_COMMAND = "org.eclipse.ui.file.save";
    private static final String SAVEALL_COMMAND = "org.eclipse.ui.file.saveAll";
    private static final String UNDO_COMMAND = "org.eclipse.ui.edit.undo";
    private static final String REDO_COMMAND = "org.eclipse.ui.edit.redo";
    private static final String REFRESH_COMMAND = "org.eclipse.ui.file.refresh";
    private final Logger logger = LoggerFactory.getLogger(MeasurementsDashboardView.class);
    @Inject
    private MDirtyable dirty;
    @Inject
    private ECommandService commandService;
    @Inject
    private EHandlerService handlerService;
    @Inject
    private ESelectionService selectionService;

    @PostConstruct
    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new GridLayout(1, true));
        this.initializeApplication();
        this.createWorkspaceListener();
        this.createSelectionComboBoxes(parent);
        SashForm outerContainer = new SashForm(parent, 4);
        outerContainer.setLayout((Layout)new GridLayout(1, true));
        outerContainer.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite leftContainer = new Composite((Composite)outerContainer, 0);
        leftContainer.setLayout((Layout)new GridLayout(1, false));
        leftContainer.setBackground(new Color((Device)Display.getCurrent(), 255, 255, 255));
        this.createFilterGadgets(leftContainer);
        Composite buttonContainer = new Composite((Composite)outerContainer, 2048);
        buttonContainer.setLayout((Layout)new GridLayout(1, true));
        outerContainer.setWeights(new int[]{3, 1});
        SashForm treeContainer = new SashForm(leftContainer, 512);
        treeContainer.setLayout((Layout)new GridLayout(1, false));
        treeContainer.setLayoutData((Object)new GridData(4, 4, true, true));
        treeContainer.setBackground(new Color((Device)Display.getCurrent(), 255, 255, 255));
        Composite monitorContainer = this.createTreeComposite((Composite)treeContainer);
        Composite undefinedMeasuringContainer = this.createTreeComposite((Composite)treeContainer);
        Composite sloContainer = this.createTreeComposite((Composite)treeContainer);
        treeContainer.setWeights(new int[]{10, 5, 5});
        this.createViewButtons(buttonContainer);
        this.monitorTreeViewer = this.createMonitorTreeViewer(monitorContainer);
        this.measuringTreeViewer = this.createEmptyMeasuringPointsTreeViewer(undefinedMeasuringContainer);
        this.sloTreeViewer = this.createSloTreeViewer(sloContainer);
        this.initHandlers();
    }

    private void initializeApplication() {
        this.dataApplication = DataApplication.getInstance();
        if (!this.dataApplication.getValidProjectAccessor().getAllProjectAirdfiles().isEmpty()) {
            this.dataApplication.loadData((IProject)this.dataApplication.getValidProjectAccessor().getAllProjectAirdfiles().get(0), 0, 0);
        }
    }

    private void createWorkspaceListener() {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        workspace.addResourceChangeListener((IResourceChangeListener)new WorkspaceListener(this), 1);
    }

    private MeasurementsTreeViewer createMonitorTreeViewer(Composite parent) {
        MonitorTreeViewer measurementsTreeViewer = new MonitorTreeViewer(parent, this.dirty, this.commandService, this.dataApplication.getMonitorRepository());
        measurementsTreeViewer.addMouseListener();
        measurementsTreeViewer.getViewer().addFilter((ViewerFilter)this.filter);
        measurementsTreeViewer.setDropAdapter((ViewerDropAdapter)new MeasuringpointDropListener((MeasurementsTreeViewer)measurementsTreeViewer, (PropertyChangeListener)this));
        this.addSelectionListener(measurementsTreeViewer);
        return measurementsTreeViewer;
    }

    private MeasurementsTreeViewer createSloTreeViewer(Composite parent) {
        SloTreeViewer sloTreeViewer = new SloTreeViewer(parent, this.dirty, this.commandService, this.dataApplication.getSLORepository());
        sloTreeViewer.addMouseListener();
        sloTreeViewer.getViewer().addFilter((ViewerFilter)this.filter);
        this.addSelectionListener(sloTreeViewer);
        return sloTreeViewer;
    }

    private MeasurementsTreeViewer createEmptyMeasuringPointsTreeViewer(Composite parent) {
        EmptyMeasuringPointsTreeViewer emptyMeasuringPointsTreeViewer = !this.dataApplication.getModelAccessor().getMeasuringPointRepositoryList().isEmpty() ? new EmptyMeasuringPointsTreeViewer(parent, this.dirty, this.commandService, (MeasuringPointRepository)this.dataApplication.getModelAccessor().getMeasuringPointRepositoryList().get(0)) : new EmptyMeasuringPointsTreeViewer(parent, this.dirty, this.commandService, null);
        emptyMeasuringPointsTreeViewer.getViewer().addFilter((ViewerFilter)this.filter);
        this.addSelectionListener(emptyMeasuringPointsTreeViewer);
        return emptyMeasuringPointsTreeViewer;
    }

    private void initHandlers() {
        this.handlerService.activateHandler(SAVE_COMMAND, (Object)new SaveHandler());
        this.handlerService.activateHandler(SAVEALL_COMMAND, (Object)new SaveAllHandler());
        this.handlerService.activateHandler(UNDO_COMMAND, (Object)new UndoHandler());
        this.handlerService.activateHandler(REDO_COMMAND, (Object)new RedoHandler());
        this.handlerService.activateHandler(REFRESH_COMMAND, (Object)new RefreshHandler());
    }

    private void addSelectionListener(MeasurementsTreeViewer treeViewer) {
        treeViewer.getViewer().addSelectionChangedListener(event -> {
            IStructuredSelection selection = (IStructuredSelection)event.getSelection();
            this.selectionService.setSelection((Object)(selection.size() == 1 ? selection.getFirstElement() : selection.toArray()));
            Object selectionObject = selection.getFirstElement();
            this.editButton.setText(EDITTEXT_GRAYEDOUT);
            this.deleteButton.setText(DELETETEXT_GRAYEDOUT);
            this.deleteSloButton.setEnabled(false);
            this.editSloButton.setEnabled(false);
            if (selectionObject == null || selectionObject instanceof MonitorRepository || selectionObject instanceof MeasuringPointRepository || selectionObject instanceof ServiceLevelObjectiveRepository) {
                this.editButton.setEnabled(false);
                this.deleteButton.setEnabled(false);
            }
            if (selectionObject instanceof MeasuringPoint) {
                this.editButton.setEnabled(false);
                this.deleteButton.setEnabled(true);
                this.deleteButton.setText(DELETETEXT_MEASURINGPOINT);
            }
            if (selectionObject instanceof ProcessingType) {
                this.deleteButton.setEnabled(false);
                this.editButton.setEnabled(true);
                this.editButton.setText(EDITTEXT_PROCESSINGTYPE);
            }
            if (selectionObject instanceof Monitor) {
                this.deleteButton.setEnabled(true);
                this.editButton.setEnabled(true);
                this.editButton.setText(EDITTEXT_MONITOR);
                this.deleteButton.setText(DELETETEXT_MONITOR);
            }
            if (selectionObject instanceof MeasurementSpecification) {
                this.deleteButton.setEnabled(true);
                this.editButton.setEnabled(true);
                this.editButton.setText(EDITTEXT_MEASUREMENT);
                this.deleteButton.setText(DELETETEXT_MEASUREMENT);
            }
            if (selectionObject instanceof ServiceLevelObjective) {
                this.editButton.setEnabled(false);
                this.deleteButton.setEnabled(false);
                this.deleteSloButton.setEnabled(true);
                this.deleteSloButton.setText(DELETETEXT_SLO);
                this.editSloButton.setEnabled(true);
                this.editSloButton.setText(EDITTEXT_SLO);
            }
        });
    }

    private Composite createTreeComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new FillLayout());
        composite.setLayoutData((Object)new GridData(1808));
        return composite;
    }

    private void createFilterGadgets(Composite parent) {
        Composite filterContainer = new Composite(parent, 0);
        filterContainer.setLayout((Layout)new GridLayout(6, false));
        filterContainer.setLayoutData((Object)new GridData(4, 128, false, false));
        filterContainer.setBackground(new Color((Device)Display.getCurrent(), 255, 255, 255));
        this.filter = new MeasurementsFilter();
        Label filterLabel = new Label(filterContainer, 0);
        filterLabel.setText("Filter:");
        this.searchText = new Text(filterContainer, 2176);
        this.searchText.setLayoutData((Object)new GridData(4, 4, true, true));
        this.searchText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                MeasurementsDashboardView.this.filterTreeViewer();
            }
        });
        Label filterActiveCheckboxLabel = new Label(filterContainer, 0);
        filterActiveCheckboxLabel.setText("Active\nMonitors");
        final Button filterActiveCheckbox = new Button(filterContainer, 32);
        filterActiveCheckbox.setSelection(true);
        filterActiveCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MeasurementsDashboardView.this.filter.setFilterActiveMonitors(!filterActiveCheckbox.getSelection());
                MeasurementsDashboardView.this.filterTreeViewer();
            }
        });
        Label filterInactiveCheckboxLabel = new Label(filterContainer, 0);
        filterInactiveCheckboxLabel.setText("Inactive\nMonitors");
        final Button filterInactiveCheckbox = new Button(filterContainer, 32);
        filterInactiveCheckbox.setSelection(true);
        filterInactiveCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MeasurementsDashboardView.this.filter.setFilterInactiveMonitors(!filterInactiveCheckbox.getSelection());
                MeasurementsDashboardView.this.filterTreeViewer();
            }
        });
    }

    private void filterTreeViewer() {
        TreeViewer treeViewer = (TreeViewer)this.monitorTreeViewer.getViewer();
        treeViewer.collapseAll();
        treeViewer.expandToLevel(2);
        this.filter.setSearchText(this.searchText.getText());
        this.monitorTreeViewer.getViewer().refresh();
        this.measuringTreeViewer.getViewer().refresh();
        this.sloTreeViewer.getViewer().refresh();
        this.filter.setSearchText("");
    }

    private void createViewButtons(Composite buttonContainer) {
        this.createAddMeasurementButton(buttonContainer);
        this.createDeleteButton(buttonContainer);
        this.createEditButton(buttonContainer);
        this.createStandardSetButton(buttonContainer);
        this.createButtonSpacer(buttonContainer);
        this.createAddSLOButton(buttonContainer);
        this.createEditSLOButton(buttonContainer);
        this.createDeleteSLOButton(buttonContainer);
        this.createButtonSpacer(buttonContainer);
    }

    private void createAddMeasurementButton(Composite parent) {
        Button addMeasurementButton = new Button(parent, 8);
        addMeasurementButton.setText("Add new Measurement");
        addMeasurementButton.setToolTipText("Add new Monitor and Measuring Point with Metrics");
        addMeasurementButton.setLayoutData((Object)new GridData(4, 4, true, false));
        addMeasurementButton.addListener(13, e -> {
            if (!this.dataApplication.getModelAccessor().modelsExist()) {
                MessageDialog.openInformation(null, (String)"No PCM Models found Info", (String)INFOTEXT_NO_PCM_MODELS);
            } else {
                this.checkDirtyState();
                MeasurementsWizard wizard = new MeasurementsWizard();
                wizard.addPropertyChangeListener((PropertyChangeListener)this);
                Shell parentShell = wizard.getShell();
                WizardDialog dialog = new WizardDialog(parentShell, (IWizard)wizard);
                dialog.setPageSize(wizard.getWindowWidth(), wizard.getWindowHeight());
                dialog.setMinimumPageSize(wizard.getWindowWidth(), wizard.getWindowHeight());
                dialog.open();
            }
        });
    }

    private void createDeleteButton(Composite parent) {
        this.deleteButton = new Button(parent, 8);
        this.deleteButton.setText(DELETETEXT_GRAYEDOUT);
        this.deleteButton.setEnabled(false);
        this.deleteButton.setLayoutData((Object)new GridData(4, 4, true, false));
        this.deleteButton.addListener(13, e -> {
            ResourceEditorImpl resourceEditor = ResourceEditorImpl.getInstance();
            Object selection = this.selectionService.getSelection();
            if (selection instanceof EObject) {
                resourceEditor.deleteResource((EObject)selection);
            }
        });
    }

    private void createEditButton(Composite parent) {
        this.editButton = new Button(parent, 8);
        this.editButton.setText(EDITTEXT_GRAYEDOUT);
        this.editButton.setEnabled(false);
        this.editButton.setLayoutData((Object)new GridData(4, 4, true, false));
        this.editButton.addListener(13, e -> {
            if (!this.dataApplication.getModelAccessor().modelsExist()) {
                MessageDialog.openInformation(null, (String)"No PCM Models found Info", (String)INFOTEXT_NO_PCM_MODELS);
            } else {
                this.checkDirtyState();
                Object selection = this.selectionService.getSelection();
                ITreeContentProvider provider = (ITreeContentProvider)this.monitorTreeViewer.getViewer().getContentProvider();
                MeasurementsWizard wizard = selection instanceof Monitor ? new MeasurementsWizard(WizardModelType.MONITOR_CREATION, (Monitor)selection) : (selection instanceof MeasuringPoint ? new MeasurementsWizard(WizardModelType.MEASURING_POINT_SELECTION, (Monitor)provider.getParent(selection)) : (selection instanceof MeasurementSpecification ? new MeasurementsWizard(WizardModelType.METRIC_DESCRIPTION_SELECTION, (Monitor)provider.getParent(selection)) : (selection instanceof ProcessingType ? new MeasurementsWizard(WizardModelType.PROCESSING_TYPE, (Monitor)provider.getParent((Object)((ProcessingType)selection).getMeasurementSpecification())) : new MeasurementsWizard(WizardModelType.MONITOR_CREATION))));
                wizard.addPropertyChangeListener((PropertyChangeListener)this);
                Shell parentShell = wizard.getShell();
                WizardDialog dialog = new WizardDialog(parentShell, (IWizard)wizard);
                dialog.setPageSize(wizard.getWindowWidth(), wizard.getWindowHeight());
                dialog.setMinimumPageSize(wizard.getWindowWidth(), wizard.getWindowHeight());
                dialog.open();
            }
        });
    }

    private void createButtonSpacer(Composite parent) {
        this.buttonSpacer = new Label(parent, 8);
        this.buttonSpacer.setText("");
        this.buttonSpacer.setLayoutData((Object)new GridData(4, 4, true, false));
    }

    private void createAddSLOButton(Composite parent) {
        this.addSloButton = new Button(parent, 8);
        this.addSloButton.setText(ADDTEXT_SLO);
        this.addSloButton.setEnabled(true);
        this.addSloButton.setLayoutData((Object)new GridData(4, 4, true, false));
        this.addSloButton.addListener(13, e -> {
            this.checkDirtyState();
            ServiceLevelObjectiveWizard wizard = new ServiceLevelObjectiveWizard(true, null);
            wizard.addPropertyChangeListener((PropertyChangeListener)this);
            Shell parentShell = wizard.getShell();
            WizardDialog dialog = new WizardDialog(parentShell, (IWizard)wizard);
            dialog.setPageSize(690, 450);
            dialog.setMinimumPageSize(690, 450);
            dialog.setShellStyle(67680);
            dialog.open();
        });
    }

    private void createEditSLOButton(Composite parent) {
        this.editSloButton = new Button(parent, 8);
        this.editSloButton.setText(EDITTEXT_SLO);
        this.editSloButton.setEnabled(false);
        this.editSloButton.setLayoutData((Object)new GridData(4, 4, true, false));
        this.editSloButton.addListener(13, e -> {
            this.checkDirtyState();
            Object selection = this.selectionService.getSelection();
            if (selection instanceof ServiceLevelObjective) {
                ServiceLevelObjectiveWizard wizard = new ServiceLevelObjectiveWizard(false, (ServiceLevelObjective)selection);
                wizard.addPropertyChangeListener((PropertyChangeListener)this);
                Shell parentShell = wizard.getShell();
                WizardDialog dialog = new WizardDialog(parentShell, (IWizard)wizard);
                dialog.setPageSize(690, 450);
                dialog.setMinimumPageSize(690, 450);
                dialog.setShellStyle(67680);
                dialog.open();
            }
        });
    }

    private void createDeleteSLOButton(Composite parent) {
        this.deleteSloButton = new Button(parent, 8);
        this.deleteSloButton.setText(DELETETEXT_SLO);
        this.deleteSloButton.setEnabled(false);
        this.deleteSloButton.setLayoutData((Object)new GridData(4, 4, true, false));
        this.deleteSloButton.addListener(13, e -> {
            ResourceEditorImpl resourceEditor = ResourceEditorImpl.getInstance();
            Object selection = this.selectionService.getSelection();
            if (selection instanceof EObject) {
                resourceEditor.deleteResource((EObject)selection);
            }
        });
    }

    private void createTemplateSLOButton(Composite parent) {
        this.templateSloButton = new Button(parent, 8);
        this.templateSloButton.setText(TEMPLATE_SLO);
        this.templateSloButton.setEnabled(true);
        this.templateSloButton.setLayoutData((Object)new GridData(4, 4, true, false));
        this.templateSloButton.addListener(13, e -> this.checkDirtyState());
    }

    private void createStandardSetButton(Composite parent) {
        Button createStandardButton = new Button(parent, 8);
        createStandardButton.setText("Create Standard Set");
        createStandardButton.setLayoutData((Object)new GridData(4, 4, true, false));
        createStandardButton.addListener(13, e -> {
            this.checkDirtyState();
            StandardSetWizard wizard = new StandardSetWizard();
            wizard.addPropertyChangeListener((PropertyChangeListener)this);
            Shell parentShell = wizard.getShell();
            WizardDialog dialog = new WizardDialog(parentShell, (IWizard)wizard);
            dialog.setPageSize(720, 400);
            dialog.setMinimumPageSize(720, 400);
            dialog.open();
        });
    }

    private void checkDirtyState() {
        if (this.dirty.isDirty()) {
            boolean result = MessageDialog.openQuestion(null, (String)"", (String)"Do you want to save your changes?");
            if (result) {
                try {
                    this.save();
                }
                catch (IOException e) {
                    this.logger.warn("IOException when attempting to save the dirty state. Stacktrace: {}", (Object)e.getMessage());
                }
            } else {
                this.undoChanges();
            }
        }
    }

    private void createSelectionComboBoxes(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(2, false));
        container.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.createProjectsSelectionComboBox(container);
        this.createMonitorRepositorySelectionComboBox(container);
        this.createSLORepositorySelectionComboBox(container);
    }

    private void createProjectsSelectionComboBox(Composite parent) {
        Composite projectContainer = new Composite(parent, 0);
        projectContainer.setLayout((Layout)new GridLayout(2, false));
        projectContainer.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Label filterLabel = new Label(projectContainer, 0);
        filterLabel.setText("Project:");
        this.projectsComboDropDown = new Combo(projectContainer, 4);
        this.projectsComboDropDown.setLayoutData((Object)new GridData(4, 1, true, false));
        this.updateProjectComboBox();
        this.projectsComboDropDown.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                int selectionIndex = MeasurementsDashboardView.this.projectsComboDropDown.getSelectionIndex();
                MeasurementsDashboardView.this.dataApplication.loadData((IProject)MeasurementsDashboardView.this.dataApplication.getValidProjectAccessor().getAllProjectAirdfiles().get(selectionIndex), 0, 0);
                MeasurementsDashboardView.this.updateTreeViewer();
                MeasurementsDashboardView.this.updateMonitorRepositoryComboBox();
                MeasurementsDashboardView.this.updateSLORepositoryComboBox();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                MeasurementsDashboardView.this.projectsComboDropDown.select(0);
            }
        });
        this.projectsComboDropDown.select(0);
    }

    private void createMonitorRepositorySelectionComboBox(Composite parent) {
        Composite monitorRepositoryContainer = new Composite(parent, 0);
        monitorRepositoryContainer.setLayout((Layout)new GridLayout(2, false));
        monitorRepositoryContainer.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Label filterLabel = new Label(monitorRepositoryContainer, 0);
        filterLabel.setText("MonitorRepository:");
        this.monitorRepositoriesComboDropDown = new Combo(monitorRepositoryContainer, 4);
        this.monitorRepositoriesComboDropDown.setLayoutData((Object)new GridData(4, 1, true, false));
        this.updateMonitorRepositoryComboBox();
        this.monitorRepositoriesComboDropDown.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                int selectionIndex = MeasurementsDashboardView.this.monitorRepositoriesComboDropDown.getSelectionIndex();
                MeasurementsDashboardView.this.dataApplication.updateMonitorRepository(selectionIndex);
                MeasurementsDashboardView.this.updateTreeViewer();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                MeasurementsDashboardView.this.monitorRepositoriesComboDropDown.select(0);
            }
        });
        this.monitorRepositoriesComboDropDown.select(0);
    }

    private void createSLORepositorySelectionComboBox(Composite parent) {
        Composite sloRepositoryContainer = new Composite(parent, 0);
        sloRepositoryContainer.setLayout((Layout)new GridLayout(2, false));
        sloRepositoryContainer.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Label filterLabel = new Label(sloRepositoryContainer, 0);
        filterLabel.setText("SLO Repository:");
        this.sloRepositoriesComboDropbDown = new Combo(sloRepositoryContainer, 8);
        this.sloRepositoriesComboDropbDown.setLayoutData((Object)new GridData(4, 1, true, false));
        this.updateSLORepositoryComboBox();
        this.sloRepositoriesComboDropbDown.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                int selectionIndex = MeasurementsDashboardView.this.sloRepositoriesComboDropbDown.getSelectionIndex();
                MeasurementsDashboardView.this.dataApplication.updateSLORepository(selectionIndex);
                MeasurementsDashboardView.this.updateTreeViewer();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                MeasurementsDashboardView.this.sloRepositoriesComboDropbDown.select(0);
            }
        });
        this.sloRepositoriesComboDropbDown.select(0);
    }

    public void updateMonitorRepositoryComboBox() {
        this.monitorRepositoriesComboDropDown.setEnabled(true);
        int selectionIndex = 0;
        this.monitorRepositoriesComboDropDown.removeAll();
        List allMonitorRepositories = this.dataApplication.getModelAccessor().getMonitorRepositoryList();
        int i = 0;
        while (i < allMonitorRepositories.size()) {
            MonitorRepository monitorRepository = (MonitorRepository)allMonitorRepositories.get(i);
            if (monitorRepository.equals(this.dataApplication.getMonitorRepository())) {
                selectionIndex = i;
            }
            this.monitorRepositoriesComboDropDown.add(String.valueOf(i + 1) + ". " + monitorRepository.getEntityName());
            ++i;
        }
        this.monitorRepositoriesComboDropDown.select(selectionIndex);
        if (this.dataApplication.getModelAccessor().getMonitorRepositoryList().size() <= 1) {
            this.monitorRepositoriesComboDropDown.setEnabled(false);
        }
    }

    public void updateSLORepositoryComboBox() {
        this.sloRepositoriesComboDropbDown.setEnabled(true);
        int selectionIndex = 0;
        this.sloRepositoriesComboDropbDown.removeAll();
        List sloRepositories = this.dataApplication.getModelAccessor().getSLORepositoryList();
        List sloRepositoryNames = this.dataApplication.getModelAccessor().getSLORepositoryNameList();
        int i = 0;
        while (i < sloRepositories.size()) {
            ServiceLevelObjectiveRepository sloRepository = (ServiceLevelObjectiveRepository)sloRepositories.get(i);
            if (sloRepository.equals(this.dataApplication.getSLORepository())) {
                selectionIndex = i;
            }
            this.sloRepositoriesComboDropbDown.add(String.valueOf(i + 1) + ". " + ((String)sloRepositoryNames.get(i)).substring(0, ((String)sloRepositoryNames.get(i)).length() - 1));
            ++i;
        }
        this.sloRepositoriesComboDropbDown.select(selectionIndex);
        if (sloRepositories.size() <= 1) {
            this.sloRepositoriesComboDropbDown.setEnabled(false);
        }
    }

    public void updateProjectComboBox() {
        int selectionIndex = 0;
        this.projectsComboDropDown.removeAll();
        List allProjects = this.dataApplication.getValidProjectAccessor().getAllProjectAirdfiles();
        int i = 0;
        while (i < allProjects.size()) {
            IProject project = (IProject)allProjects.get(i);
            if (project.equals((Object)this.dataApplication.getProject())) {
                selectionIndex = i;
            }
            this.projectsComboDropDown.add(project.toString());
            ++i;
        }
        this.projectsComboDropDown.select(selectionIndex);
    }

    public void updateMeasurementsDashboardView(IProject project) {
        this.dataApplication.loadData(project, this.monitorRepositoriesComboDropDown.getSelectionIndex(), this.sloRepositoriesComboDropbDown.getSelectionIndex());
        this.updateTreeViewer();
    }

    public void updateMeasurementsDashboardView() {
        this.dataApplication.updateData(this.monitorRepositoriesComboDropDown.getSelectionIndex(), this.sloRepositoriesComboDropbDown.getSelectionIndex());
        this.updateTreeViewer();
        this.updateMonitorRepositoryComboBox();
        this.updateSLORepositoryComboBox();
    }

    private void undoChanges() {
        this.monitorTreeViewer.undoAll();
        this.measuringTreeViewer.undoAll();
        this.sloTreeViewer.undoAll();
    }

    private void updateTreeViewer() {
        this.monitorTreeViewer.update((EObject)this.dataApplication.getMonitorRepository());
        this.measuringTreeViewer.update((EObject)this.dataApplication.getModelAccessor().getMeasuringPointRepositoryList().get(0));
        this.sloTreeViewer.update((EObject)this.dataApplication.getSLORepository());
    }

    public void undo() {
        this.monitorTreeViewer.undo();
        this.sloTreeViewer.undo();
    }

    public void redo() {
        this.monitorTreeViewer.redo();
        this.sloTreeViewer.redo();
    }

    @Persist
    public void save() throws IOException {
        this.monitorTreeViewer.save(this.dirty);
        this.measuringTreeViewer.save(this.dirty);
        this.sloTreeViewer.save(this.dirty);
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        try {
            this.save();
            this.updateMeasurementsDashboardView();
        }
        catch (IOException e) {
            this.logger.warn("IOException when attempting to save the dirty state. Stacktrace: {}", (Object)e.getMessage());
        }
    }
}

