package org.palladiosimulator.measurementsui.abstractviewer;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.parsley.viewers.ViewerFactory;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;
import org.palladiosimulator.measurementsui.wizardmodel.WizardModel;
import org.palladiosimulator.monitorrepository.MonitorRepositoryPackage;

/**
 * Generates a Eclipse SWT TableViewer based on a TableViewer generated by Eclipse Parsley
 * 
 * @author David Schuetz
 *
 */
public abstract class WizardTableViewer extends ComponentViewer {
    protected TableViewer tableViewer;
    protected ViewerFactory tableFactory;
    protected WizardModel wizardModel;

    /**
     * 
     * @param parent
     *            the container where the tree viewer is placed in
     * @param modelRepository
     * 			  EObject which is shown in the view
     */
    protected WizardTableViewer(Composite parent, EObject modelRepository) {
        super(parent, modelRepository);
    }

    @Override
    protected void initParsley(Composite parent) {
        tableFactory = injector.getInstance(ViewerFactory.class);
        tableViewer = tableFactory.createTableViewer(parent, SWT.BORDER | SWT.FULL_SELECTION | SWT.MULTI,
                MonitorRepositoryPackage.eINSTANCE.getMeasurementSpecification());
        getModelRepository().ifPresent(modelRepository -> tableViewer.setInput(getModelRepository().get()));
    }

    @Override
    public void update() {
        tableViewer.refresh();
    }

    @Override
    public StructuredViewer getViewer() {
        return tableViewer;
    }

    @Override
    protected void initDragAndDrop() {
        // Don't use drag and drop in this viewer
    }

}