/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.dsexplore.analysis.cost;

import de.uka.ipd.sdq.dsexplore.analysis.qes.QesFinder;
import de.uka.ipd.sdq.dsexplore.analysis.qes.QesHelper;
import de.uka.ipd.sdq.dsexplore.analysis.qes.QesParser;
import de.uka.ipd.sdq.dsexplore.launch.DSEWorkflowConfiguration;
import de.uka.ipd.sdq.pcm.cost.ComponentCost;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.palladiosimulator.qes.qualityEffectSpecification.NumericValue;
import org.palladiosimulator.qes.qualityEffectSpecification.QualityEffectSpecification;
import org.palladiosimulator.qes.qualityEffectSpecification.TransformationSpecification;
import org.palladiosimulator.qes.qualityEffectSpecification.TransformationType;
import org.palladiosimulator.solver.core.models.PCMInstance;

public class QesCostExtension {
    private static final String INITIAL_COST = "InitialCost";
    private static final String OPERATING_COST = "OperatingCost";
    private QesFinder finder;
    private final Set<QualityEffectSpecification> specifications;

    private static double getComponentCost(TransformationType transformationType, String transformationNumber, double componentCost) {
        switch (transformationType) {
            case IS: {
                return QesHelper.doubleValue((String)transformationNumber);
            }
            case PLUS: {
                return componentCost + QesHelper.doubleValue((String)transformationNumber);
            }
            case MINUS: {
                return componentCost - QesHelper.doubleValue((String)transformationNumber);
            }
            case MULTIPLICATION: {
                return componentCost * QesHelper.doubleValue((String)transformationNumber);
            }
            case DIVISION: {
                return componentCost / QesHelper.doubleValue((String)transformationNumber);
            }
        }
        return componentCost;
    }

    private static Set<QualityEffectSpecification> getQesCostSpecifications(DSEWorkflowConfiguration configuration) {
        try {
            HashSet specifications = new HashSet();
            QesParser parser = new QesParser(configuration.getRawConfiguration().getAttribute("qualityEffectSpecificationFile", ""));
            if (!parser.isEmpty() && parser.isValid()) {
                specifications.addAll(parser.getSpecifications(INITIAL_COST));
                specifications.addAll(parser.getSpecifications(OPERATING_COST));
            }
            return Collections.unmodifiableSet(specifications);
        }
        catch (Exception exception) {
            return Collections.EMPTY_SET;
        }
    }

    public QesCostExtension(DSEWorkflowConfiguration configuration) {
        this.specifications = QesCostExtension.getQesCostSpecifications(configuration);
    }

    public void evaluateQesModel(ComponentCost componentCost) {
        if (this.finder == null || this.specifications.isEmpty() || componentCost == null || componentCost.getRepositoryComponent() == null) {
            return;
        }
        String componentId = componentCost.getRepositoryComponent().getId();
        for (QualityEffectSpecification specification : this.specifications) {
            if (!this.finder.getEffectedComponents((List)specification.getComponents()).contains(componentId)) continue;
            for (TransformationSpecification transformation : specification.getTransformations()) {
                if (!(transformation instanceof NumericValue)) continue;
                NumericValue numericValueTransformation = (NumericValue)transformation;
                if (numericValueTransformation.getValueType().equals(INITIAL_COST)) {
                    componentCost.setComponentInitialCost(QesCostExtension.getComponentCost(numericValueTransformation.getTransformationType(), numericValueTransformation.getTransformationNumber(), componentCost.getInitialCost()));
                    continue;
                }
                if (!numericValueTransformation.getValueType().equals(OPERATING_COST)) continue;
                componentCost.setComponentOperatingCost(QesCostExtension.getComponentCost(numericValueTransformation.getTransformationType(), numericValueTransformation.getTransformationNumber(), componentCost.getOperatingCost()));
            }
        }
    }

    public void updateModel(PCMInstance pcmInstance) {
        if (this.specifications == null || this.specifications.isEmpty()) {
            return;
        }
        this.finder = new QesFinder(pcmInstance);
    }
}

