/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.dsexplore.analysis.lqn;

import de.uka.ipd.sdq.dsexplore.analysis.AbstractPerformanceAnalysisResult;
import de.uka.ipd.sdq.dsexplore.analysis.AnalysisFailedException;
import de.uka.ipd.sdq.dsexplore.analysis.lqn.ILQNResult;
import de.uka.ipd.sdq.dsexplore.analysis.lqn.LQNQualityAttributeDeclaration;
import de.uka.ipd.sdq.dsexplore.analysis.lqn.LQNUtils;
import de.uka.ipd.sdq.dsexplore.helper.EMFHelper;
import de.uka.ipd.sdq.dsexplore.qml.pcm.datastructures.EntryLevelSystemCallCriterion;
import de.uka.ipd.sdq.dsexplore.qml.pcm.datastructures.EvaluationAspectWithContext;
import de.uka.ipd.sdq.dsexplore.qml.pcm.datastructures.UsageScenarioBasedCriterion;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.opt4j.core.Criterion;
import org.palladiosimulator.analyzer.resultdecorator.ResultDecoratorRepository;
import org.palladiosimulator.analyzer.resultdecorator.ResultdecoratorFactory;
import org.palladiosimulator.analyzer.resultdecorator.repositorydecorator.AllocationServiceResult;
import org.palladiosimulator.analyzer.resultdecorator.repositorydecorator.RepositorydecoratorFactory;
import org.palladiosimulator.analyzer.resultdecorator.repositorydecorator.ServiceResult;
import org.palladiosimulator.analyzer.resultdecorator.resourceenvironmentdecorator.LinkingResourceResults;
import org.palladiosimulator.analyzer.resultdecorator.resourceenvironmentdecorator.PassiveResourceResult;
import org.palladiosimulator.analyzer.resultdecorator.resourceenvironmentdecorator.ProcessingResourceSpecificationResult;
import org.palladiosimulator.analyzer.resultdecorator.resourceenvironmentdecorator.ResourceenvironmentdecoratorFactory;
import org.palladiosimulator.analyzer.resultdecorator.resourceenvironmentdecorator.UtilisationResult;
import org.palladiosimulator.pcm.allocation.Allocation;
import org.palladiosimulator.pcm.allocation.AllocationContext;
import org.palladiosimulator.pcm.core.composition.AssemblyContext;
import org.palladiosimulator.pcm.core.entity.Entity;
import org.palladiosimulator.pcm.repository.BasicComponent;
import org.palladiosimulator.pcm.repository.OperationSignature;
import org.palladiosimulator.pcm.repository.PassiveResource;
import org.palladiosimulator.pcm.repository.Repository;
import org.palladiosimulator.pcm.repository.RepositoryComponent;
import org.palladiosimulator.pcm.resourceenvironment.LinkingResource;
import org.palladiosimulator.pcm.resourceenvironment.ProcessingResourceSpecification;
import org.palladiosimulator.pcm.resourceenvironment.ResourceContainer;
import org.palladiosimulator.pcm.resourcetype.CommunicationLinkResourceType;
import org.palladiosimulator.pcm.resourcetype.ProcessingResourceType;
import org.palladiosimulator.pcm.seff.ServiceEffectSpecification;
import org.palladiosimulator.pcm.usagemodel.EntryLevelSystemCall;
import org.palladiosimulator.pcm.usagemodel.UsageScenario;
import org.palladiosimulator.solver.core.models.PCMInstance;
import org.palladiosimulator.solver.lqn.ActivityDefType;
import org.palladiosimulator.solver.lqn.ActivityPhasesType;
import org.palladiosimulator.solver.lqn.EntryType;
import org.palladiosimulator.solver.lqn.LqnModelType;
import org.palladiosimulator.solver.lqn.OutputResultType;
import org.palladiosimulator.solver.lqn.ProcessorType;
import org.palladiosimulator.solver.lqn.TaskType;
import org.palladiosimulator.solver.transformations.pcm2lqn.Pcm2LqnHelper;

public abstract class LQNResult
extends AbstractPerformanceAnalysisResult
implements ILQNResult {
    protected static Logger logger = Logger.getLogger((String)"de.uka.ipd.sdq.dsexplore");
    protected double meanResponseTime;
    protected double throughput;
    protected double maxUtilization;
    protected double squaredCoeffVariance = 1.0;
    private Map<Criterion, EvaluationAspectWithContext> objectiveToAspects;
    private LQNQualityAttributeDeclaration qualityAttributeInfo;

    public LQNResult(PCMInstance pcm, LqnModelType model, Criterion criterion, Map<Criterion, EvaluationAspectWithContext> objectiveToAspect, LQNQualityAttributeDeclaration qualityAttributeInfo) throws AnalysisFailedException {
        super(pcm);
        try {
            this.objectiveToAspects = objectiveToAspect;
            this.qualityAttributeInfo = qualityAttributeInfo;
            if (criterion instanceof UsageScenarioBasedCriterion) {
                this.meanResponseTime = this.retrieveResponseTimeForUsageScenario(pcm, model, (UsageScenarioBasedCriterion)criterion);
                this.throughput = this.retrieveThroughputForUsageScenario(pcm, model, (UsageScenarioBasedCriterion)criterion);
            } else if (criterion instanceof EntryLevelSystemCallCriterion) {
                this.meanResponseTime = this.retrieveResponseTimeForEntryLevelSystemCall(pcm, model, (EntryLevelSystemCallCriterion)criterion);
                this.throughput = this.retrieveThroughputForEntryLevelSystemCall(pcm, model, (EntryLevelSystemCallCriterion)criterion);
            } else {
                throw new AnalysisFailedException("Unknown criterion type " + criterion.getClass().getName());
            }
            this.results = this.retrieveResults(pcm, model);
            this.maxUtilization = this.retrieveMaxUtilization(pcm, model, this.results, "CPU");
        }
        catch (ParseException ex) {
            throw new AnalysisFailedException("Failed to parse string value.", (Throwable)ex);
        }
    }

    private double retrieveMaxUtilization(PCMInstance pcm, LqnModelType model, ResultDecoratorRepository results2, String resourceTypeDescription) {
        double maxUtil = 0.0;
        for (UtilisationResult utilResult : results2.getUtilisationResults_ResultDecoratorRepository()) {
            ProcessingResourceSpecificationResult procResult;
            if (!(utilResult instanceof ProcessingResourceSpecificationResult) || !(procResult = (ProcessingResourceSpecificationResult)utilResult).getProcessingResourceSpecification_ProcessingResourceSpecificationResult().getActiveResourceType_ActiveResourceSpecification().getEntityName().contains(resourceTypeDescription) || !(maxUtil < procResult.getResourceUtilisation())) continue;
            maxUtil = procResult.getResourceUtilisation();
        }
        return maxUtil;
    }

    private ResultDecoratorRepository retrieveResults(PCMInstance pcm, LqnModelType model) throws ParseException {
        ResultDecoratorRepository repo = ResultdecoratorFactory.eINSTANCE.createResultDecoratorRepository();
        List<ProcessorType> modifiableProcessorList = this.retrieveResourceEnvironmentResults(pcm, model, repo);
        this.retrieveServiceResults(pcm, repo, modifiableProcessorList);
        return repo;
    }

    private void retrieveServiceResults(PCMInstance pcm, ResultDecoratorRepository repo, List<ProcessorType> modifiableProcessorList) throws ParseException {
        List repositories = pcm.getRepositories();
        for (Repository repository : repositories) {
            EList repoComponentList = repository.getComponents__Repository();
            for (RepositoryComponent repositoryComponent : repoComponentList) {
                if (!(repositoryComponent instanceof BasicComponent)) continue;
                BasicComponent basicComponent = (BasicComponent)repositoryComponent;
                List<ServiceResult> serviceResultList = this.getServiceResults(basicComponent, modifiableProcessorList);
                repo.getServiceResult_ResultDecoratorRepository().addAll(serviceResultList);
            }
        }
    }

    private List<ProcessorType> retrieveResourceEnvironmentResults(PCMInstance pcm, LqnModelType model, ResultDecoratorRepository repo) throws ParseException {
        EList processors = model.getProcessor();
        EList containers = pcm.getResourceEnvironment().getResourceContainer_ResourceEnvironment();
        ArrayList<ProcessorType> modifiableProcessorList = new ArrayList<ProcessorType>(processors.size());
        modifiableProcessorList.addAll((Collection<ProcessorType>)processors);
        for (ResourceContainer container : containers) {
            for (ProcessingResourceSpecification pcmResource : container.getActiveResourceSpecifications_ResourceContainer()) {
                String processorID = String.valueOf(Pcm2LqnHelper.getIdForProcResource((Entity)container, (ProcessingResourceType)pcmResource.getActiveResourceType_ActiveResourceSpecification())) + "_Processor";
                ProcessingResourceSpecificationResult result = ResourceenvironmentdecoratorFactory.eINSTANCE.createProcessingResourceSpecificationResult();
                this.retrieveUtilResultFromLQN(modifiableProcessorList, processorID, (UtilisationResult)result);
                result.setProcessingResourceSpecification_ProcessingResourceSpecificationResult(pcmResource);
                result.setEntityName("Utilisation of " + processorID);
                repo.getUtilisationResults_ResultDecoratorRepository().add((Object)result);
            }
        }
        EList links = pcm.getResourceEnvironment().getLinkingResources__ResourceEnvironment();
        for (LinkingResource linkingResource : links) {
            String processorID = String.valueOf(Pcm2LqnHelper.getIdForCommResource((LinkingResource)linkingResource, (CommunicationLinkResourceType)linkingResource.getCommunicationLinkResourceSpecifications_LinkingResource().getCommunicationLinkResourceType_CommunicationLinkResourceSpecification())) + "_Processor";
            LinkingResourceResults result = ResourceenvironmentdecoratorFactory.eINSTANCE.createLinkingResourceResults();
            this.retrieveUtilResultFromLQN(modifiableProcessorList, processorID, (UtilisationResult)result);
            result.setLinkingResource_LinkingResourceResults(linkingResource);
            result.setEntityName("Utilisation of " + processorID);
            repo.getUtilisationResults_ResultDecoratorRepository().add((Object)result);
        }
        List allAssemblyContexts = EMFHelper.getAllUsedAllocationContexts((Allocation)pcm.getAllocation());
        for (AllocationContext allocContext : allAssemblyContexts) {
            AssemblyContext assemblyContext = allocContext.getAssemblyContext_AllocationContext();
            RepositoryComponent innerComponent = assemblyContext.getEncapsulatedComponent__AssemblyContext();
            if (!(innerComponent instanceof BasicComponent)) continue;
            BasicComponent basicComponent = (BasicComponent)innerComponent;
            EList passiveResourceOfComponentList = basicComponent.getPassiveResource_BasicComponent();
            for (PassiveResource passiveResource : passiveResourceOfComponentList) {
                String passiveResourceId = Pcm2LqnHelper.getIdForPassiveResource((PassiveResource)passiveResource, (AllocationContext)allocContext);
                PassiveResourceResult result = ResourceenvironmentdecoratorFactory.eINSTANCE.createPassiveResourceResult();
                this.retrieveUtilResultFromLQN(modifiableProcessorList, passiveResourceId, (UtilisationResult)result);
                result.setPassiveResource_PassiveResourceResult(passiveResource);
                result.setAssemblyContext_PassiveResourceResult(assemblyContext);
                result.setEntityName("Utilisation of " + passiveResourceId);
                repo.getUtilisationResults_ResultDecoratorRepository().add((Object)result);
            }
        }
        return modifiableProcessorList;
    }

    private void retrieveUtilResultFromLQN(List<ProcessorType> modifiableProcessorList, String processorID, UtilisationResult result) throws ParseException {
        Iterator<ProcessorType> lqnProcessorIterator = modifiableProcessorList.iterator();
        while (lqnProcessorIterator.hasNext()) {
            ProcessorType lqnProc = lqnProcessorIterator.next();
            if (!lqnProc.getName().contains(processorID)) continue;
            EList lqnResultProc = lqnProc.getResultProcessor();
            if (lqnResultProc.size() > 0) {
                OutputResultType processorResult = (OutputResultType)lqnResultProc.get(0);
                result.setResourceUtilisation(processorResult.getUtilization());
                double waitingTime = 0.0;
                double serviceTime = 0.0;
                double totalThroughput = 0.0;
                EList resultTask = lqnProc.getTask();
                if (resultTask.size() > 0) {
                    EList procTaskEntries = ((TaskType)resultTask.get(0)).getEntry();
                    for (EntryType entryType : procTaskEntries) {
                        EList activityResults;
                        EList entryResults = entryType.getResultEntry();
                        if (entryResults.size() <= 0) continue;
                        OutputResultType entryResult = (OutputResultType)entryResults.get(0);
                        EList entryPhaseActivities = entryType.getEntryPhaseActivities().getActivity();
                        if (entryPhaseActivities.size() <= 0 || (activityResults = ((ActivityPhasesType)entryPhaseActivities.get(0)).getResultActivity()).size() <= 0) continue;
                        double throughput = entryResult.getThroughput();
                        double entryWaitingTime = ((OutputResultType)activityResults.get(0)).getProcWaiting();
                        double entryServiceTime = ((OutputResultType)activityResults.get(0)).getServiceTime();
                        if (!(entryServiceTime > 0.0)) continue;
                        waitingTime = entryWaitingTime * throughput;
                        serviceTime = entryServiceTime * throughput;
                        totalThroughput += throughput;
                    }
                    if (totalThroughput > 0.0 && serviceTime > 0.0) {
                        result.setAverageQueueLength((waitingTime /= totalThroughput) / (serviceTime /= totalThroughput));
                        result.setAverageWaitTime(waitingTime);
                        if (result instanceof ProcessingResourceSpecificationResult) {
                            ((ProcessingResourceSpecificationResult)result).setDemandedTime(serviceTime);
                        }
                    }
                }
                logger.debug((Object)("Resource " + processorID + " has utilisation " + processorResult.getUtilization() + " and waiting time " + result.getAverageQueueLength()));
            }
            lqnProcessorIterator.remove();
        }
    }

    private List<ServiceResult> getServiceResults(BasicComponent basicComponent, List<ProcessorType> modifiableProcessorResultList) throws ParseException {
        EList seffList = basicComponent.getServiceEffectSpecifications__BasicComponent();
        ArrayList<ServiceResult> results = new ArrayList<ServiceResult>(seffList.size());
        for (ServiceEffectSpecification seff : seffList) {
            double overallThroughput = 0.0;
            double responseTimesTimesThroughputSum = 0.0;
            String processorIDRegex = String.valueOf(basicComponent.getEntityName()) + "_" + ((OperationSignature)seff.getDescribedService__SEFF()).getInterface__OperationSignature().getEntityName() + "_" + seff.getDescribedService__SEFF().getEntityName();
            ProcessorType processor = null;
            Iterator<ProcessorType> itProcessors = modifiableProcessorResultList.iterator();
            while (itProcessors.hasNext()) {
                ProcessorType proc = itProcessors.next();
                if (!proc.getName().contains(processorIDRegex) || !proc.getName().contains("_Processor")) continue;
                processor = proc;
                itProcessors.remove();
                EList taskList = processor.getTask();
                if (taskList.size() <= 0) continue;
                double responseTime = LQNUtils.getResponseTimeOfSubActivities((TaskType)taskList.get(0));
                double throughput = 0.0;
                EList procTaskEntries = ((TaskType)taskList.get(0)).getEntry();
                for (EntryType entryType : procTaskEntries) {
                    EList entryResults = entryType.getResultEntry();
                    if (entryResults.size() <= 0) continue;
                    OutputResultType entryResult = (OutputResultType)entryResults.get(0);
                    throughput += entryResult.getThroughput();
                }
                responseTimesTimesThroughputSum += responseTime * throughput;
                overallThroughput += throughput;
            }
            if (!(overallThroughput > 0.0)) continue;
            double overallResponseTime = responseTimesTimesThroughputSum / overallThroughput;
            AllocationServiceResult serviceResult = RepositorydecoratorFactory.eINSTANCE.createAllocationServiceResult();
            serviceResult.setServiceEffectSpecification_ServiceResult(seff);
            serviceResult.setMeanResponseTime(overallResponseTime);
            results.add((ServiceResult)serviceResult);
        }
        return results;
    }

    private double retrieveResponseTimeForUsageScenario(PCMInstance pcm, LqnModelType model, UsageScenarioBasedCriterion criterion) throws ParseException, AnalysisFailedException {
        TaskType task;
        ProcessorType processor = this.getUsageScenarioProcessor(pcm, model, criterion.getUsageScenario());
        if (processor != null && processor.getTask() != null && processor.getTask().size() > 0 && (task = (TaskType)processor.getTask().get(0)) != null) {
            double responseTime = Double.NaN;
            if (task.getResultTask().size() > 0) {
                OutputResultType outputResult = (OutputResultType)task.getResultTask().get(0);
                if (outputResult != null) {
                    responseTime = LQNUtils.getResponseTimeOfSubActivities(task);
                    this.squaredCoeffVariance = outputResult.getSquaredCoeffVariation();
                }
                return responseTime;
            }
        }
        logger.warn((Object)("No task or empty task for processor " + processor.getName() + ". Cannot determine response time, using NaN. Check your models or the LQNResult code."));
        return Double.NaN;
    }

    private double retrieveResponseTimeForEntryLevelSystemCall(PCMInstance pcm, LqnModelType model, EntryLevelSystemCallCriterion criterion) throws AnalysisFailedException, ParseException {
        OutputResultType entryLevelCallActivityResult;
        ProcessorType usageScenarioProcessor = this.getUsageScenarioProcessor(pcm, model, criterion);
        if (usageScenarioProcessor != null && usageScenarioProcessor.getTask() != null && usageScenarioProcessor.getTask().size() > 0 && (entryLevelCallActivityResult = this.getResultActivityForEntryLevelSystemCall(criterion, usageScenarioProcessor)) != null) {
            return entryLevelCallActivityResult.getServiceTime();
        }
        logger.warn((Object)("No task or empty task for processor or empty activity results" + usageScenarioProcessor.getName() + ". Cannot determine response time, using NaN. A possible cause is that the network is overloaded and the LQN analysis was aborted. Otherwise, check your models or the LQNResult code."));
        return Double.NaN;
    }

    private OutputResultType getResultActivityForEntryLevelSystemCall(EntryLevelSystemCallCriterion criterion, ProcessorType usageScenarioProcessor) {
        TreeIterator allProcessorContentIterator;
        TaskType task = (TaskType)usageScenarioProcessor.getTask().get(0);
        String entryLevelCallId = Pcm2LqnHelper.getIdForEntryLevelSystemCall((EntryLevelSystemCall)criterion.getEntryLevelSystemCall());
        OutputResultType activity = this.findActivityForEntryLevelCallById(entryLevelCallId, (TreeIterator<Object>)(allProcessorContentIterator = EcoreUtil.getAllContents((Collection)task.getTaskActivities().getActivity(), (boolean)true)));
        if (activity == null) {
            TreeIterator allContentIterator = EcoreUtil.getAllContents((EObject)usageScenarioProcessor.eContainer(), (boolean)true);
            activity = this.findActivityForEntryLevelCallById(entryLevelCallId, (TreeIterator<Object>)allContentIterator);
        }
        return activity;
    }

    private OutputResultType findActivityForEntryLevelCallById(String entryLevelCallId, TreeIterator<Object> allProcessorContentIterator) {
        while (allProcessorContentIterator.hasNext()) {
            OutputResultType activityResult;
            Object object = allProcessorContentIterator.next();
            if (!(object instanceof ActivityDefType) || !((ActivityDefType)object).getName().equals(entryLevelCallId) || ((ActivityDefType)object).getResultActivity() == null || ((ActivityDefType)object).getResultActivity().size() <= 0 || (activityResult = (OutputResultType)((ActivityDefType)object).getResultActivity().get(0)) == null) continue;
            return activityResult;
        }
        return null;
    }

    private double retrieveThroughputForUsageScenario(PCMInstance pcm, LqnModelType model, UsageScenarioBasedCriterion criterion) throws AnalysisFailedException, ParseException {
        OutputResultType outputResult;
        TaskType usageScenarioTask;
        ProcessorType processor = this.getUsageScenarioProcessor(pcm, model, criterion);
        if (processor.getTask() != null && processor.getTask().size() > 0 && (usageScenarioTask = (TaskType)processor.getTask().get(0)) != null && usageScenarioTask.getResultTask().size() > 0 && (outputResult = (OutputResultType)usageScenarioTask.getResultTask().get(0)) != null) {
            return outputResult.getThroughput();
        }
        logger.warn((Object)("No task or empty task for processor or empty activity results" + processor.getName() + ". Cannot determine throughput, using NaN. Check your models or the LQNResult code."));
        return Double.NaN;
    }

    private double retrieveThroughputForEntryLevelSystemCall(PCMInstance pcm, LqnModelType model, EntryLevelSystemCallCriterion criterion) throws AnalysisFailedException, ParseException {
        OutputResultType entryLevelCallActivityResult;
        ProcessorType usageScenarioProcessor = this.getUsageScenarioProcessor(pcm, model, criterion);
        if (usageScenarioProcessor != null && usageScenarioProcessor.getTask() != null && usageScenarioProcessor.getTask().size() > 0 && (entryLevelCallActivityResult = this.getResultActivityForEntryLevelSystemCall(criterion, usageScenarioProcessor)) != null) {
            return entryLevelCallActivityResult.getThroughput();
        }
        logger.warn((Object)("No task or empty task for processor or empty activity results" + usageScenarioProcessor.getName() + ". Cannot determine throughput, using NaN. Check your models or the LQNResult code."));
        return Double.NaN;
    }

    private ProcessorType getUsageScenarioProcessor(PCMInstance pcm, LqnModelType model, UsageScenarioBasedCriterion criterion) throws AnalysisFailedException {
        UsageScenario currentUsageScenaro = null;
        EList scenarios = pcm.getUsageModel().getUsageScenario_UsageModel();
        Iterator iterator = scenarios.iterator();
        if (iterator.hasNext()) {
            UsageScenario usageScenario = (UsageScenario)iterator.next();
            usageScenario.getId().equals(criterion.getUsageScenario().getId());
            currentUsageScenaro = usageScenario;
        }
        return this.getUsageScenarioProcessor(pcm, model, currentUsageScenaro);
    }

    private ProcessorType getUsageScenarioProcessor(PCMInstance pcm, LqnModelType model, EntryLevelSystemCallCriterion criterion) throws AnalysisFailedException {
        UsageScenario currentUsageScenaro = null;
        EList scenarios = pcm.getUsageModel().getUsageScenario_UsageModel();
        UsageScenario scenarioToLookFor = this.getUsageScenarioOfEObject((EObject)criterion.getEntryLevelSystemCall());
        for (UsageScenario usageScenario : scenarios) {
            if (!usageScenario.getId().equals(scenarioToLookFor.getId())) continue;
            currentUsageScenaro = usageScenario;
            break;
        }
        return this.getUsageScenarioProcessor(pcm, model, currentUsageScenaro);
    }

    private UsageScenario getUsageScenarioOfEObject(EObject object) {
        EObject container = object.eContainer();
        if (container instanceof UsageScenario) {
            return (UsageScenario)container;
        }
        if (container != null) {
            return this.getUsageScenarioOfEObject(container);
        }
        return null;
    }

    private ProcessorType getUsageScenarioProcessor(PCMInstance pcm, LqnModelType model, UsageScenario currentUsageScenaro) throws AnalysisFailedException {
        if (currentUsageScenaro == null) {
            throw new AnalysisFailedException("Could not analyse LQN results, because the usage scenario from references QML Criterion is not contained in this PCM model's usage model.");
        }
        String scenarioName = Pcm2LqnHelper.getIdForUsageScenario((UsageScenario)currentUsageScenaro);
        scenarioName = scenarioName.substring(0, scenarioName.lastIndexOf("_"));
        String processorNameRegex = String.valueOf(scenarioName) + "_\\d+_Processor";
        ProcessorType processor = null;
        for (ProcessorType proc : model.getProcessor()) {
            if (!proc.getName().matches(processorNameRegex)) continue;
            processor = proc;
            break;
        }
        if (processor == null) {
            logger.warn((Object)("Could not find LQN processor matching name " + processorNameRegex + ". Cannot determine response time, using NaN. Check your models or the LQNResult code."));
        }
        return processor;
    }

    @Override
    public double getMedianValue() {
        return Double.NaN;
    }

    public double getValueFor(Criterion criterion) {
        EvaluationAspectWithContext aspect = this.objectiveToAspects.get(criterion);
        if (aspect != null) {
            if (EcoreUtil.equals((EObject)aspect.getDimension(), (EObject)this.qualityAttributeInfo.getResponseTime())) {
                return this.getMeanValue();
            }
            if (EcoreUtil.equals((EObject)aspect.getDimension(), (EObject)this.qualityAttributeInfo.getThroughput())) {
                return this.getThroughput();
            }
            if (EcoreUtil.equals((EObject)aspect.getDimension(), (EObject)this.qualityAttributeInfo.getMaxUtilization())) {
                return this.getMaxUtilisation();
            }
        }
        logger.warn((Object)"Unknown aspect for LQN result, adding NaN.");
        return Double.NaN;
    }

    @Override
    public double getMeanValue() {
        return this.meanResponseTime;
    }

    public double getThroughput() {
        return this.throughput;
    }

    public double getMaxUtilisation() {
        return this.maxUtilization;
    }

    @Override
    public double getSquaredCoefficientOfVariance() {
        return this.squaredCoeffVariance;
    }

    @Override
    public double getCoefficientOfVariance() {
        return Math.sqrt(this.squaredCoeffVariance);
    }

    @Override
    public double getVariance() {
        double var = this.getSquaredCoefficientOfVariance() * this.getMeanValue() * this.getMeanValue();
        return var;
    }

    @Override
    public double getStandardDeviation() {
        double std = Math.sqrt(this.getVariance());
        return std;
    }
}

