/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.dsexplore.analysis.simucom;

import de.uka.ipd.sdq.codegen.simucontroller.core.runconfig.SimuComWorkflowConfiguration;
import de.uka.ipd.sdq.codegen.simucontroller.workflow.jobs.SimuComJob;
import de.uka.ipd.sdq.dsexplore.analysis.AbstractAnalysis;
import de.uka.ipd.sdq.dsexplore.analysis.AnalysisFailedException;
import de.uka.ipd.sdq.dsexplore.analysis.IAnalysis;
import de.uka.ipd.sdq.dsexplore.analysis.IAnalysisQualityAttributeDeclaration;
import de.uka.ipd.sdq.dsexplore.analysis.IStatisticAnalysisResult;
import de.uka.ipd.sdq.dsexplore.analysis.PCMPhenotype;
import de.uka.ipd.sdq.dsexplore.analysis.simucom.DSESimuComWorkflowLauncher;
import de.uka.ipd.sdq.dsexplore.analysis.simucom.SimuComAnalysisEDP2Result;
import de.uka.ipd.sdq.dsexplore.analysis.simucom.SimuComAnalysisSensorFrameworkResult;
import de.uka.ipd.sdq.dsexplore.analysis.simucom.SimuComQualityAttributeDeclaration;
import de.uka.ipd.sdq.dsexplore.exception.ExceptionHelper;
import de.uka.ipd.sdq.dsexplore.launch.DSEConstantsContainer;
import de.uka.ipd.sdq.dsexplore.launch.DSEWorkflowConfiguration;
import de.uka.ipd.sdq.dsexplore.qml.pcm.datastructures.EntryLevelSystemCallCriterion;
import de.uka.ipd.sdq.dsexplore.qml.pcm.datastructures.UsageScenarioBasedCriterion;
import de.uka.ipd.sdq.workflow.blackboard.Blackboard;
import de.uka.ipd.sdq.workflow.jobs.CleanupFailedException;
import de.uka.ipd.sdq.workflow.jobs.JobFailedException;
import de.uka.ipd.sdq.workflow.jobs.UserCanceledException;
import de.uka.ipd.sdq.workflow.mdsd.blackboard.MDSDBlackboard;
import de.uka.ipd.sdq.workflow.mdsd.blackboard.ResourceSetPartition;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.opt4j.core.Criterion;
import org.palladiosimulator.analyzer.workflow.core.blackboard.PCMResourceSetPartition;
import org.palladiosimulator.edp2.models.Repository.Repository;
import org.palladiosimulator.pcm.core.entity.Entity;
import org.palladiosimulator.solver.core.models.PCMInstance;

public class SimuComAnalysis
extends AbstractAnalysis
implements IAnalysis {
    private static Logger logger = Logger.getLogger((String)"de.uka.ipd.sdq.dsexplore");
    private ILaunchConfiguration config;
    private String initialExperimentName;
    private final Map<Integer, String> previousExperimentNames = new HashMap<Integer, String>();
    private SimuComWorkflowConfiguration simuComWorkflowConfiguration;
    private int datasourceReloadCount = 1;

    public SimuComAnalysis() {
        super((IAnalysisQualityAttributeDeclaration)new SimuComQualityAttributeDeclaration());
    }

    public void analyse(PCMPhenotype pheno, IProgressMonitor monitor) throws AnalysisFailedException, CoreException, UserCanceledException {
        String experimentName = this.getExperimentName(pheno);
        String experimentSettingName = this.getExperimentSettingName(pheno);
        this.previousExperimentNames.put(pheno.getGenotypeID().hashCode(), experimentSettingName);
        ILaunchConfigurationWorkingCopy launchWorkingCopy = this.config.getWorkingCopy();
        launchWorkingCopy.setAttribute("experimentRun", experimentName);
        launchWorkingCopy.setAttribute("variationId", experimentSettingName);
        this.simuComWorkflowConfiguration = new DSESimuComWorkflowLauncher().deriveConfiguration((ILaunchConfiguration)launchWorkingCopy);
        this.simuComWorkflowConfiguration.setOverwriteWithoutAsking(true);
        System.gc();
        if (this.isExperimentRunDoesNotExist(experimentName, experimentSettingName)) {
            this.launchSimuCom(monitor);
        }
    }

    private boolean isExperimentRunDoesNotExist(String experimentName, String experimentSettingName) throws CoreException {
        if (this.config.getAttribute("persistenceFramework", "").equals("SensorFramework")) {
            return !SimuComAnalysisSensorFrameworkResult.isExperimentRunExisting(experimentName, this.simuComWorkflowConfiguration, this.datasourceReloadCount, this.config);
        }
        return !SimuComAnalysisEDP2Result.isExperimentRunExisting(experimentName, experimentSettingName, SimuComAnalysisEDP2Result.findSelectedEDP2Repository(this.config));
    }

    private String getExperimentName(PCMPhenotype pheno) throws CoreException {
        if (this.config.getAttribute("persistenceFramework", "").equals("SensorFramework")) {
            return String.valueOf(this.initialExperimentName) + " " + pheno.getGenotypeID();
        }
        return this.initialExperimentName;
    }

    private String getExperimentSettingName(PCMPhenotype pheno) throws CoreException {
        return pheno.getGenotypeID();
    }

    private IStatisticAnalysisResult retrieveSimuComResults(PCMPhenotype pheno, Entity entity) throws CoreException, AnalysisFailedException {
        String experimentName = this.getExperimentName(pheno);
        String experimentSettingName = this.getExperimentSettingName(pheno);
        PCMResourceSetPartition pcmPartition = (PCMResourceSetPartition)this.blackboard.getPartition("org.palladiosimulator.pcmmodels.partition");
        PCMInstance pcmInstance = new PCMInstance(pcmPartition);
        SimuComAnalysisSensorFrameworkResult result = null;
        if ("SensorFramework".equals(this.config.getAttribute("persistenceFramework", ""))) {
            result = new SimuComAnalysisSensorFrameworkResult(entity, experimentName, pcmInstance, this.criterionToAspect, (SimuComQualityAttributeDeclaration)this.qualityAttribute, this.config);
            if (result == null) {
                String errormessage = "There was no experiment run or no experiment for experiment named \"" + experimentName + "\" in the selected data source after analysing the PCM instance \"" + experimentName + "\" of candidate " + pheno.getNumericID() + " " + pheno.getGenotypeID();
                logger.error((Object)errormessage);
                throw new AnalysisFailedException(errormessage);
            }
        } else {
            Repository selectedRepo = SimuComAnalysisEDP2Result.findSelectedEDP2Repository(this.config);
            result = SimuComAnalysisEDP2Result.findExperimentRunAndCreateResult(entity, experimentName, experimentSettingName, pcmInstance, selectedRepo, this.criterionToAspect, (SimuComQualityAttributeDeclaration)this.qualityAttribute);
            if (result == null) {
                String errormessage = "There was no experiment named \"" + experimentName + "\" with an experiment setting \"" + experimentSettingName + "\"" + " in the selected data source after analysing the PCM instance \"" + experimentName + "\" of candidate " + pheno.getNumericID() + " " + pheno.getGenotypeID();
                logger.error((Object)errormessage);
                throw new AnalysisFailedException(errormessage);
            }
        }
        return result;
    }

    private void launchSimuCom(IProgressMonitor monitor) throws CoreException, AnalysisFailedException, UserCanceledException {
        String featureConfigFile = this.simuComWorkflowConfiguration.getFeatureConfigFile();
        if (featureConfigFile != null && !"".equals(featureConfigFile)) {
            ResourceSetPartition pcmPartition = (ResourceSetPartition)this.blackboard.getPartition("org.palladiosimulator.pcmmodels.partition");
            pcmPartition.loadModel(featureConfigFile);
        }
        this.simuComWorkflowConfiguration.setInteractive(false);
        SimuComJob job = new SimuComJob(this.simuComWorkflowConfiguration, null, false);
        job.setBlackboard((Blackboard)this.blackboard);
        int i = 0;
        while (i < 2) {
            try {
                job.execute(monitor);
                logger.debug((Object)"Finished SimuCom analysis");
                break;
            }
            catch (JobFailedException e) {
                String causingErrorMessage;
                logger.error((Object)e.getMessage());
                if (e.getCause() == null || (causingErrorMessage = e.getCause().getMessage()) == null || !causingErrorMessage.contains("Couldn't find extension")) {
                    try {
                        job.cleanup(monitor);
                    }
                    catch (CleanupFailedException e1) {
                        logger.error((Object)"Cleanup of failed simucoim run failed, probably you need to clean up manually (e.g. delete temorary plugin);");
                        e1.printStackTrace();
                    }
                    throw new AnalysisFailedException((Throwable)e);
                }
                logger.warn((Object)"Trying to start SimuCom again.");
                ++i;
            }
        }
    }

    public void initialise(DSEWorkflowConfiguration configuration) throws CoreException {
        this.previousExperimentNames.clear();
        this.config = configuration.getRawConfiguration();
        if (this.blackboard == null) {
            throw ExceptionHelper.createNewCoreException((String)"Error in initialisation: No Blackboard was set when initialising the SimuCom Analysis. Contact the developers.");
        }
        this.initialExperimentName = this.config.getAttribute("experimentRun", "");
        this.initialiseCriteria(configuration);
    }

    public IStatisticAnalysisResult retrieveResultsFor(PCMPhenotype pheno, Criterion criterion) throws CoreException, AnalysisFailedException {
        Entity entity = this.getPCMEntityForCriterion(criterion);
        return this.retrieveSimuComResults(pheno, entity);
    }

    private Entity getPCMEntityForCriterion(Criterion criterion) throws CoreException {
        if (criterion instanceof UsageScenarioBasedCriterion) {
            return ((UsageScenarioBasedCriterion)criterion).getUsageScenario();
        }
        if (criterion instanceof EntryLevelSystemCallCriterion) {
            return ((EntryLevelSystemCallCriterion)criterion).getEntryLevelSystemCall();
        }
        throw new CoreException((IStatus)new Status(4, "de.uka.ipd.sdq.dsexplore.analysis.simucom", "Cannot handle Criterion of type " + criterion.getClass() + ". Required is UsageScenarioBasedCriterion or EntryLevelSystemCallCriterion."));
    }

    public DSEConstantsContainer.QualityAttribute getQualityAttribute() throws CoreException {
        return this.qualityAttribute.getQualityAttribute();
    }

    public boolean hasStatisticResultsFor() throws CoreException {
        return true;
    }

    public boolean hasObjectivePerUsageScenario() throws CoreException {
        return true;
    }

    public void setBlackboard(MDSDBlackboard blackboard) {
        this.blackboard = blackboard;
    }
}

