/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.dsexplore.analysis.simulizar;

import de.uka.ipd.sdq.workflow.jobs.CleanupFailedException;
import de.uka.ipd.sdq.workflow.jobs.IJob;
import de.uka.ipd.sdq.workflow.jobs.JobFailedException;
import de.uka.ipd.sdq.workflow.jobs.UserCanceledException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.palladiosimulator.simulizar.core.runconfig.SimuLizarWorkflowConfiguration;

public class PathChangerJob
implements IJob {
    private final SimuLizarWorkflowConfiguration configuration;
    private String basePath;

    public PathChangerJob(SimuLizarWorkflowConfiguration configuration) {
        this.configuration = configuration;
    }

    public void execute(IProgressMonitor monitor) throws JobFailedException, UserCanceledException {
        this.basePath = "platform:/resource/" + this.configuration.getStoragePluginID() + "/model/platform/resource/" + this.configuration.getBaseProjectID();
        this.setAllocationFiles();
        this.setUsageFile();
        this.setModelPaths();
    }

    private void setAllocationFiles() {
        this.configuration.setAllocationFiles(this.changePaths(this.configuration.getAllocationFiles()));
    }

    private void setUsageFile() {
        this.configuration.setUsageModelFile(this.changePath(this.configuration.getUsageModelFile()));
    }

    private void setModelPaths() {
        this.configuration.setModelPaths(this.changePaths(this.configuration.getModelPaths()));
    }

    private List<String> changePaths(List<String> models) {
        ArrayList<String> result = new ArrayList<String>();
        for (String model : models) {
            result.add(this.changePath(model));
        }
        return result;
    }

    private String changePath(String model) {
        if (model.startsWith("pathmap") || model.contains("cand.")) {
            return model;
        }
        String file = model.split(this.configuration.getBaseProjectID())[1];
        String newFileName = this.newFileName(file);
        return String.valueOf(this.basePath) + newFileName;
    }

    private String fileWithoutExtension(String file) {
        return file.substring(0, file.lastIndexOf(46));
    }

    private String newFileName(String file) {
        String ending = file.substring(file.lastIndexOf(46));
        if (file.endsWith(String.valueOf(ending) + "cand" + ending)) {
            return file;
        }
        return String.valueOf(this.fileWithoutExtension(file)) + ending + "cand" + ending;
    }

    public void cleanup(IProgressMonitor monitor) throws CleanupFailedException {
    }

    public String getName() {
        return "PathChanger";
    }
}

