/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.dsexplore.bayesnets.utility;

import de.uka.ipd.sdq.dsexplore.bayesnets.utility.BayesNetwork;
import java.util.ArrayList;
import java.util.Random;

public class BayesNetworkScore {
    private int[][] Graph;
    private int[][] Data;
    protected static final double SQTPI = 2.5066282746310007;

    public BayesNetworkScore(int[][] GraphMatrix, int[][] DataMatrix) {
        this.Graph = GraphMatrix;
        this.Data = DataMatrix;
    }

    public static void main(String[] args) {
        int[][] nArrayArray = new int[4][];
        int[] nArray = new int[4];
        nArray[1] = 1;
        nArray[2] = 1;
        nArray[3] = 1;
        nArrayArray[0] = nArray;
        int[] nArray2 = new int[4];
        nArray2[2] = 1;
        nArray2[3] = 1;
        nArrayArray[1] = nArray2;
        int[] nArray3 = new int[4];
        nArray3[3] = 1;
        nArrayArray[2] = nArray3;
        nArrayArray[3] = new int[4];
        int[][] GraphNet = nArrayArray;
        int[][] DataMat = new int[16][4];
        Random r = new Random();
        int i = 0;
        while (i < 16) {
            int j = 0;
            while (j < 4) {
                DataMat[i][j] = r.nextInt(2);
                ++j;
            }
            ++i;
        }
        BayesNetworkScore bs = new BayesNetworkScore(GraphNet, DataMat);
        double out = 0.0;
        out = bs.K2NetworkScore();
        System.out.println(bs.getFactorial(5));
        System.out.println(out);
        System.out.println(bs.BDeuNetworkScore());
        System.out.println(bs.LogLik());
        System.out.println(bs.BIC());
        System.out.println(bs.AIC());
        System.out.println(bs.getFactorial(804));
    }

    public double K2NetworkScore() {
        int k;
        int n = this.Data[1].length;
        int r = 2;
        BayesNetwork BN = new BayesNetwork(n);
        int[] q = new int[n];
        int i = 0;
        while (i < n) {
            q[i] = (int)Math.pow(r, BN.getParents(this.Graph, i).length);
            ++i;
        }
        ArrayList<int[][]> w = new ArrayList<int[][]>();
        int i2 = 0;
        while (i2 < n) {
            int[][] w_inter = new int[BN.getParents(this.Graph, i2).length][(int)Math.pow(2.0, BN.getParents(this.Graph, i2).length)];
            int j = 0;
            while (j < BN.getParents(this.Graph, i2).length) {
                int Threshold = (int)Math.pow(2.0, BN.getParents(this.Graph, i2).length - (j + 1));
                int count = 1;
                boolean flip = false;
                k = 0;
                while (k < q[i2]) {
                    if (!flip) {
                        w_inter[j][k] = 0;
                    } else if (flip) {
                        w_inter[j][k] = 1;
                    }
                    if (count % Threshold == 0) {
                        flip = !flip;
                    }
                    ++count;
                    ++k;
                }
                ++j;
            }
            w.add(w_inter);
            ++i2;
        }
        ArrayList<int[][]> N = new ArrayList<int[][]>();
        int i3 = 0;
        while (i3 < n) {
            int[][] N_inter = new int[q[i3]][r];
            int j = 0;
            while (j < q[i3]) {
                int k2 = 0;
                while (k2 < r) {
                    int[] Parents = BN.getParents(this.Graph, i3);
                    int count1 = 0;
                    int id = 0;
                    while (id < this.Data.length) {
                        boolean countvar = true;
                        int ip1 = 0;
                        int[] nArray = Parents;
                        int n2 = Parents.length;
                        int n3 = 0;
                        while (n3 < n2) {
                            int ip = nArray[n3];
                            countvar = ((int[][])w.get(i3))[ip1][j] == this.Data[id][ip] ? (countvar &= true) : (countvar &= false);
                            ++ip1;
                            ++n3;
                        }
                        if (countvar & this.Data[id][i3] == k2) {
                            ++count1;
                        }
                        ++id;
                    }
                    N_inter[j][k2] = count1;
                    ++k2;
                }
                ++j;
            }
            N.add(N_inter);
            ++i3;
        }
        ArrayList<int[]> Nij = new ArrayList<int[]>();
        int i4 = 0;
        while (i4 < n) {
            int[] Nij_inter = new int[q[i4]];
            int j = 0;
            while (j < q[i4]) {
                int count = 0;
                k = 0;
                while (k < r) {
                    count += ((int[][])N.get(i4))[j][k];
                    ++k;
                }
                Nij_inter[j] = count;
                ++j;
            }
            Nij.add(Nij_inter);
            ++i4;
        }
        double score = 0.0;
        int i5 = 0;
        while (i5 < n) {
            int j = 0;
            while (j < q[i5]) {
                double term1count = 0.0;
                int k3 = 0;
                while (k3 < r) {
                    term1count += Math.log(this.getFactorial(((int[][])N.get(i5))[j][k3]));
                    ++k3;
                }
                double term2count = 0.0;
                score = score + term1count + (term2count += Math.log(this.getFactorial(r - 1) / this.getFactorial(((int[])Nij.get(i5))[j] + r - 1)));
                ++j;
            }
            ++i5;
        }
        return score;
    }

    public double BDeuNetworkScore() {
        int k;
        int N_prime = 40;
        int n = this.Data[1].length;
        int r = 2;
        BayesNetwork BN = new BayesNetwork(n);
        int[] q = new int[n];
        int i = 0;
        while (i < n) {
            q[i] = (int)Math.pow(r, BN.getParents(this.Graph, i).length);
            ++i;
        }
        ArrayList<int[][]> w = new ArrayList<int[][]>();
        int i2 = 0;
        while (i2 < n) {
            int[][] w_inter = new int[BN.getParents(this.Graph, i2).length][(int)Math.pow(2.0, BN.getParents(this.Graph, i2).length)];
            int j = 0;
            while (j < BN.getParents(this.Graph, i2).length) {
                int Threshold = (int)Math.pow(2.0, BN.getParents(this.Graph, i2).length - (j + 1));
                int count = 1;
                boolean flip = false;
                k = 0;
                while (k < q[i2]) {
                    if (!flip) {
                        w_inter[j][k] = 0;
                    } else if (flip) {
                        w_inter[j][k] = 1;
                    }
                    if (count % Threshold == 0) {
                        flip = !flip;
                    }
                    ++count;
                    ++k;
                }
                ++j;
            }
            w.add(w_inter);
            ++i2;
        }
        ArrayList<int[][]> N = new ArrayList<int[][]>();
        int i3 = 0;
        while (i3 < n) {
            int[][] N_inter = new int[q[i3]][r];
            int j = 0;
            while (j < q[i3]) {
                int k2 = 0;
                while (k2 < r) {
                    int[] Parents = BN.getParents(this.Graph, i3);
                    int count1 = 0;
                    int id = 0;
                    while (id < this.Data.length) {
                        boolean countvar = true;
                        int ip1 = 0;
                        int[] nArray = Parents;
                        int n2 = Parents.length;
                        int n3 = 0;
                        while (n3 < n2) {
                            int ip = nArray[n3];
                            countvar = ((int[][])w.get(i3))[ip1][j] == this.Data[id][ip] ? (countvar &= true) : (countvar &= false);
                            ++ip1;
                            ++n3;
                        }
                        if (countvar & this.Data[id][i3] == k2) {
                            ++count1;
                        }
                        ++id;
                    }
                    N_inter[j][k2] = count1;
                    ++k2;
                }
                ++j;
            }
            N.add(N_inter);
            ++i3;
        }
        ArrayList<int[]> Nij = new ArrayList<int[]>();
        int i4 = 0;
        while (i4 < n) {
            int[] Nij_inter = new int[q[i4]];
            int j = 0;
            while (j < q[i4]) {
                int count = 0;
                k = 0;
                while (k < r) {
                    count += ((int[][])N.get(i4))[j][k];
                    ++k;
                }
                Nij_inter[j] = count;
                ++j;
            }
            Nij.add(Nij_inter);
            ++i4;
        }
        double score = 0.0;
        int i5 = 0;
        while (i5 < n) {
            int j = 0;
            while (j < q[i5]) {
                double term1count = 0.0;
                int k3 = 0;
                while (k3 < r) {
                    term1count += Math.log(this.gamma((double)((int[][])N.get(i5))[j][k3] + (double)N_prime / ((double)r * (double)q[i5])) / this.gamma((double)N_prime / ((double)r * (double)q[i5])));
                    ++k3;
                }
                double term2count = 0.0;
                score = score + term1count + (term2count += Math.log(this.gamma(N_prime) / (double)q[i5]) / this.gamma((double)((int[])Nij.get(i5))[j] + (double)N_prime / (double)q[i5]));
                ++j;
            }
            ++i5;
        }
        return score;
    }

    public double LogLik() {
        int k;
        int n = this.Data[1].length;
        int r = 2;
        BayesNetwork BN = new BayesNetwork(n);
        int[] q = new int[n];
        int i = 0;
        while (i < n) {
            q[i] = (int)Math.pow(r, BN.getParents(this.Graph, i).length);
            ++i;
        }
        ArrayList<int[][]> w = new ArrayList<int[][]>();
        int i2 = 0;
        while (i2 < n) {
            int[][] w_inter = new int[BN.getParents(this.Graph, i2).length][(int)Math.pow(2.0, BN.getParents(this.Graph, i2).length)];
            int j = 0;
            while (j < BN.getParents(this.Graph, i2).length) {
                int Threshold = (int)Math.pow(2.0, BN.getParents(this.Graph, i2).length - (j + 1));
                int count = 1;
                boolean flip = false;
                k = 0;
                while (k < q[i2]) {
                    if (!flip) {
                        w_inter[j][k] = 0;
                    } else if (flip) {
                        w_inter[j][k] = 1;
                    }
                    if (count % Threshold == 0) {
                        flip = !flip;
                    }
                    ++count;
                    ++k;
                }
                ++j;
            }
            w.add(w_inter);
            ++i2;
        }
        ArrayList<int[][]> N = new ArrayList<int[][]>();
        int i3 = 0;
        while (i3 < n) {
            int[][] N_inter = new int[q[i3]][r];
            int j = 0;
            while (j < q[i3]) {
                int k2 = 0;
                while (k2 < r) {
                    int[] Parents = BN.getParents(this.Graph, i3);
                    int count1 = 0;
                    int id = 0;
                    while (id < this.Data.length) {
                        boolean countvar = true;
                        int ip1 = 0;
                        int[] nArray = Parents;
                        int n2 = Parents.length;
                        int n3 = 0;
                        while (n3 < n2) {
                            int ip = nArray[n3];
                            countvar = ((int[][])w.get(i3))[ip1][j] == this.Data[id][ip] ? (countvar &= true) : (countvar &= false);
                            ++ip1;
                            ++n3;
                        }
                        if (countvar & this.Data[id][i3] == k2) {
                            ++count1;
                        }
                        ++id;
                    }
                    N_inter[j][k2] = count1;
                    ++k2;
                }
                ++j;
            }
            N.add(N_inter);
            ++i3;
        }
        ArrayList<int[]> Nij = new ArrayList<int[]>();
        int i4 = 0;
        while (i4 < n) {
            int[] Nij_inter = new int[q[i4]];
            int j = 0;
            while (j < q[i4]) {
                int count = 0;
                k = 0;
                while (k < r) {
                    count += ((int[][])N.get(i4))[j][k];
                    ++k;
                }
                Nij_inter[j] = count;
                ++j;
            }
            Nij.add(Nij_inter);
            ++i4;
        }
        double score = 0.0;
        int i5 = 0;
        while (i5 < n) {
            int j = 0;
            while (j < q[i5]) {
                k = 0;
                while (k < r) {
                    if (((int[][])N.get(i5))[j][k] != 0) {
                        score += (double)((int[][])N.get(i5))[j][k] * Math.log((double)((int[][])N.get(i5))[j][k] / (double)((int[])Nij.get(i5))[j]);
                    }
                    ++k;
                }
                ++j;
            }
            ++i5;
        }
        return score;
    }

    public double BIC() {
        int n = this.Data[1].length;
        int r = 2;
        BayesNetwork BN = new BayesNetwork(n);
        int[] q = new int[n];
        int i = 0;
        while (i < n) {
            q[i] = (int)Math.pow(r, BN.getParents(this.Graph, i).length);
            ++i;
        }
        double B = 0.0;
        int i2 = 0;
        while (i2 < n) {
            B += (double)((r - 1) * q[i2]);
            ++i2;
        }
        double score = this.LogLik() - 0.5 * Math.log(this.Data.length) * B;
        return score;
    }

    public double AIC() {
        int n = this.Data[1].length;
        int r = 2;
        BayesNetwork BN = new BayesNetwork(n);
        int[] q = new int[n];
        int i = 0;
        while (i < n) {
            q[i] = (int)Math.pow(r, BN.getParents(this.Graph, i).length);
            ++i;
        }
        double B = 0.0;
        int i2 = 0;
        while (i2 < n) {
            B += (double)((r - 1) * q[i2]);
            ++i2;
        }
        double score = this.LogLik() - B;
        return score;
    }

    private double getFactorial(int Number) {
        if (Number == 1) {
            return 1.0;
        }
        if (Number == 0) {
            return 1.0;
        }
        double Result = Math.sqrt(Math.PI * 2 * (double)Number) * Math.pow((double)Number / Math.E, Number);
        return Result;
    }

    private double gamma(double x) {
        double[] P = new double[]{1.6011952247675185E-4, 0.0011913514700658638, 0.010421379756176158, 0.04763678004571372, 0.20744822764843598, 0.4942148268014971, 1.0};
        double[] Q = new double[]{-2.3158187332412014E-5, 5.396055804933034E-4, -0.004456419138517973, 0.011813978522206043, 0.035823639860549865, -0.23459179571824335, 0.0714304917030273, 1.0};
        double q = Math.abs(x);
        if (q > 33.0) {
            if (x < 0.0) {
                double p = Math.floor(q);
                if (p == q) {
                    throw new ArithmeticException("gamma: overflow");
                }
                double z = q - p;
                if (z > 0.5) {
                    z = q - (p += 1.0);
                }
                if ((z = q * Math.sin(Math.PI * z)) == 0.0) {
                    throw new ArithmeticException("gamma: overflow");
                }
                z = Math.abs(z);
                z = Math.PI / (z * this.stirlingFormula(q));
                return -z;
            }
            return this.stirlingFormula(x);
        }
        double z = 1.0;
        while (x >= 3.0) {
            z *= (x -= 1.0);
        }
        while (x < 0.0) {
            if (x == 0.0) {
                throw new ArithmeticException("gamma: singular");
            }
            if (x > -1.0E-9) {
                return z / ((1.0 + 0.5772156649015329 * x) * x);
            }
            z /= x;
            x += 1.0;
        }
        while (x < 2.0) {
            if (x == 0.0) {
                throw new ArithmeticException("gamma: singular");
            }
            if (x < 1.0E-9) {
                return z / ((1.0 + 0.5772156649015329 * x) * x);
            }
            z /= x;
            x += 1.0;
        }
        if (x == 2.0 || x == 3.0) {
            return z;
        }
        double p = this.polevl(x -= 2.0, P, 6);
        q = this.polevl(x, Q, 7);
        return z * p / q;
    }

    private double stirlingFormula(double x) {
        double[] STIR = new double[]{7.873113957930937E-4, -2.2954996161337813E-4, -0.0026813261780578124, 0.0034722222160545866, 0.08333333333334822};
        double MAXSTIR = 143.01608;
        double w = 1.0 / x;
        double y = Math.exp(x);
        w = 1.0 + w * this.polevl(w, STIR, 4);
        if (x > MAXSTIR) {
            double v = Math.pow(x, 0.5 * x - 0.25);
            y = v * (v / y);
        } else {
            y = Math.pow(x, x - 0.5) / y;
        }
        y = 2.5066282746310007 * y * w;
        return y;
    }

    private double polevl(double x, double[] coef, int N) {
        double ans = coef[0];
        int i = 1;
        while (i <= N) {
            ans = ans * x + coef[i];
            ++i;
        }
        return ans;
    }
}

