/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.dsexplore.bayesnets.utility;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Ellipse2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Random;
import javax.imageio.ImageIO;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class DrawGraph
extends JPanel {
    int[][] Graph;

    public DrawGraph(int[][] Graph) {
        this.Graph = Graph;
    }

    public static void main(String[] args) {
        int[][] gr = new int[4][4];
        Random r = new Random();
        int i = 0;
        while (i < 4) {
            int j = 0;
            while (j < 4) {
                gr[i][j] = r.nextInt(2);
                ++j;
            }
            ++i;
        }
        System.out.println(Math.sin(1.5707963267948966));
        JFrame frame = new JFrame("Mini Tennis");
        frame.add(new DrawGraph(gr));
        frame.setSize(300, 300);
        frame.setVisible(true);
        frame.setDefaultCloseOperation(3);
        DrawGraph dg = new DrawGraph(gr);
        dg.saveImage();
    }

    public void saveImage() {
        BufferedImage img = new BufferedImage(800, 500, 2);
        Graphics2D ig2 = img.createGraphics();
        this.paint(ig2);
        ig2.drawImage(img, null, 0, 0);
        try {
            ImageIO.write((RenderedImage)img, "JPEG", new File("foo.jpg"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        g2d.setColor(Color.WHITE);
        int num = this.Graph.length;
        double radius = 100.0;
        double[][] coor = new double[num][2];
        int i = 0;
        while (i < num) {
            String str = Integer.toString(i);
            coor[i][0] = radius * Math.sin((double)(i * 2) * Math.PI / (double)num) + 500.0;
            coor[i][1] = radius * Math.cos((double)(i * 2) * Math.PI / (double)num) + 110.0;
            this.drawCenteredCircle(g2d, (int)coor[i][0], (int)coor[i][1], 15);
            g.drawString(str, (int)coor[i][0] - 14, (int)coor[i][1] - 14);
            ++i;
        }
        i = 0;
        while (i < num) {
            ArrayList<Integer> targets = this.getTargetNodes(i);
            int j = 0;
            while (j < targets.size()) {
                this.drawArrowLine(g, (int)coor[i][0], (int)coor[i][1], (int)coor[targets.get(j)][0], (int)coor[targets.get(j)][1], 7, 7);
                ++j;
            }
            ++i;
        }
        g2d.draw(new Ellipse2D.Double(0.0, 100.0, 30.0, 30.0));
    }

    public ArrayList<Integer> getTargetNodes(int Node) {
        ArrayList<Integer> TargetNodes = new ArrayList<Integer>();
        int i = 0;
        while (i < this.Graph.length) {
            if (this.Graph[Node][i] == 1) {
                TargetNodes.add(i);
            }
            ++i;
        }
        return TargetNodes;
    }

    public void drawCenteredCircle(Graphics2D g, int x, int y, int r) {
        g.fillOval(x -= r / 2, y -= r / 2, r, r);
    }

    private void drawArrowLine(Graphics g, int x1, int y1, int x2, int y2, int d, int h) {
        double xm;
        int dx = x2 - x1;
        int dy = y2 - y1;
        double D = Math.sqrt(dx * dx + dy * dy);
        double xn = xm = D - (double)d;
        double ym = h;
        double yn = -h;
        double sin = (double)dy / D;
        double cos = (double)dx / D;
        double x = xm * cos - ym * sin + (double)x1;
        ym = xm * sin + ym * cos + (double)y1;
        xm = x;
        x = xn * cos - yn * sin + (double)x1;
        yn = xn * sin + yn * cos + (double)y1;
        xn = x;
        int[] xpoints = new int[]{x2, (int)xm, (int)xn};
        int[] ypoints = new int[]{y2, (int)ym, (int)yn};
        g.drawLine(x1, y1, x2, y2);
        g.fillPolygon(xpoints, ypoints, 3);
    }
}

