/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.dsexplore.qml.reader;

import de.uka.ipd.sdq.dsexplore.qml.contract.QMLContract.RefinedQMLContract;
import de.uka.ipd.sdq.dsexplore.qml.contract.QMLContract.SimpleQMLContract;
import de.uka.ipd.sdq.dsexplore.qml.contracttype.QMLContractType.QMLContractType;
import de.uka.ipd.sdq.dsexplore.qml.declarations.QMLDeclarations.QMLDeclaration;
import de.uka.ipd.sdq.dsexplore.qml.declarations.QMLDeclarations.QMLDeclarations;
import de.uka.ipd.sdq.dsexplore.qml.declarations.QMLDeclarations.QMLDeclarationsPackage;
import de.uka.ipd.sdq.dsexplore.qml.profile.QMLProfile.RefinedQMLProfile;
import de.uka.ipd.sdq.dsexplore.qml.profile.QMLProfile.SimpleQMLProfile;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;

public class QMLDeclarationsReader {
    public QMLDeclarations getQMLDeclarations(String QMLDeclarationsPath) {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", new XMIResourceFactoryImpl());
        resourceSet.getPackageRegistry().put((Object)"http:///QMLDeclarations.ecore", (Object)QMLDeclarationsPackage.eINSTANCE);
        File file = new File(QMLDeclarationsPath);
        URI uri = file.isFile() ? URI.createFileURI((String)file.getAbsolutePath()) : URI.createURI((String)QMLDeclarationsPath);
        Resource resource = resourceSet.getResource(uri, true);
        QMLDeclarations returnDeclaration = null;
        Iterator iterator = resource.getContents().iterator();
        if (iterator.hasNext()) {
            EObject eObject = (EObject)iterator.next();
            Diagnostic diagnostic = Diagnostician.INSTANCE.validate(eObject);
            if (diagnostic.getSeverity() != 0) {
                this.printDiagnostic(diagnostic, "");
                throw new RuntimeException("QML validation failed: " + diagnostic.getMessage() + ". See console output for details.");
            }
            if (!(eObject instanceof QMLDeclarations)) {
                throw new RuntimeException("Check QML definition: The root element of the file must be a QMLDeclarations element.");
            }
            returnDeclaration = (QMLDeclarations)eObject;
        }
        return returnDeclaration;
    }

    protected void printDiagnostic(Diagnostic diagnostic, String indent) {
        System.out.print(indent);
        System.out.println(diagnostic.getMessage());
        for (Diagnostic child : diagnostic.getChildren()) {
            this.printDiagnostic(child, String.valueOf(indent) + "  ");
        }
    }

    public List<QMLContractType> getQMLContractTypes(QMLDeclarations declarations) {
        if (declarations == null) {
            return null;
        }
        ArrayList<QMLContractType> contractTypes = new ArrayList<QMLContractType>();
        for (QMLDeclaration declaration : declarations.getQmlDeclarations()) {
            if (!(declaration instanceof QMLContractType)) continue;
            contractTypes.add((QMLContractType)declaration);
        }
        return contractTypes;
    }

    public List<SimpleQMLContract> getSimpleQMLContracts(QMLDeclarations declarations) {
        if (declarations == null) {
            return null;
        }
        ArrayList<SimpleQMLContract> simpleContracts = new ArrayList<SimpleQMLContract>();
        for (QMLDeclaration declaration : declarations.getQmlDeclarations()) {
            if (!(declaration instanceof SimpleQMLContract)) continue;
            simpleContracts.add((SimpleQMLContract)declaration);
        }
        return simpleContracts;
    }

    public List<SimpleQMLProfile> getSimpleQMLProfiles(QMLDeclarations declarations) {
        if (declarations == null) {
            return null;
        }
        ArrayList<SimpleQMLProfile> simpleProfiles = new ArrayList<SimpleQMLProfile>();
        for (QMLDeclaration declaration : declarations.getQmlDeclarations()) {
            if (!(declaration instanceof SimpleQMLProfile)) continue;
            simpleProfiles.add((SimpleQMLProfile)declaration);
        }
        return simpleProfiles;
    }

    public List<RefinedQMLContract> getRefinedQMLContracts(QMLDeclarations declarations) {
        if (declarations == null) {
            return null;
        }
        ArrayList<RefinedQMLContract> refinedContracts = new ArrayList<RefinedQMLContract>();
        for (QMLDeclaration declaration : declarations.getQmlDeclarations()) {
            if (!(declaration instanceof RefinedQMLContract)) continue;
            refinedContracts.add((RefinedQMLContract)declaration);
        }
        return refinedContracts;
    }

    public List<RefinedQMLProfile> getRefinedQMLProfiles(QMLDeclarations declarations) {
        if (declarations == null) {
            return null;
        }
        ArrayList<RefinedQMLProfile> simpleProfiles = new ArrayList<RefinedQMLProfile>();
        for (QMLDeclaration declaration : declarations.getQmlDeclarations()) {
            if (!(declaration instanceof RefinedQMLProfile)) continue;
            simpleProfiles.add((RefinedQMLProfile)declaration);
        }
        return simpleProfiles;
    }
}

