package de.uka.ipd.sdq.dsexplore.opt4j.optimizer.heuristic.operators;

import java.util.ArrayList;
import java.util.List;

import org.opt4j.core.Genotype;
import org.opt4j.operator.copy.Copy;

import de.uka.ipd.sdq.dsexplore.launch.DSEWorkflowConfiguration;
import de.uka.ipd.sdq.dsexplore.opt4j.representation.DSEIndividualFactory;
import de.uka.ipd.sdq.dsexplore.qml.contract.QMLContract.EvaluationAspect;
import de.uka.ipd.sdq.dsexplore.qml.contracttype.QMLContractType.Dimension;
import de.uka.ipd.sdq.dsexplore.qml.reader.QMLDimensionReader;

public abstract class AbstractTactic implements ITactic {
	/**
	 * Weight of this heuristics. Used for randomly select a candidate
	 * out of a set of candidates
	 */
	private double heuristicWeight;
	private int numberOfGeneratedCandidates = 0;
	/**
	 * Creates copy of genotypes
	 */
	protected final Copy<Genotype> copy;
	
	/**
	 * Builds individual
	 */
	protected final DSEIndividualFactory individualFactory;
	
	/**
	 * The paths of the QML dimension definition. These dimension are improved by applying this tactic
	 * May be empty.
	 */
	private String[] improvesDimensionPath;

	/**
	 * cache id
	 */
	private List<String> dimensionIdList = null;
	
	/**
	 * @param copy Creates copy of genotypes
	 * @param individualFactory Builds individual
	 */
	public AbstractTactic(Copy<Genotype> copy,
			DSEIndividualFactory individualFactory, DSEWorkflowConfiguration configuration,
			String[] strings) {
		this.copy = copy;
		this.individualFactory = individualFactory;
		this.improvesDimensionPath = strings;
	}

	final protected void increaseCounterOfGeneratedCandidates() {
		numberOfGeneratedCandidates++;
	}
	
	/**
	 * @return Weight used for selecting candidate out of a set of candidates
	 */
	final public double getHeuristicWeight() {
		return heuristicWeight;
	}
	
	final protected void setHeuristicWeight(double weight) {
		heuristicWeight = weight;
	}
	
	/**
	 * @return Number of candidates generated by this heuristic
	 */
	final public int getNumberOfGeneratedCandidates() {
		return numberOfGeneratedCandidates;
	}
	
	@Override
	public final boolean improves(Dimension dimension, EvaluationAspect aspect) {
		
		// initialise dimension id list if necessary
		if(dimensionIdList == null) {
			dimensionIdList = new ArrayList<String>(this.improvesDimensionPath.length);
			for (String dimensionPath : this.improvesDimensionPath) {
				String dimensionId = new QMLDimensionReader().getDimension(dimensionPath).getId();
				dimensionIdList.add(dimensionId);
			}
			 
		}
		
		for (String dimensionId : this.dimensionIdList) {
			// return true if any of this tactics improved dimensions matches 
			if (dimension.getId().equals(dimensionId))
				return true;
		}
		
		//if no dimension matches, return false
		return false;
	}
	
	@Override
	public boolean doesNotImprove(Dimension dimension, EvaluationAspect aspect) {
		return !improves(dimension, aspect);
	}

}
