/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.dsexplore.opt4j.optimizer;

import com.google.inject.Inject;
import de.uka.ipd.sdq.dsexplore.opt4j.operator.BayesianCrossover;
import de.uka.ipd.sdq.dsexplore.opt4j.optimizer.heuristic.operators.QMLBoundDependentTacticOperatorsManager;
import de.uka.ipd.sdq.dsexplore.opt4j.optimizer.heuristic.operators.TacticOperatorsManager;
import de.uka.ipd.sdq.dsexplore.opt4j.representation.DSEIndividual;
import de.uka.ipd.sdq.dsexplore.opt4j.representation.DSEIndividualFactory;
import de.uka.ipd.sdq.dsexplore.opt4j.start.Opt4JStarter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.log4j.Logger;
import org.opt4j.common.random.Rand;
import org.opt4j.core.Genotype;
import org.opt4j.core.Individual;
import org.opt4j.core.IndividualFactory;
import org.opt4j.operator.copy.Copy;
import org.opt4j.operator.crossover.Crossover;
import org.opt4j.operator.mutate.Mutate;
import org.opt4j.operator.mutate.MutationRate;
import org.opt4j.optimizer.ea.Coupler;
import org.opt4j.optimizer.ea.CrossoverRate;
import org.opt4j.optimizer.ea.MatingCrossoverMutate;
import org.opt4j.optimizer.ea.Pair;

public class MatingBayes
extends MatingCrossoverMutate {
    private static Logger logger = Logger.getLogger((String)"de.uka.ipd.sdq.dsexplore.opt4j.opimizer.MatingBayes");
    private TacticOperatorsManager heuristicManager;

    public TacticOperatorsManager getHeuristicManager() {
        return this.heuristicManager;
    }

    @Inject
    public MatingBayes(Crossover<Genotype> crossover, Mutate<Genotype> mutate, Copy<Genotype> copy, Coupler coupler, CrossoverRate crossoverRate, MutationRate mutationRate, Rand random, IndividualFactory individualFactory, QMLBoundDependentTacticOperatorsManager qmlTacticManager) {
        super(crossover, mutate, copy, coupler, crossoverRate, mutationRate, random, individualFactory);
        if (Opt4JStarter.getDSEWorkflowConfig().isConsiderQMLBoundsWhenApplyingHeuristics()) {
            this.heuristicManager = qmlTacticManager;
        } else if (Opt4JStarter.getDSEWorkflowConfig().isUseHeuristics()) {
            this.heuristicManager = new TacticOperatorsManager(copy, (DSEIndividualFactory)individualFactory);
        }
        logger.info((Object)"Ended MatingBayes Constructor");
    }

    public Collection<Individual> getOffspring(int size, Collection<Individual> parents) {
        Collection<Object> offspring = new ArrayList();
        Collection couples = this.coupler.getCouples((int)Math.ceil((double)size / 2.0), new ArrayList<Individual>(parents));
        ArrayList<Individual> parentslist = new ArrayList<Individual>();
        for (Pair couple : couples) {
            Individual parent1 = (Individual)couple.getFirst();
            Individual parent2 = (Individual)couple.getSecond();
            parentslist.add(parent1);
            parentslist.add(parent2);
        }
        logger.info((Object)"Line 131: MatingBayes");
        offspring = this.mate(parentslist);
        logger.info((Object)"Line 133: MatingBayes");
        while (offspring.size() > size) {
            offspring.remove(((List)offspring).get(0));
        }
        logger.info((Object)"Line 137: MatingBayes");
        return offspring;
    }

    private Collection<Individual> mate(List<Individual> parentslist) {
        ArrayList<Genotype> parentgenotypelist = new ArrayList<Genotype>();
        int i = 0;
        while (i < parentslist.size()) {
            parentgenotypelist.add(parentslist.get(i).getGenotype());
            ++i;
        }
        boolean useHeuristics = Opt4JStarter.getDSEWorkflowConfig().isUseHeuristics();
        double tacticsProbability = Opt4JStarter.getDSEWorkflowConfig().getTacticsProbability();
        ArrayList<DSEIndividual> tacticsindividuals = new ArrayList<DSEIndividual>();
        int i2 = 0;
        while (i2 < parentslist.size()) {
            if (useHeuristics && Math.random() < tacticsProbability) {
                tacticsindividuals.add(this.heuristicManager.getCandidate((DSEIndividual)parentslist.get(i2)));
            }
            ++i2;
        }
        logger.info((Object)"Line 160: MatingBayes");
        List offspring = ((BayesianCrossover)this.crossover).crossover(parentgenotypelist);
        logger.info((Object)"Line 163: MatingBayes");
        ArrayList<Individual> crossoverindividuals = new ArrayList<Individual>();
        int j = 0;
        while (j < offspring.size()) {
            crossoverindividuals.add(this.individualFactory.create((Genotype)offspring.get(j)));
            ++j;
        }
        ArrayList<Individual> individuals = new ArrayList<Individual>();
        individuals.addAll(tacticsindividuals);
        individuals.addAll(crossoverindividuals);
        return individuals;
    }
}

