/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.dsexplore.opt4j.optimizer.heuristic.operators.impl;

import de.uka.ipd.sdq.dsexplore.helper.EMFHelper;
import de.uka.ipd.sdq.dsexplore.launch.DSEWorkflowConfiguration;
import de.uka.ipd.sdq.dsexplore.opt4j.optimizer.heuristic.operators.AbstractTactic;
import de.uka.ipd.sdq.dsexplore.opt4j.optimizer.heuristic.operators.TacticsResultCandidate;
import de.uka.ipd.sdq.dsexplore.opt4j.optimizer.heuristic.operators.UtilisationResultCacheAndHelper;
import de.uka.ipd.sdq.dsexplore.opt4j.representation.DSEIndividual;
import de.uka.ipd.sdq.dsexplore.opt4j.representation.DSEIndividualFactory;
import de.uka.ipd.sdq.pcm.designdecision.Choice;
import de.uka.ipd.sdq.pcm.designdecision.ClassChoice;
import de.uka.ipd.sdq.pcm.designdecision.specific.AllocationDegree;
import de.uka.ipd.sdq.pcm.designdecision.specific.ClassDegree;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.opt4j.core.Genotype;
import org.opt4j.operator.copy.Copy;
import org.palladiosimulator.analyzer.resultdecorator.resourceenvironmentdecorator.ProcessingResourceSpecificationResult;
import org.palladiosimulator.analyzer.resultdecorator.resourceenvironmentdecorator.UtilisationResult;
import org.palladiosimulator.analyzer.resultdecorator.resourceenvironmentdecorator.impl.ProcessingResourceSpecificationResultImpl;
import org.palladiosimulator.pcm.resourceenvironment.ProcessingResourceSpecification;
import org.palladiosimulator.pcm.resourceenvironment.ResourceContainer;
import org.palladiosimulator.pcm.resourcetype.ResourceType;

public class ReallocationImpl
extends AbstractTactic {
    private double thresholdUtilisationDifference;
    private Random generator = new Random();
    private UtilisationResultCacheAndHelper resultsCache = new UtilisationResultCacheAndHelper();

    public ReallocationImpl(Copy<Genotype> copy, DSEIndividualFactory individualFactory, DSEWorkflowConfiguration configuration) {
        super(copy, individualFactory, configuration, new String[]{"pathmap://PCM_MODELS/Dimension_responsetime.qmlcontracttype", "pathmap://PCM_MODELS/Dimension_throughput.qmlcontracttype"});
        this.setHeuristicWeight(configuration.getReallocationWeight());
        this.thresholdUtilisationDifference = configuration.getReallocationThresholdUtilisationDifference();
    }

    public boolean doesMatchPrecondition(DSEIndividual individual, ResourceType resourceType) {
        ProcessingResourceSpecificationResult minUtilisationResult = this.resultsCache.getMinProcUtilisationResult(individual, resourceType);
        ProcessingResourceSpecificationResult maxUtilisationResult = this.resultsCache.getMaxProcUtilisationResult(individual, resourceType);
        return minUtilisationResult != null && maxUtilisationResult != null && maxUtilisationResult.getResourceUtilisation() - minUtilisationResult.getResourceUtilisation() >= this.thresholdUtilisationDifference;
    }

    @Override
    public List<TacticsResultCandidate> getHeuristicCandidates(DSEIndividual individual, UtilisationResultCacheAndHelper resultCache) {
        this.resultsCache = resultCache;
        ArrayList<TacticsResultCandidate> candidates = new ArrayList<TacticsResultCandidate>();
        Set<ResourceType> resourceTypes = this.resultsCache.getResourceTypes(individual);
        for (ResourceType resourceType : resourceTypes) {
            ResourceContainer sourceResourceContainer;
            if (!this.doesMatchPrecondition(individual, resourceType)) continue;
            ProcessingResourceSpecificationResult minUtilisationResult = this.resultsCache.getMinProcUtilisationResult(individual, resourceType);
            ProcessingResourceSpecificationResult maxUtilisationResult = resultCache.getMaxProcUtilisationResult(individual, resourceType);
            TacticsResultCandidate candidate = this.individualFactory.buildCandidate(this.copy.copy((Genotype)individual.getGenotype()), individual);
            ProcessingResourceSpecification minProcessingResourceSpec = ((ProcessingResourceSpecificationResultImpl)minUtilisationResult).getProcessingResourceSpecification_ProcessingResourceSpecificationResult();
            ProcessingResourceSpecification maxProcessingResourceSpec = ((ProcessingResourceSpecificationResultImpl)maxUtilisationResult).getProcessingResourceSpecification_ProcessingResourceSpecificationResult();
            ResourceContainer targetResourceContainer = (ResourceContainer)minProcessingResourceSpec.eContainer();
            if (EMFHelper.checkIdentity((EObject)targetResourceContainer, (EObject)(sourceResourceContainer = (ResourceContainer)maxProcessingResourceSpec.eContainer()))) {
                return candidates;
            }
            LinkedList<ClassChoice> potentiallyReallocatedComponents = new LinkedList<ClassChoice>();
            Iterator<Choice> iterator = candidate.getGenotype().iterator();
            block1: while (iterator.hasNext()) {
                ClassChoice classChoice;
                Choice choice = iterator.next();
                if (!(choice instanceof ClassChoice) || !((classChoice = (ClassChoice)choice).getDegreeOfFreedomInstance() instanceof AllocationDegree)) continue;
                AllocationDegree allocationDegree = (AllocationDegree)classChoice.getDegreeOfFreedomInstance();
                if (!EMFHelper.checkIdentity(classChoice.getChosenValue(), (EObject)sourceResourceContainer)) continue;
                for (EObject designOption : allocationDegree.getClassDesignOptions()) {
                    if (!EMFHelper.checkIdentity((EObject)targetResourceContainer, designOption)) continue;
                    potentiallyReallocatedComponents.add(classChoice);
                    continue block1;
                }
            }
            if (potentiallyReallocatedComponents.size() <= 1) continue;
            int chosenComponentIndex = this.generator.nextInt(potentiallyReallocatedComponents.size());
            ClassChoice componentToReallocate = (ClassChoice)potentiallyReallocatedComponents.get(chosenComponentIndex);
            componentToReallocate.setChosenValue((EObject)EMFHelper.retrieveEntityByID((List<? extends EObject>)((ClassDegree)componentToReallocate.getDegreeOfFreedomInstance()).getClassDesignOptions(), (EObject)targetResourceContainer));
            candidate.setCandidateWeight(this.getCandidateWeight((UtilisationResult)minUtilisationResult, (UtilisationResult)maxUtilisationResult));
            candidate.setHeuristic(this);
            candidates.add(candidate);
            this.increaseCounterOfGeneratedCandidates();
        }
        return candidates;
    }

    private double getCandidateWeight(UtilisationResult minUtilisationResult, UtilisationResult maxUtilisationResult) {
        return Math.min(1.0, maxUtilisationResult.getResourceUtilisation() - minUtilisationResult.getResourceUtilisation());
    }
}

