/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.dsexplore.analysis.qes;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;

public final class DirectedGraph<T>
implements Iterable<T> {
    private final Map<T, Set<T>> graph = new HashMap<T, Set<T>>();

    public boolean addEdge(T start, T end) {
        if (start == null || end == null) {
            return false;
        }
        this.addNode(start);
        this.addNode(end);
        this.graph.get(start).add(end);
        assert (this.edgeExists(start, end));
        return true;
    }

    public boolean addNode(T node) {
        if (node == null) {
            return false;
        }
        if (this.graph.containsKey(node)) {
            return false;
        }
        this.graph.put(node, new HashSet());
        assert (this.nodeExists(node));
        return true;
    }

    public void clear() {
        this.graph.clear();
        assert (this.isEmpty());
    }

    public boolean edgeExists(T start, T end) {
        return this.nodeExists(start) && this.nodeExists(end) && this.graph.get(start).contains(end);
    }

    public Set<T> edgesFrom(T node) {
        Set<T> edges = this.graph.get(node);
        if (edges != null) {
            return Collections.unmodifiableSet(edges);
        }
        return Collections.unmodifiableSet(new HashSet());
    }

    public boolean equals(Object obj) {
        return obj != null && this.getClass() == obj.getClass() && this.graph.equals(((DirectedGraph)obj).graph);
    }

    public int hashCode() {
        return this.graph.hashCode();
    }

    public boolean isEmpty() {
        return this.graph.isEmpty();
    }

    @Override
    public Iterator<T> iterator() {
        return this.graph.keySet().iterator();
    }

    public boolean nodeExists(T node) {
        return this.graph.containsKey(node);
    }

    public int size() {
        return this.graph.size();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (T key : this.graph.keySet()) {
            builder.append(key.toString()).append("->");
            StringJoiner joiner = new StringJoiner(",", "(", ")");
            for (T node : this.graph.get(key)) {
                joiner.add(node.toString());
            }
            builder.append(joiner.toString()).append(System.lineSeparator());
        }
        return builder.toString();
    }
}

