/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.dsexplore.helper;

import de.uka.ipd.sdq.dsexplore.helper.EMFHelper;
import de.uka.ipd.sdq.dsexplore.helper.FixGDOFReferenceSwitch;
import de.uka.ipd.sdq.dsexplore.helper.FixSpecificDesignDecisionReferenceSwitch;
import de.uka.ipd.sdq.dsexplore.opt4j.start.Opt4JStarter;
import de.uka.ipd.sdq.pcm.designdecision.Candidate;
import de.uka.ipd.sdq.pcm.designdecision.Candidates;
import de.uka.ipd.sdq.pcm.designdecision.Choice;
import de.uka.ipd.sdq.pcm.designdecision.ClassChoice;
import de.uka.ipd.sdq.pcm.designdecision.DecisionSpace;
import de.uka.ipd.sdq.pcm.designdecision.DegreeOfFreedomInstance;
import de.uka.ipd.sdq.pcm.designdecision.specific.ClassDegree;
import de.uka.ipd.sdq.pcm.designdecision.util.designdecisionSwitch;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.Switch;
import org.palladiosimulator.pcm.core.entity.Entity;
import org.palladiosimulator.solver.core.models.PCMInstance;

public class FixDesignDecisionReferenceSwitch
extends designdecisionSwitch<EObject> {
    protected static Logger logger = Logger.getLogger((String)FixDesignDecisionReferenceSwitch.class.getName());
    private final Switch<EObject> specificSwitch;
    private final FixSpecificDesignDecisionReferenceSwitch fixSpecificDesignDecisionSwitch;
    private final FixGDOFReferenceSwitch genericSwitch;
    private final Switch<EObject> fixGenericSwitch;

    public void fixEntitiesForDomain(List<EObject> eListToUpdate, List<Entity> memoryEntityList) {
        ArrayList<Entity> newList = new ArrayList<Entity>();
        for (EObject entity : eListToUpdate) {
            Entity rightOne = EMFHelper.retrieveEntityByID(memoryEntityList, entity);
            newList.add(rightOne);
        }
        eListToUpdate.clear();
        eListToUpdate.addAll(newList);
    }

    public FixDesignDecisionReferenceSwitch(PCMInstance initialInstance2) {
        this.specificSwitch = new FixSpecificDesignDecisionReferenceSwitch(initialInstance2);
        this.fixSpecificDesignDecisionSwitch = new FixSpecificDesignDecisionReferenceSwitch(initialInstance2);
        this.genericSwitch = new FixGDOFReferenceSwitch(initialInstance2);
        this.fixGenericSwitch = new FixGDOFReferenceSwitch(initialInstance2);
    }

    public EObject caseCandidate(Candidate object) {
        EList choices = object.getChoices();
        for (Choice choice : choices) {
            this.doSwitch((EObject)choice);
        }
        return object;
    }

    public EObject caseCandidates(Candidates object) {
        object.setProblem(Opt4JStarter.getProblem().getEMFProblem());
        for (Candidate candidate : object.getCandidate()) {
            this.doSwitch((EObject)candidate);
        }
        return object;
    }

    public EObject caseChoice(Choice object) {
        DecisionSpace inMemoryProblem = Opt4JStarter.getProblem().getEMFProblem();
        DegreeOfFreedomInstance originalDegree = object.getDegreeOfFreedomInstance();
        this.fixSpecificDesignDecisionSwitch.doSwitch((EObject)originalDegree);
        boolean foundDegree = false;
        Iterator iterator = inMemoryProblem.getDegreesOfFreedom().iterator();
        while (iterator.hasNext()) {
            EcoreUtil.EqualityHelper equalityHelper = new EcoreUtil.EqualityHelper();
            DegreeOfFreedomInstance inMemoryDegree = (DegreeOfFreedomInstance)iterator.next();
            if (!equalityHelper.equals((EObject)inMemoryDegree, (EObject)originalDegree)) continue;
            object.setDegreeOfFreedomInstance(inMemoryDegree);
            foundDegree = true;
            break;
        }
        if (!foundDegree) {
            throw new RuntimeException("Fixing design decision references failed, could not find in memory degree for " + object.getDegreeOfFreedomInstance());
        }
        return object;
    }

    public EObject caseClassChoice(ClassChoice object) {
        Entity inMemoryEntity;
        this.caseChoice((Choice)object);
        DegreeOfFreedomInstance degree = object.getDegreeOfFreedomInstance();
        if (degree instanceof ClassDegree) {
            ClassDegree enumDegree = (ClassDegree)degree;
            inMemoryEntity = EMFHelper.retrieveEntityByID((List<? extends EObject>)enumDegree.getClassDesignOptions(), object.getChosenValue());
            if (inMemoryEntity == null) {
                throw new RuntimeException("Cannot find Entity " + ((Entity)object.getChosenValue()).getId() + " in the specified PCM ALlocation Model. Maybe the design decision file does not match the analysed PCM instance?");
            }
        } else {
            throw new RuntimeException("Invalid enumeration choice encountered: Referenced degree of freedom must be of type ClassDegree.");
        }
        object.setChosenValue((EObject)inMemoryEntity);
        return object;
    }

    public EObject caseDecisionSpace(DecisionSpace object) {
        try {
            for (DegreeOfFreedomInstance dd : object.getDegreesOfFreedom()) {
                this.doSwitch((EObject)dd);
            }
        }
        catch (ClassCastException e) {
            logger.error((Object)"Class cast exception when visiting .designdecision model. Please check your model for validity using the Ecore tree editor. References might be broken.");
            throw e;
        }
        return object;
    }

    public EObject defaultCase(EObject eObject) {
        return (EObject)this.specificSwitch.doSwitch(eObject);
    }
}

