/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.dsexplore.helper;

import de.uka.ipd.sdq.dsexplore.helper.IResultsHandler;
import de.uka.ipd.sdq.dsexplore.launch.IResultsHandlerLaunchConfigSettings;
import de.uka.ipd.sdq.dsexplore.opt4j.representation.DSEIndividual;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

public class ResultsHandlerController {
    private static Logger logger = Logger.getLogger(ResultsHandlerController.class);
    private static final String IRESTULSTHANDLER_ID = "de.uka.ipd.sdq.dsexplore.currentcandidates";
    private List<IResultsHandler> handlers = new ArrayList<IResultsHandler>();

    public ResultsHandlerController(IExtensionRegistry registry, ILaunchConfiguration configuration) {
        IConfigurationElement[] config = registry.getConfigurationElementsFor(IRESTULSTHANDLER_ID);
        try {
            IConfigurationElement[] iConfigurationElementArray = config;
            int n = config.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement e = iConfigurationElementArray[n2];
                Object o = e.createExecutableExtension("class");
                if (o instanceof IResultsHandler) {
                    IResultsHandler handler = (IResultsHandler)o;
                    handler.initialize(configuration);
                    this.handlers.add(handler);
                }
                ++n2;
            }
        }
        catch (CoreException ex) {
            logger.log((Priority)Level.WARN, (Object)ex.getMessage(), (Throwable)ex);
        }
    }

    public void handleResults(Collection<DSEIndividual> individuals, int iteration) {
        for (IResultsHandler handler : this.handlers) {
            ResultsHandlerController.executeExtension(handler, individuals, iteration);
        }
    }

    private static void executeExtension(final Object o, final Collection<DSEIndividual> individuals, final int iteration) {
        ISafeRunnable runnable = new ISafeRunnable(){

            public void handleException(Throwable e) {
                logger.log((Priority)Level.WARN, (Object)("Exception in client: " + e.getMessage()), e);
            }

            public void run() throws Exception {
                ((IResultsHandler)o).handleResults(individuals, iteration);
            }
        };
        SafeRunner.run((ISafeRunnable)runnable);
    }

    public static Map<String, IResultsHandlerLaunchConfigSettings> getResultHandlersLaunchConfigSettings(IExtensionRegistry registry, Composite parent, SelectionListener selectionListener, ModifyListener modifyListener, Shell shell) {
        HashMap<String, IResultsHandlerLaunchConfigSettings> launchConfigOptions = new HashMap<String, IResultsHandlerLaunchConfigSettings>();
        IConfigurationElement[] config = registry.getConfigurationElementsFor(IRESTULSTHANDLER_ID);
        try {
            IConfigurationElement[] iConfigurationElementArray = config;
            int n = config.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement e = iConfigurationElementArray[n2];
                Object o = e.createExecutableExtension("class");
                if (o instanceof IResultsHandler) {
                    IResultsHandler handler = (IResultsHandler)o;
                    IResultsHandlerLaunchConfigSettings settings = handler.getLaunchSettingsTab(parent, selectionListener, modifyListener, shell);
                    launchConfigOptions.put(settings.getLaunchConfigSettingsCaption(), settings);
                }
                ++n2;
            }
        }
        catch (CoreException ex) {
            logger.log((Priority)Level.WARN, (Object)ex.getMessage(), (Throwable)ex);
        }
        return launchConfigOptions;
    }

    public static boolean resultHandlersAvailable(IExtensionRegistry registry) {
        return registry.getConfigurationElementsFor(IRESTULSTHANDLER_ID).length > 0;
    }
}

