/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.dsexplore.launch;

import de.uka.ipd.sdq.dsexplore.DSEPluginActivator;
import de.uka.ipd.sdq.dsexplore.launch.DSEConstantsContainer;
import de.uka.ipd.sdq.workflow.launchconfig.LaunchConfigPlugin;
import de.uka.ipd.sdq.workflow.launchconfig.tabs.TabHelper;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.palladiosimulator.analyzer.workflow.runconfig.FileNamesInputTab;

public class DSEOptionsTab
extends FileNamesInputTab {
    private Text maximumIterations;
    private Text numberOfIndividualsPerGeneration;
    private Image icon;
    private Combo useHeuristics;
    private Text crossoverRate;
    private Text textGivenInstances;
    private Button designDecisionsOnly;
    private Button optimisationOnly;
    private Text textDesignDecisionFile;
    private Text textCacheInstances;
    private Text textAllInstances;
    private Text textArchiveInstances;
    private Button stopOnInitialFailure;
    private Button outputAsCSV;
    private Button outputAsEMF;
    private Text numberOfDSERuns;

    public void createControl(Composite parent) {
        ModifyListener modifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DSEOptionsTab.this.setDirty(true);
                DSEOptionsTab.this.updateLaunchConfigurationDialog();
            }
        };
        SelectionListener selectionListener = new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                DSEOptionsTab.this.setDirty(true);
                DSEOptionsTab.this.updateLaunchConfigurationDialog();
            }

            public void widgetSelected(SelectionEvent e) {
                DSEOptionsTab.this.setDirty(true);
                DSEOptionsTab.this.updateLaunchConfigurationDialog();
            }
        };
        this.container = new Composite(parent, 0);
        this.setControl((Control)this.container);
        this.container.setLayout((Layout)new GridLayout());
        Group maximumIterationsGroup = new Group(this.container, 0);
        GridLayout glmaximumIterationsGroup = new GridLayout();
        glmaximumIterationsGroup.numColumns = 2;
        maximumIterationsGroup.setLayout((Layout)glmaximumIterationsGroup);
        maximumIterationsGroup.setText("Evolutionary algorithm parameters");
        maximumIterationsGroup.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Label maxIterationLabel = new Label((Composite)maximumIterationsGroup, 0);
        maxIterationLabel.setText("Maximum number of iterations:");
        this.maximumIterations = new Text((Composite)maximumIterationsGroup, 2052);
        this.maximumIterations.setEnabled(true);
        this.maximumIterations.addModifyListener(modifyListener);
        Label numberOfIndividualsPerGenerationLabel = new Label((Composite)maximumIterationsGroup, 0);
        numberOfIndividualsPerGenerationLabel.setText("Number of individuals per generation:");
        this.numberOfIndividualsPerGeneration = new Text((Composite)maximumIterationsGroup, 2052);
        this.numberOfIndividualsPerGeneration.setEnabled(true);
        this.numberOfIndividualsPerGeneration.addModifyListener(modifyListener);
        Label crossoverRateLabel = new Label((Composite)maximumIterationsGroup, 0);
        crossoverRateLabel.setText("Crossover rate:");
        this.crossoverRate = new Text((Composite)maximumIterationsGroup, 2052);
        this.crossoverRate.setEnabled(true);
        this.crossoverRate.addModifyListener(modifyListener);
        this.useHeuristics = new Combo(this.container, 8);
        this.useHeuristics.setEnabled(true);
        this.useHeuristics.setItems(new String[]{"Evolutionary search", "Random search", "Full rule-based search", "Rule-based search optimal only", "Evolutionary search with Bayesian learning (experimental)"});
        this.useHeuristics.setSize(400, 200);
        this.useHeuristics.addModifyListener(modifyListener);
        this.useHeuristics.addSelectionListener(selectionListener);
        this.textGivenInstances = new Text(this.container, 2052);
        TabHelper.createFileInputSection((Composite)this.container, (ModifyListener)modifyListener, (String)"Start population or predefined candidates (optional), either .csv or .designdecision containing Candidates", (String[])DSEConstantsContainer.CANDIDATE_EXTENSION, (Text)this.textGivenInstances, (Shell)this.getShell(), (String)"");
        this.textCacheInstances = new Text(this.container, 2052);
        TabHelper.createFileInputSection((Composite)this.container, (ModifyListener)modifyListener, (String)"Candidates for evaluation cache (optional, .csv)", (String[])DSEConstantsContainer.CSV_EXTENSION, (Text)this.textCacheInstances, (Shell)this.getShell(), (String)"");
        this.textAllInstances = new Text(this.container, 2052);
        TabHelper.createFileInputSection((Composite)this.container, (ModifyListener)modifyListener, (String)"All previous candidates (optional, .csv), will be included in allcandidates*.csv, and cache (optional). Not considered by the evolutionary algorithm.", (String[])DSEConstantsContainer.CSV_EXTENSION, (Text)this.textAllInstances, (Shell)this.getShell(), (String)"");
        this.textArchiveInstances = new Text(this.container, 2052);
        TabHelper.createFileInputSection((Composite)this.container, (ModifyListener)modifyListener, (String)"Archive candidates (optional, .csv), will be included in the internal archive and archiveIndividuals.csv and cache (optional, .csv). Must be specified if an evolutionary search should be properly continued.", (String[])DSEConstantsContainer.CSV_EXTENSION, (Text)this.textArchiveInstances, (Shell)this.getShell(), (String)"");
        Group designDecisionOptions = new Group(this.container, 0);
        GridLayout gldesignDecisionOptions = new GridLayout();
        gldesignDecisionOptions.numColumns = 2;
        designDecisionOptions.setLayout((Layout)gldesignDecisionOptions);
        designDecisionOptions.setText("Design decision options");
        designDecisionOptions.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.designDecisionsOnly = new Button((Composite)designDecisionOptions, 32);
        this.designDecisionsOnly.setEnabled(true);
        this.designDecisionsOnly.setText("Only determine design decisions, do not optimise");
        this.designDecisionsOnly.addSelectionListener(selectionListener);
        this.optimisationOnly = new Button((Composite)designDecisionOptions, 32);
        this.optimisationOnly.setEnabled(true);
        this.optimisationOnly.setText("Only optimise, using pre-existing design decisions");
        this.optimisationOnly.addSelectionListener(selectionListener);
        this.textDesignDecisionFile = new Text(this.container, 2052);
        TabHelper.createFileInputSection((Composite)this.container, (ModifyListener)modifyListener, (String)"Design Decision File", (String[])DSEConstantsContainer.DESIGNDECISION_EXTENSION, (Text)this.textDesignDecisionFile, (Shell)this.getShell(), (String)"");
        Group failureOptions = new Group(this.container, 0);
        GridLayout glfailureOptions = new GridLayout();
        glfailureOptions.numColumns = 2;
        failureOptions.setLayout((Layout)glfailureOptions);
        failureOptions.setText("Failure handling options");
        failureOptions.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.stopOnInitialFailure = new Button((Composite)failureOptions, 32);
        this.stopOnInitialFailure.setEnabled(true);
        this.stopOnInitialFailure.setSelection(true);
        this.stopOnInitialFailure.setText("Stop on initial failure");
        this.stopOnInitialFailure.addSelectionListener(selectionListener);
        Group outputOptions = new Group(this.container, 0);
        GridLayout gloutputOptions = new GridLayout();
        gloutputOptions.numColumns = 2;
        outputOptions.setLayout((Layout)gloutputOptions);
        outputOptions.setText("Output options");
        outputOptions.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.outputAsCSV = new Button((Composite)outputOptions, 32);
        this.outputAsCSV.setEnabled(true);
        this.outputAsCSV.setSelection(false);
        this.outputAsCSV.setText("Output as CSV file");
        this.outputAsCSV.addSelectionListener(selectionListener);
        this.outputAsEMF = new Button((Composite)outputOptions, 32);
        this.outputAsEMF.setEnabled(true);
        this.outputAsEMF.setSelection(false);
        this.outputAsEMF.setText("Output as EMF models");
        this.outputAsEMF.addSelectionListener(selectionListener);
        Group dseIterationsGroups = new Group(this.container, 0);
        GridLayout dseIterationsGroup = new GridLayout();
        dseIterationsGroup.numColumns = 2;
        dseIterationsGroups.setLayout((Layout)dseIterationsGroup);
        dseIterationsGroups.setText("Evolutionary algorithm parameters");
        dseIterationsGroups.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Label dseIterationsLabel = new Label((Composite)dseIterationsGroups, 0);
        dseIterationsLabel.setText("Number of DSE runs (optional, default is 1):");
        this.numberOfDSERuns = new Text((Composite)dseIterationsGroups, 2052);
        this.numberOfDSERuns.setEnabled(true);
        this.numberOfDSERuns.addModifyListener(modifyListener);
    }

    public Image getImage() {
        if (this.icon == null) {
            this.icon = DSEPluginActivator.getImageDescriptor("icons/dse_launch.gif").createImage();
        }
        return this.icon;
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            this.maximumIterations.setText(configuration.getAttribute("maxIterations", ""));
        }
        catch (CoreException e) {
            LaunchConfigPlugin.errorLogger((String)this.getName(), (String)"maximum iterations", (String)e.getMessage());
        }
        try {
            this.numberOfIndividualsPerGeneration.setText(configuration.getAttribute("indivPerGeneration", ""));
        }
        catch (CoreException e) {
            LaunchConfigPlugin.errorLogger((String)this.getName(), (String)"numberOfIndividualsPerGeneration", (String)e.getMessage());
        }
        try {
            this.crossoverRate.setText(configuration.getAttribute("crossover rate", "0.5"));
        }
        catch (CoreException e) {
            LaunchConfigPlugin.errorLogger((String)this.getName(), (String)"numberOfIndividualsPerGeneration", (String)e.getMessage());
        }
        try {
            String solverStr = configuration.getAttribute("search method", "Evolutionary search");
            String[] items = this.useHeuristics.getItems();
            int i = 0;
            while (i < items.length) {
                String str = items[i];
                if (str.equals(solverStr)) {
                    this.useHeuristics.select(i);
                }
                ++i;
            }
        }
        catch (CoreException coreException) {
            this.useHeuristics.select(0);
        }
        try {
            this.textGivenInstances.setText(configuration.getAttribute("predefinedInstances", ""));
        }
        catch (CoreException e) {
            LaunchConfigPlugin.errorLogger((String)this.getName(), (String)"predefinedInstances", (String)e.getMessage());
        }
        try {
            this.textCacheInstances.setText(configuration.getAttribute("cacheInstances", ""));
        }
        catch (CoreException e) {
            LaunchConfigPlugin.errorLogger((String)this.getName(), (String)"cacheInstances", (String)e.getMessage());
        }
        try {
            this.textAllInstances.setText(configuration.getAttribute("allCandidates", ""));
        }
        catch (CoreException e) {
            LaunchConfigPlugin.errorLogger((String)this.getName(), (String)"allCandidates", (String)e.getMessage());
        }
        try {
            this.textArchiveInstances.setText(configuration.getAttribute("archiveCandidates", ""));
        }
        catch (CoreException e) {
            LaunchConfigPlugin.errorLogger((String)this.getName(), (String)"archiveCandidates", (String)e.getMessage());
        }
        try {
            this.designDecisionsOnly.setSelection(configuration.getAttribute("designDecisionsOnly", false));
        }
        catch (CoreException coreException) {
            this.designDecisionsOnly.setSelection(false);
        }
        try {
            this.optimisationOnly.setSelection(configuration.getAttribute("optimisationOnly", false));
        }
        catch (CoreException coreException) {
            this.optimisationOnly.setSelection(false);
        }
        try {
            this.textDesignDecisionFile.setText(configuration.getAttribute("designDecisionFile", ""));
            if ("".equals(this.textDesignDecisionFile.getText())) {
                String fullName = this.getFullDefaultDesignDecisionName(configuration);
                this.textDesignDecisionFile.setText(fullName);
            }
        }
        catch (CoreException e) {
            LaunchConfigPlugin.errorLogger((String)this.getName(), (String)"designDecisionFile", (String)e.getMessage());
        }
        try {
            this.stopOnInitialFailure.setSelection(configuration.getAttribute("Stop on initial failure", false));
        }
        catch (CoreException coreException) {
            this.stopOnInitialFailure.setSelection(true);
        }
        try {
            this.outputAsEMF.setSelection(configuration.getAttribute("store results as EMF", false));
        }
        catch (CoreException coreException) {
            this.outputAsEMF.setSelection(false);
        }
        try {
            this.outputAsCSV.setSelection(configuration.getAttribute("store results as CSV", true));
        }
        catch (CoreException coreException) {
            this.outputAsCSV.setSelection(true);
        }
        try {
            this.numberOfDSERuns.setText(configuration.getAttribute("number of DSE iterations", ""));
        }
        catch (CoreException e) {
            LaunchConfigPlugin.errorLogger((String)this.getName(), (String)"number of DSE iterations", (String)e.getMessage());
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("maxIterations", this.maximumIterations.getText());
        configuration.setAttribute("indivPerGeneration", this.numberOfIndividualsPerGeneration.getText());
        configuration.setAttribute("crossover rate", this.crossoverRate.getText());
        configuration.setAttribute("search method", this.useHeuristics.getText());
        configuration.setAttribute("predefinedInstances", this.textGivenInstances.getText());
        configuration.setAttribute("cacheInstances", this.textCacheInstances.getText());
        configuration.setAttribute("allCandidates", this.textAllInstances.getText());
        configuration.setAttribute("archiveCandidates", this.textArchiveInstances.getText());
        configuration.setAttribute("designDecisionsOnly", this.designDecisionsOnly.getSelection());
        configuration.setAttribute("optimisationOnly", this.optimisationOnly.getSelection());
        configuration.setAttribute("designDecisionFile", this.textDesignDecisionFile.getText());
        configuration.setAttribute("Stop on initial failure", this.stopOnInitialFailure.getSelection());
        configuration.setAttribute("store results as EMF", this.outputAsEMF.getSelection());
        configuration.setAttribute("store results as CSV", this.outputAsCSV.getSelection());
        configuration.setAttribute("number of DSE iterations", this.numberOfDSERuns.getText());
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("indivPerGeneration", "3");
        configuration.setAttribute("designDecisionsOnly", false);
        configuration.setAttribute("optimisationOnly", false);
        configuration.setAttribute("search method", "Evolutionary search");
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        this.setErrorMessage(null);
        if (this.maximumIterations.getText().length() != 0) {
            try {
                Integer.parseInt(this.maximumIterations.getText());
            }
            catch (NumberFormatException numberFormatException) {
                this.setErrorMessage("Maximum iterations must be an integer value or empty.");
                return false;
            }
        }
        if (this.numberOfIndividualsPerGeneration.getText().length() != 0) {
            try {
                Integer.parseInt(this.numberOfIndividualsPerGeneration.getText());
            }
            catch (NumberFormatException numberFormatException) {
                this.setErrorMessage("Number of individuals per generation must be an integer value or empty.");
                return false;
            }
        }
        try {
            Double.parseDouble(this.crossoverRate.getText());
        }
        catch (NumberFormatException numberFormatException) {
            this.setErrorMessage("Crossover rate must be a number.");
            return false;
        }
        if (this.designDecisionsOnly.getSelection() && this.optimisationOnly.getSelection()) {
            this.setErrorMessage("You cannot choose both \"design decisions only\" and \"optimisation only\", as nothing remains to be done.");
            return false;
        }
        if (this.textDesignDecisionFile.getText().length() > 0) {
            if (!TabHelper.validateFilenameExtension((String)this.textDesignDecisionFile.getText(), (String[])DSEConstantsContainer.DESIGNDECISION_EXTENSION)) {
                this.setErrorMessage("Design decision file path is invalid: The file must have the correct extension.");
                return false;
            }
            if (!this.optimisationOnly.getSelection()) {
                this.setMessage("Note that your defined design decision file will be overwritten or created if it does not exist yet.");
            }
        } else {
            if (this.optimisationOnly.getSelection()) {
                this.setErrorMessage("You need to provide a design decision file to read the problem from.");
                return false;
            }
            this.setMessage("If you do not specify a design decision file, the default name will be <name of this launch configuration>.designdecision.");
        }
        if (this.numberOfDSERuns.getText().length() != 0) {
            try {
                Integer.parseInt(this.numberOfDSERuns.getText());
            }
            catch (NumberFormatException numberFormatException) {
                this.setErrorMessage("Number of DSE iterations must be an integer value or empty.");
                return false;
            }
        }
        if (this.useHeuristics.getText().equals("Full rule-based search") || this.useHeuristics.getText().equals("Rule-based search optimal only")) {
            boolean noTacticsSelected = true;
            try {
                noTacticsSelected = !launchConfig.getAttribute("Use processing rate heuristic", false) && !launchConfig.getAttribute("Use reallocation heuristic", false) && !launchConfig.getAttribute("Use server consolidation heuristic", false) && !launchConfig.getAttribute("Use server expansion heuristic", false) && !launchConfig.getAttribute("Use antipattern knowledge", false);
            }
            catch (CoreException coreException) {}
            if (noTacticsSelected) {
                this.setMessage("Make sure to select some tactics when choosing the rule-based search, otherwise nothing will happen.");
                return false;
            }
        }
        return true;
    }

    public void dispose() {
        if (this.icon != null) {
            this.icon.dispose();
        }
    }

    public void activated(ILaunchConfigurationWorkingCopy workingCopy) {
    }

    public void deactivated(ILaunchConfigurationWorkingCopy workingCopy) {
    }

    private String getPathTo(String fileURL) {
        int index = fileURL.lastIndexOf("\\");
        String folderPath = fileURL.substring(0, index + 1);
        return folderPath;
    }

    private String getDefaultDesignDecisionFileName(ILaunchConfiguration configuration) throws CoreException {
        String problemName = configuration.getName();
        return String.valueOf(problemName) + ".designdecision";
    }

    private String getFullDefaultDesignDecisionName(ILaunchConfiguration configuration) throws CoreException {
        String allocFile = configuration.getAttribute("allocationFile", "");
        String path = this.getPathTo(allocFile);
        String name = this.getDefaultDesignDecisionFileName(configuration);
        String fullName = String.valueOf(path) + name;
        return fullName;
    }

    public String getName() {
        return "DSE Options";
    }
}

