/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.dsexplore.launch;

import de.uka.ipd.sdq.dsexplore.analysis.AnalysisProxy;
import de.uka.ipd.sdq.dsexplore.analysis.AnalysisQualityAttributes;
import de.uka.ipd.sdq.dsexplore.analysis.IAnalysis;
import de.uka.ipd.sdq.dsexplore.launch.DSEConstantsContainer;
import de.uka.ipd.sdq.dsexplore.launch.DSELaunch;
import de.uka.ipd.sdq.dsexplore.launch.DSEWorkflowConfiguration;
import de.uka.ipd.sdq.tcfmoop.config.ElapsedTimeConfig;
import de.uka.ipd.sdq.tcfmoop.config.GivenParetoFrontIsReachedConfig;
import de.uka.ipd.sdq.tcfmoop.config.IConfiguration;
import de.uka.ipd.sdq.tcfmoop.config.InsignificantParetoFrontChangeConfig;
import de.uka.ipd.sdq.tcfmoop.config.InsignificantSetQualityImprovementConfig;
import de.uka.ipd.sdq.tcfmoop.config.MaxGenerationNumberConfig;
import de.uka.ipd.sdq.tcfmoop.config.MinimalQualityCriteriaValueConfig;
import de.uka.ipd.sdq.tcfmoop.config.NoNewParetoOptimalCandidatesFoundConfig;
import de.uka.ipd.sdq.tcfmoop.config.ParetoOptimalSetStabilityConfig;
import de.uka.ipd.sdq.tcfmoop.config.exceptions.InvalidConfigException;
import de.uka.ipd.sdq.workflow.launchconfig.core.AbstractWorkflowBasedRunConfiguration;
import de.uka.ipd.sdq.workflow.launchconfig.core.configbuilder.AbstractWorkflowConfigurationBuilder;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.emf.common.util.URI;
import org.opt4j.core.DoubleValue;

public class DSEWorkflowConfigurationBuilder
extends AbstractWorkflowConfigurationBuilder {
    private static Logger logger = Logger.getLogger((String)"de.uka.ipd.sdq.dsexplore.launch.DSEWorkflowConfigurationBuilder");
    DSELaunch dseLaunch;

    public DSEWorkflowConfigurationBuilder(ILaunchConfiguration configuration, String mode, DSELaunch dseLaunch) throws CoreException {
        super(configuration, mode);
        this.dseLaunch = dseLaunch;
    }

    public void fillConfiguration(AbstractWorkflowBasedRunConfiguration abstractConfiguration) throws CoreException {
        String ddfilenameString;
        DSEWorkflowConfiguration config = (DSEWorkflowConfiguration)abstractConfiguration;
        config.setOriginalConfig(this.configuration);
        config.setMaxIterations(this.getIntAttribute("maxIterations"));
        config.setIndividualsPerGeneration(this.getIntAttribute("indivPerGeneration"));
        config.setCrossoverRate(this.getDoubleAttribute("crossover rate"));
        config.setPredefinedInstancesFileName(this.getURIAttribute("predefinedInstances"));
        config.setCacheInstancesFileName(this.getURIAttribute("cacheInstances"));
        config.setPredefinedAllCandidatesFileName(this.getURIAttribute("allCandidates"));
        config.setArchiveCandidateFileName(this.getURIAttribute("archiveCandidates"));
        String searchMethod = this.getStringAttribute("search method");
        if (searchMethod.equals("Evolutionary search")) {
            config.setSearchMethod(DSEWorkflowConfiguration.SearchMethod.EVOLUTIONARY);
        } else if (searchMethod.equals("Random search")) {
            config.setSearchMethod(DSEWorkflowConfiguration.SearchMethod.RANDOM);
        } else if (searchMethod.equals("Full rule-based search")) {
            config.setSearchMethod(DSEWorkflowConfiguration.SearchMethod.RULE);
        } else if (searchMethod.equals("Rule-based search optimal only")) {
            config.setSearchMethod(DSEWorkflowConfiguration.SearchMethod.RULE_OPT);
        } else if (searchMethod.equals("Evolutionary search with Bayesian learning (experimental)")) {
            config.setSearchMethod(DSEWorkflowConfiguration.SearchMethod.EVOLUTIONARY_WITH_BAYES);
        }
        config.setNewProblem(!this.configuration.getAttribute("optimisationOnly", false));
        config.setOptimise(!this.configuration.getAttribute("designDecisionsOnly", false));
        boolean isConsiderQMLBounds = this.getBooleanAttribute("Consider QML bounds");
        config.setConsiderQMLBoundsWhenApplyingHeuristics(isConsiderQMLBounds);
        double tacticsProbability = this.getDoubleAttribute("tactics probability when mating");
        config.setTacticsProbability(tacticsProbability);
        boolean isUseReallocation = this.getBooleanAttribute("Use reallocation heuristic");
        config.setUseReallocation(isUseReallocation);
        if (isUseReallocation) {
            config.setReallocationThresholdUtilisationDifference(this.getDoubleAttribute("Reallocation threshold for utilisation difference"));
            config.setReallocationWeight(this.getDoubleAttribute("Weight of reallocation heuristic"));
        }
        boolean isUseProcRate = this.getBooleanAttribute("Use processing rate heuristic");
        config.setUseProcessingRate(isUseProcRate);
        if (isUseProcRate) {
            config.setProcessingRateDecreaseFactor(this.getDoubleAttribute("Decrease processing rate factor"));
            config.setProcessingRateIncreaseFactor(this.getDoubleAttribute("Increase processing rate factor"));
            config.setProcessingRateThresholdHighUtilisation(this.getDoubleAttribute("Processing rate threshold for high utilisation"));
            config.setProcessingRateThresholdLowUtilisation(this.getDoubleAttribute("Proceesing rate threshold for low utilisation"));
            config.setProcessingRateWeight(this.getDoubleAttribute("Weight of processing rate heuristic"));
        }
        boolean isUseServerConsolidation = this.getBooleanAttribute("Use server consolidation heuristic");
        config.setUseServerConsolidation(isUseServerConsolidation);
        if (isUseServerConsolidation) {
            config.setServerConsolidationThresholdLowUtilisation(this.getDoubleAttribute("Server consolidation threshold for low utilisation"));
            config.setServerConsolidationWeight(this.getDoubleAttribute("Weight of server consolidation heuristic"));
        }
        boolean isUseServerExpansion = this.getBooleanAttribute("Use server expansion heuristic");
        config.setUseServerExpansion(isUseServerExpansion);
        if (isUseServerExpansion) {
            config.setServerExpansionMaxNumberOfReplacements(this.getIntAttribute("Server expansion maximum number of reallocations"));
            config.setServerExpansionThresholdHighUtilisation(this.getDoubleAttribute("Server expansion threshold for high utilisation"));
            config.setServerExpansionWeight(this.getDoubleAttribute("Weight of server expansion heuristic"));
        }
        boolean isUseLinkRealloc = this.getBooleanAttribute("Use Realocation for Link Usage Tactic");
        config.setUseLinkReallocationTactic(isUseLinkRealloc);
        boolean isUseAntipattern = this.getBooleanAttribute("Use antipattern knowledge");
        config.setUseAntipatternKnowledge(isUseAntipattern);
        boolean isUseStartingPop = this.getBooleanAttribute("Use starting population heuristic");
        config.setUseStartingPopulationHeuristic(isUseStartingPop);
        if (isUseStartingPop) {
            config.setMinNumberOfResourceContainers(this.getIntAttribute("Minimum number of resource containers"));
            config.setMaxNumberOfResourceContainers(this.getIntAttribute("Maximum number of resource containers"));
            config.setNumberOfCandidatesPerAllocationLevel(this.getIntAttribute("Number of candidates per allocation level"));
        }
        URI ddfilename = (ddfilenameString = this.configuration.getAttribute("designDecisionFile", "")).length() != 0 ? URI.createURI((String)ddfilenameString) : this.getDefaultDesignDecisionFileName();
        config.setDesignDecisionFileName(ddfilename);
        URI resultsPath = this.createOrReuseResultFolder();
        config.setResultFolder(resultsPath);
        config.setConfigurationName(this.configuration.getName());
        ArrayList<IAnalysis> evaluators = new ArrayList<IAnalysis>();
        for (DSEConstantsContainer.QualityAttribute d : new AnalysisQualityAttributes().getAllQualityAttributes()) {
            this.addEvaluatorsIfSelected(evaluators, d, config);
        }
        config.setEvaluators(evaluators);
        this.addTerminationCriteriaSettings(config);
        config.setStopOnInitialFailure(this.getBooleanAttribute("Stop on initial failure"));
        config.setResultsAsEMF(this.getBooleanAttribute("store results as EMF"));
        config.setResultsAsCSV(this.getBooleanAttribute("store results as CSV"));
    }

    private URI createOrReuseResultFolder() throws CoreException {
        URI folderPathOnly = this.getPathToAllocation();
        URI resultsPath = folderPathOnly.appendSegment("PerOpteryx_results");
        if (resultsPath.isPlatform()) {
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            IFolder resultFolder = workspace.getRoot().getFolder((IPath)new Path(resultsPath.toPlatformString(true)));
            if (!resultFolder.exists()) {
                resultFolder.create(true, true, null);
            }
        } else {
            File f = new File(resultsPath.toFileString());
            if (f.exists()) {
                if (!f.isDirectory()) {
                    throw new CoreException((IStatus)new Status(4, "de.uka.ipd.sdq.dsexplore.launch.DSEWorkflowConfigurationBuilder", "File " + resultsPath + " already exists and is not a directory, please rename that file."));
                }
            } else {
                f.mkdir();
            }
        }
        return resultsPath;
    }

    private URI getURIAttribute(String constant) throws CoreException {
        String asString = this.getStringAttribute(constant);
        if (asString == null || "".equals(asString)) {
            return null;
        }
        try {
            URI fileURI;
            URI uri = URI.createURI((String)asString);
            if ((uri == null || !uri.isPlatform()) && (fileURI = URI.createFileURI((String)asString)) != null && fileURI.isFile()) {
                uri = fileURI;
            }
            return uri;
        }
        catch (IllegalArgumentException e) {
            logger.error((Object)("Launch configuration value '" + asString + "' is not a valid URI. Using null instead: " + e.getClass() + " " + e.getMessage()));
            return null;
        }
    }

    private void addEvaluatorsIfSelected(ArrayList<IAnalysis> evaluators, DSEConstantsContainer.QualityAttribute d, DSEWorkflowConfiguration config) throws CoreException {
        String methodName = this.configuration.getAttribute(DSEConstantsContainer.getAnalysisMethod(d), "");
        if (!methodName.equals("none")) {
            AnalysisProxy analysis = new AnalysisProxy(config, d, this.dseLaunch, methodName);
            evaluators.add(analysis);
        }
    }

    private URI getPathToAllocation() throws CoreException {
        String allocFileName = this.configuration.getAttribute("allocationFile", "");
        URI folderPathOnly = this.getPathTo(allocFileName);
        if (folderPathOnly == null) {
            throw new CoreException((IStatus)new Status(4, "de.uka.ipd.sdq.dsexplore.launch.DSEWorkflowConfigurationBuilder", "Cannot determine path to allocation model to decide where to put the result files. Please check you allocation model."));
        }
        return folderPathOnly;
    }

    private int getIntAttribute(String key) throws CoreException {
        String stringValue = this.configuration.getAttribute(key, "0");
        if (stringValue.equals("")) {
            return 0;
        }
        int i = Integer.parseInt(stringValue);
        return i;
    }

    private URI getDefaultDesignDecisionFileName() throws CoreException {
        String problemName = this.configuration.getName();
        return this.getPathToAllocation().appendSegment(String.valueOf(problemName) + ".designdecision");
    }

    private URI getPathTo(String fileURL) {
        URI myURI = URI.createURI((String)fileURL);
        if (myURI == null || !myURI.isPlatform()) {
            myURI = URI.createFileURI((String)fileURL);
        }
        return myURI.trimSegments(1);
    }

    private void addTerminationCriteriaSettings(DSEWorkflowConfiguration config) throws CoreException {
        config.setUseTerminationCriteria(this.getBooleanAttribute("Use Termination Criteria"));
        if (config.getUseTerminationCriteria()) {
            String item;
            String[] stringArray;
            LinkedList<String[]> decodedLines;
            String[] configuredObjectivesLines;
            config.setRunInComparisionMode(this.getBooleanAttribute("Run in comparision mode"));
            config.setActivateComposedTerminationCriteria(this.getBooleanAttribute("Activate composed Criteria"));
            if (config.getActivateComposedTerminationCriteria()) {
                config.setComposedCriteriaExpression(this.getStringAttribute("Composed Criteria Expression"));
            }
            if (this.getBooleanAttribute("Activate Maximum number of generation").booleanValue()) {
                try {
                    MaxGenerationNumberConfig mgnc = new MaxGenerationNumberConfig();
                    mgnc.setMaximumNumberOfIterations(this.getIntegerAttribute("Maximum Number Of Generations"));
                    config.getTCConfigurations().add((IConfiguration)mgnc);
                }
                catch (InvalidConfigException e) {
                    e.printStackTrace();
                }
            }
            if (this.getBooleanAttribute("Activate Elapsed Time Criterion").booleanValue()) {
                try {
                    ElapsedTimeConfig etc = new ElapsedTimeConfig();
                    etc.setExecutionInterval((long)(this.getIntegerAttribute("Time in minutes") * 60) * 1000L);
                    if (this.getStringAttribute("Type of the measured time").equalsIgnoreCase("USER_TIME")) {
                        etc.setTimeType(ElapsedTimeConfig.TimeType.USER_TIME);
                        config.getTCConfigurations().add((IConfiguration)etc);
                    } else if (this.getStringAttribute("Type of the measured time").equalsIgnoreCase("CPU_TIME")) {
                        etc.setTimeType(ElapsedTimeConfig.TimeType.CPU_TIME);
                        etc.setExecutionInterval((long)(this.getIntegerAttribute("Time in minutes") * 60) * 1000L);
                        config.getTCConfigurations().add((IConfiguration)etc);
                    }
                }
                catch (InvalidConfigException e) {
                    e.printStackTrace();
                }
            }
            if (this.getBooleanAttribute("Activate No New Pareto Optimal Candidates").booleanValue()) {
                try {
                    NoNewParetoOptimalCandidatesFoundConfig nnpocf = new NoNewParetoOptimalCandidatesFoundConfig();
                    nnpocf.setIterationsWithoutNewCandidates(this.getIntegerAttribute("Iterations without new Pareto optimal candidates"));
                    config.getTCConfigurations().add((IConfiguration)nnpocf);
                }
                catch (InvalidConfigException e) {
                    e.printStackTrace();
                }
            }
            if (this.getBooleanAttribute("Activate Pareto Optimal Set Stability").booleanValue()) {
                try {
                    ParetoOptimalSetStabilityConfig poss = new ParetoOptimalSetStabilityConfig();
                    poss.setMinimumIterationsToSurvive(this.getIntegerAttribute("Minimum iterations to survive"));
                    if (this.getStringAttribute("Evaluation Mode").equalsIgnoreCase("EXACT_NUMBER")) {
                        poss.setEvaluationMode(ParetoOptimalSetStabilityConfig.EvaluationMode.EXACT_NUMBER);
                        poss.setMinimumSurvivors(this.getIntegerAttribute("Exact number of survivors"));
                    } else if (this.getStringAttribute("Evaluation Mode").equalsIgnoreCase("PERCENTAGE")) {
                        poss.setEvaluationMode(ParetoOptimalSetStabilityConfig.EvaluationMode.PERCENTAGE);
                        poss.setMinimumSurvivorsInPercentage((double)this.getIntegerAttribute("Percentage number of survivors") / 100.0);
                    }
                    config.getTCConfigurations().add((IConfiguration)poss);
                }
                catch (InvalidConfigException e) {
                    e.printStackTrace();
                }
            }
            if (this.getBooleanAttribute("Activate Minimal Quality Criteria Value").booleanValue()) {
                try {
                    MinimalQualityCriteriaValueConfig mqcvc = new MinimalQualityCriteriaValueConfig();
                    mqcvc.setNumberOfCandidatesToConform(this.getIntegerAttribute("Number of candidates to conform"));
                    configuredObjectivesLines = this.getStringAttribute("Configured objectives with values").split(";");
                    decodedLines = new LinkedList<String[]>();
                    stringArray = configuredObjectivesLines;
                    int n = configuredObjectivesLines.length;
                    int n2 = 0;
                    while (n2 < n) {
                        item = stringArray[n2];
                        decodedLines.add(item.split("\\|"));
                        ++n2;
                    }
                    HashMap<String, DoubleValue> unresolvedObjectives = new HashMap<String, DoubleValue>();
                    for (String[] singleLine : decodedLines) {
                        unresolvedObjectives.put(singleLine[0], new DoubleValue(Double.valueOf(Double.parseDouble(singleLine[1]))));
                    }
                    mqcvc.setUnresolvedObjectiveMinimalValue(unresolvedObjectives);
                    config.getTCConfigurations().add((IConfiguration)mqcvc);
                }
                catch (InvalidConfigException e) {
                    e.printStackTrace();
                }
            }
            if (this.getBooleanAttribute("Activate a Given Pareto Front Is reached").booleanValue()) {
                try {
                    GivenParetoFrontIsReachedConfig gpfir = new GivenParetoFrontIsReachedConfig();
                    gpfir.setParetoFrontFile(this.getStringAttribute("Path to the pareto front description file"));
                    gpfir.setPercentagesToCover((double)this.getIntegerAttribute("Percentages to cover") / 100.0);
                    config.getTCConfigurations().add((IConfiguration)gpfir);
                }
                catch (InvalidConfigException e) {
                    e.printStackTrace();
                }
            }
            if (this.getBooleanAttribute("Activate Insignificant Set Quality Improvement").booleanValue()) {
                try {
                    InsignificantSetQualityImprovementConfig isqic = new InsignificantSetQualityImprovementConfig();
                    isqic.setComparisionGenerations(this.configuration.getAttribute("Number of the n-x generation", 1));
                    configuredObjectivesLines = this.getStringAttribute("Configured Objectives with averages").split(";");
                    decodedLines = new LinkedList();
                    stringArray = configuredObjectivesLines;
                    int n = configuredObjectivesLines.length;
                    int singleLine = 0;
                    while (singleLine < n) {
                        item = stringArray[singleLine];
                        decodedLines.add(item.split("\\|"));
                        ++singleLine;
                    }
                    LinkedList<InsignificantSetQualityImprovementConfig.UnresolvedValueDifference> unresolvedValueDifferences = new LinkedList<InsignificantSetQualityImprovementConfig.UnresolvedValueDifference>();
                    for (String[] singleLine2 : decodedLines) {
                        InsignificantSetQualityImprovementConfig insignificantSetQualityImprovementConfig = isqic;
                        insignificantSetQualityImprovementConfig.getClass();
                        unresolvedValueDifferences.add(new InsignificantSetQualityImprovementConfig.UnresolvedValueDifference(insignificantSetQualityImprovementConfig, singleLine2[0], Double.valueOf(Double.parseDouble(singleLine2[1]) / 100.0), Double.valueOf(Double.parseDouble(singleLine2[2]) / 100.0)));
                    }
                    isqic.setUnresolvedValueDifferences(unresolvedValueDifferences);
                    config.getTCConfigurations().add((IConfiguration)isqic);
                }
                catch (InvalidConfigException e) {
                    e.printStackTrace();
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (this.getBooleanAttribute("Activate Insignificant Pareto Front Change").booleanValue()) {
                try {
                    InsignificantParetoFrontChangeConfig ipfc = new InsignificantParetoFrontChangeConfig();
                    ipfc.setPastIterationNumber(this.getIntegerAttribute("Number of the n-x generation for front"));
                    ipfc.setMinimumAllowedDifference((double)this.getIntegerAttribute("Minimum percentage improvement") / 100.0);
                    config.getTCConfigurations().add((IConfiguration)ipfc);
                }
                catch (InvalidConfigException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

