/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.dsexplore.opt4j.archive;

import com.google.inject.Inject;
import de.uka.ipd.sdq.dsexplore.analysis.PCMPhenotype;
import de.uka.ipd.sdq.dsexplore.helper.FilterParetoOptimalIndividuals;
import de.uka.ipd.sdq.dsexplore.opt4j.representation.DSEIndividual;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;
import org.opt4j.core.Individual;
import org.opt4j.core.IndividualSet;
import org.opt4j.core.IndividualSetListener;
import org.opt4j.core.optimizer.Population;

public class PopulationTracker
implements IndividualSetListener {
    private List<DSEIndividual> individuals = new LinkedList<DSEIndividual>();
    private static Logger logger = Logger.getLogger((String)"de.uka.ipd.sdq.dsexplore.opt4j.archive.DSEListener");

    @Inject
    public PopulationTracker(Population population) {
        population.addListener((IndividualSetListener)this);
    }

    public void individualAdded(IndividualSet collection, Individual individual) {
        if (individual instanceof DSEIndividual) {
            this.individuals.add((DSEIndividual)individual);
        } else {
            logger.error((Object)"It has been attempted to add an individual that is not a DSEIndividual to the archive. Fix your implementation.");
        }
    }

    public List<DSEIndividual> getIndividuals() {
        return this.individuals;
    }

    public void individualRemoved(IndividualSet collection, Individual individual) {
    }

    public List<DSEIndividual> getParetoOptimalIndividuals() {
        ArrayList<DSEIndividual> optimalList = new ArrayList<DSEIndividual>(this.individuals.size());
        optimalList.addAll(this.individuals);
        return FilterParetoOptimalIndividuals.filterPareto(optimalList);
    }

    public DSEIndividual getIndividualForPhenotype(PCMPhenotype pheno) {
        for (DSEIndividual i : this.individuals) {
            if (i.getPhenotype() == null || i.getPhenotype() != pheno) continue;
            return i;
        }
        return null;
    }

    public int size() {
        return this.individuals.size();
    }

    public boolean addIndividualsManually(DSEIndividual individual) {
        if (individual != null && individual.isEvaluated()) {
            return this.individuals.add(individual);
        }
        throw new RuntimeException("Only evaluated candidates may be added to PopulationTracker!");
    }
}

