/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.dsexplore.opt4j.optimizer.heuristic.operators.impl;

import de.uka.ipd.sdq.dsexplore.launch.DSEWorkflowConfiguration;
import de.uka.ipd.sdq.dsexplore.opt4j.optimizer.heuristic.operators.TacticsResultCandidate;
import de.uka.ipd.sdq.dsexplore.opt4j.optimizer.heuristic.operators.UtilisationResultCacheAndHelper;
import de.uka.ipd.sdq.dsexplore.opt4j.optimizer.heuristic.operators.impl.AbstractProcessingRateTactic;
import de.uka.ipd.sdq.dsexplore.opt4j.representation.DSEIndividual;
import de.uka.ipd.sdq.dsexplore.opt4j.representation.DSEIndividualFactory;
import de.uka.ipd.sdq.pcm.designdecision.ContinousRangeChoice;
import de.uka.ipd.sdq.pcm.designdecision.DiscreteRangeChoice;
import de.uka.ipd.sdq.pcm.designdecision.specific.ContinuousProcessingRateDegree;
import de.uka.ipd.sdq.pcm.designdecision.specific.NumberOfCoresAsListDegree;
import de.uka.ipd.sdq.pcm.designdecision.specific.NumberOfCoresAsRangeDegree;
import de.uka.ipd.sdq.pcm.designdecision.specific.NumberOfCoresDegree;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.opt4j.core.Genotype;
import org.opt4j.operator.copy.Copy;
import org.palladiosimulator.analyzer.resultdecorator.resourceenvironmentdecorator.ProcessingResourceSpecificationResult;
import org.palladiosimulator.analyzer.resultdecorator.resourceenvironmentdecorator.UtilisationResult;
import org.palladiosimulator.pcm.resourceenvironment.ProcessingResourceSpecification;
import org.palladiosimulator.pcm.resourcetype.ResourceType;

public class IncreaseProcessingRateImpl
extends AbstractProcessingRateTactic {
    private double increaseProcessingRateFactor;
    private double thresholdHighUtilisation;

    public IncreaseProcessingRateImpl(Copy<Genotype> copy, DSEIndividualFactory individualFactory, DSEWorkflowConfiguration configuration) {
        super(copy, individualFactory, configuration, new String[]{"pathmap://PCM_MODELS/Dimension_responsetime.qmlcontracttype", "pathmap://PCM_MODELS/Dimension_throughput.qmlcontracttype", "pathmap://PCM_MODELS/Dimension_maxCPUUtilization.qmlcontracttype"});
        this.setHeuristicWeight(configuration.getProcessingRateWeight());
        this.increaseProcessingRateFactor = configuration.getProcessingRateIncreaseFactor();
        this.thresholdHighUtilisation = configuration.getProcessingRateThresholdHighUtilisation();
    }

    private boolean doesMatchHighUtilisation(DSEIndividual individual, UtilisationResultCacheAndHelper resultsCache, ResourceType resourceType) {
        ProcessingResourceSpecificationResult maxUtilisationResult = resultsCache.getMaxProcUtilisationResult(individual, resourceType);
        return maxUtilisationResult != null && maxUtilisationResult.getResourceUtilisation() >= this.thresholdHighUtilisation;
    }

    public boolean doesMatchPrecondition(DSEIndividual individual, UtilisationResultCacheAndHelper resultsCache) {
        Set<ResourceType> resourceTypes = resultsCache.getResourceTypes(individual);
        for (ResourceType resourceType : resourceTypes) {
            boolean resourceTypeMatches = this.doesMatchHighUtilisation(individual, resultsCache, resourceType);
            if (!resourceTypeMatches) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<TacticsResultCandidate> getHeuristicCandidates(DSEIndividual individual, UtilisationResultCacheAndHelper resultCache) {
        ArrayList<TacticsResultCandidate> candidates = new ArrayList<TacticsResultCandidate>();
        Set<ResourceType> resourceTypes = resultCache.getResourceTypes(individual);
        for (ResourceType resourceType : resourceTypes) {
            if (resourceType.getEntityName().equals("DELAY") || !this.doesMatchHighUtilisation(individual, resultCache, resourceType)) continue;
            this.addNewCandidatesWithIncreasedProcessingRateOrCores(individual, candidates, resultCache, resourceType);
        }
        return candidates;
    }

    private void addNewCandidatesWithIncreasedProcessingRateOrCores(DSEIndividual individual, Collection<TacticsResultCandidate> candidates, UtilisationResultCacheAndHelper resultsCache, ResourceType resourceType) {
        ProcessingResourceSpecificationResult maxUtilisationResult = resultsCache.getMaxProcUtilisationResult(individual, resourceType);
        ProcessingResourceSpecification maxUtilProcessingResource = maxUtilisationResult.getProcessingResourceSpecification_ProcessingResourceSpecificationResult();
        this.addNewProcRateCandidate(individual, candidates, maxUtilisationResult, maxUtilProcessingResource);
        this.addNewNumberOfCoresCandidate(individual, candidates, maxUtilisationResult, maxUtilProcessingResource);
    }

    @Override
    public double getCandidateWeight(UtilisationResult utilisationResult) {
        return this.getCandidateWeightForHighUtilisation(utilisationResult);
    }

    @Override
    protected double getUpdatedProcessingRate(ContinousRangeChoice continousRangeChoice, ContinuousProcessingRateDegree processingRateDegree) {
        return this.getIncreasedProcessingRate(continousRangeChoice, processingRateDegree);
    }

    private double getIncreasedProcessingRate(ContinousRangeChoice continousRangeChoice, ContinuousProcessingRateDegree processingRateDegree) {
        return Math.min(continousRangeChoice.getChosenValue() * (1.0 + this.increaseProcessingRateFactor), processingRateDegree.getTo());
    }

    private double getCandidateWeightForHighUtilisation(UtilisationResult utilisationResult) {
        if (this.thresholdHighUtilisation >= 1.0) {
            return 0.0;
        }
        return Math.min(1.0, Math.max(0.0, (utilisationResult.getResourceUtilisation() - this.thresholdHighUtilisation) / (1.0 - this.thresholdHighUtilisation)));
    }

    @Override
    protected int getUpdatedNumberOfCores(DiscreteRangeChoice discreteChoice, NumberOfCoresDegree numberOfCoresDegree) {
        if (numberOfCoresDegree instanceof NumberOfCoresAsRangeDegree) {
            NumberOfCoresAsRangeDegree asRangeDegree = (NumberOfCoresAsRangeDegree)numberOfCoresDegree;
            return Math.min(discreteChoice.getChosenValue() + 1, asRangeDegree.isUpperBoundIncluded() ? asRangeDegree.getTo() : asRangeDegree.getTo() - 1);
        }
        if (numberOfCoresDegree instanceof NumberOfCoresAsListDegree) {
            NumberOfCoresAsListDegree asListDegree = (NumberOfCoresAsListDegree)numberOfCoresDegree;
            int nextLargestInteger = Integer.MAX_VALUE;
            int currentValue = discreteChoice.getChosenValue();
            for (Integer value : asListDegree.getListOfIntegers()) {
                if (value <= currentValue || value > nextLargestInteger) continue;
                nextLargestInteger = value;
            }
            if (nextLargestInteger != Integer.MAX_VALUE) {
                return nextLargestInteger;
            }
            return currentValue;
        }
        throw new RuntimeException("Unknown degree of freedom " + numberOfCoresDegree.getClass().getName() + ", please adjust " + this.getClass().getName());
    }
}

