/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.dsexplore.opt4j.optimizer.heuristic.operators.impl;

import de.uka.ipd.sdq.dsexplore.helper.EMFHelper;
import de.uka.ipd.sdq.dsexplore.launch.DSEWorkflowConfiguration;
import de.uka.ipd.sdq.dsexplore.opt4j.genotype.DesignDecisionGenotype;
import de.uka.ipd.sdq.dsexplore.opt4j.optimizer.heuristic.operators.AbstractTactic;
import de.uka.ipd.sdq.dsexplore.opt4j.optimizer.heuristic.operators.TacticsResultCandidate;
import de.uka.ipd.sdq.dsexplore.opt4j.optimizer.heuristic.operators.UtilisationResultCacheAndHelper;
import de.uka.ipd.sdq.dsexplore.opt4j.representation.DSEIndividual;
import de.uka.ipd.sdq.dsexplore.opt4j.representation.DSEIndividualFactory;
import de.uka.ipd.sdq.pcm.designdecision.Choice;
import de.uka.ipd.sdq.pcm.designdecision.ClassChoice;
import de.uka.ipd.sdq.pcm.designdecision.DegreeOfFreedomInstance;
import de.uka.ipd.sdq.pcm.designdecision.specific.AllocationDegree;
import de.uka.ipd.sdq.pcm.designdecision.specific.ClassDegree;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EObject;
import org.opt4j.core.Genotype;
import org.opt4j.operator.copy.Copy;
import org.palladiosimulator.analyzer.resultdecorator.resourceenvironmentdecorator.ProcessingResourceSpecificationResult;
import org.palladiosimulator.analyzer.resultdecorator.resourceenvironmentdecorator.UtilisationResult;
import org.palladiosimulator.pcm.core.entity.Entity;
import org.palladiosimulator.pcm.resourceenvironment.ResourceContainer;
import org.palladiosimulator.pcm.resourcetype.ResourceType;

public class ServerConsolidationImpl
extends AbstractTactic {
    private double thresholdLowUtilisation;
    private double maxUtilisationForOtherServers = 0.9;
    private Random generator = new Random();
    private UtilisationResultCacheAndHelper resultCache = new UtilisationResultCacheAndHelper();
    protected static Logger logger = Logger.getLogger((String)ServerConsolidationImpl.class.getName());

    public ServerConsolidationImpl(Copy<Genotype> copy, DSEIndividualFactory individualFactory, DSEWorkflowConfiguration configuration) {
        super(copy, individualFactory, configuration, new String[]{"pathmap://PCM_MODELS/Dimension_cost.qmlcontracttype", "pathmap://PCM_MODELS/Dimension_pofod.qmlcontracttype"});
        this.setHeuristicWeight(configuration.getServerConsolidationWeight());
        this.thresholdLowUtilisation = configuration.getServerConsolidationThresholdLowUtilisation();
    }

    public boolean doesMatchPrecondition(DSEIndividual individual) {
        return this.getHeuristicCandidates(individual, this.resultCache).size() > 0;
    }

    @Override
    public List<TacticsResultCandidate> getHeuristicCandidates(DSEIndividual individual, UtilisationResultCacheAndHelper resultsHelper) {
        this.resultCache = resultsHelper;
        ArrayList<TacticsResultCandidate> candidates = new ArrayList<TacticsResultCandidate>();
        Set<ResourceType> resourceTypes = this.resultCache.getResourceTypes(individual);
        for (ResourceType resourceType : resourceTypes) {
            candidates.addAll(this.getHeuristicCandidateForResourceType(individual, resourceType));
        }
        return candidates;
    }

    private List<TacticsResultCandidate> getHeuristicCandidateForResourceType(DSEIndividual individual, ResourceType cpu) {
        ArrayList<TacticsResultCandidate> candidates = new ArrayList<TacticsResultCandidate>();
        ProcessingResourceSpecificationResult minUtilisationResult = this.resultCache.getMinProcUtilisationResult(individual, cpu);
        if (minUtilisationResult == null || minUtilisationResult.getResourceUtilisation() > this.thresholdLowUtilisation || cpu == null) {
            return candidates;
        }
        double utilisation = minUtilisationResult.getResourceUtilisation();
        ResourceContainer identifiedContainer = minUtilisationResult.getProcessingResourceSpecification_ProcessingResourceSpecificationResult().getResourceContainer_ProcessingResourceSpecification();
        TacticsResultCandidate candidate = this.individualFactory.buildCandidate(this.copy.copy((Genotype)individual.getGenotype()), individual);
        DesignDecisionGenotype genotype = candidate.getGenotype();
        ArrayList<ClassChoice> componentAllocationToRChoices = new ArrayList<ClassChoice>(genotype.size());
        Iterator<Choice> iterator = genotype.iterator();
        while (iterator.hasNext()) {
            ClassChoice enumChoice;
            DegreeOfFreedomInstance degree;
            Choice choice = iterator.next();
            if (!(choice instanceof ClassChoice) || !((degree = (enumChoice = (ClassChoice)choice).getDegreeOfFreedomInstance()) instanceof AllocationDegree) || !EMFHelper.checkIdentity(enumChoice.getChosenValue(), (EObject)identifiedContainer)) continue;
            componentAllocationToRChoices.add(enumChoice);
            logger.debug((Object)("Found component allocated to underutilised container " + identifiedContainer.getEntityName()));
        }
        int numberOfComponentDeployedToR = componentAllocationToRChoices.size();
        if (numberOfComponentDeployedToR > 0) {
            List<ProcessingResourceSpecificationResult> procUtils = UtilisationResultCacheAndHelper.getProcessingResourceUtilisationResults(individual);
            Collections.sort(procUtils, new UtilisationResultCacheAndHelper.UtilisationComparator());
            double utilSharePerComponent = utilisation / (double)numberOfComponentDeployedToR;
            for (ProcessingResourceSpecificationResult processingResourceSpecificationResult : procUtils) {
                ResourceContainer targetContainer = processingResourceSpecificationResult.getProcessingResourceSpecification_ProcessingResourceSpecificationResult().getResourceContainer_ProcessingResourceSpecification();
                if (targetContainer == identifiedContainer || !EMFHelper.contains(this.resultCache.getAvailableResourceContainers(individual), (EObject)targetContainer) || EMFHelper.contains(this.resultCache.getUnusedAvailableResourceContainers(individual), (EObject)targetContainer) || !EMFHelper.checkIdentity((EObject)processingResourceSpecificationResult.getProcessingResourceSpecification_ProcessingResourceSpecificationResult().getActiveResourceType_ActiveResourceSpecification(), (EObject)minUtilisationResult.getProcessingResourceSpecification_ProcessingResourceSpecificationResult().getActiveResourceType_ActiveResourceSpecification())) continue;
                double util = processingResourceSpecificationResult.getResourceUtilisation();
                int numberOfComponentsToDeployHere = (int)((this.maxUtilisationForOtherServers - util) / utilSharePerComponent);
                int i = 0;
                while (i < numberOfComponentsToDeployHere && componentAllocationToRChoices.size() > 0) {
                    ClassChoice reallocateChoice = (ClassChoice)componentAllocationToRChoices.get(this.generator.nextInt(componentAllocationToRChoices.size()));
                    componentAllocationToRChoices.remove(reallocateChoice);
                    Entity newContainer = EMFHelper.retrieveEntityByID((List<? extends EObject>)((ClassDegree)reallocateChoice.getDegreeOfFreedomInstance()).getClassDesignOptions(), (EObject)targetContainer);
                    if (newContainer != null) {
                        reallocateChoice.setChosenValue((EObject)newContainer);
                    } else {
                        --i;
                    }
                    logger.debug((Object)("Reallocate component " + reallocateChoice.getDegreeOfFreedomInstance().getPrimaryChanged() + " to server " + targetContainer));
                    ++i;
                }
                if (componentAllocationToRChoices.size() == 0) break;
            }
            if (componentAllocationToRChoices.size() == 0) {
                candidates.add(candidate);
                candidate.setCandidateWeight(this.getCandidateWeight((UtilisationResult)minUtilisationResult));
                candidate.setHeuristic(this);
                this.increaseCounterOfGeneratedCandidates();
            }
        }
        return candidates;
    }

    private double getCandidateWeight(UtilisationResult u1) {
        return (this.thresholdLowUtilisation - u1.getResourceUtilisation()) / this.thresholdLowUtilisation;
    }
}

