/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.dsexplore.constraints;

import FeatureCompletionModel.ArchitectureConstraints;
import FeatureCompletionModel.CompletionComponent;
import FeatureCompletionModel.ConstrainableElement;
import FeatureCompletionModel.Constraint;
import FeatureCompletionModel.FeatureCompletion;
import de.uka.ipd.sdq.dsexplore.opt4j.genotype.DesignDecisionGenotype;
import de.uka.ipd.sdq.pcm.designdecision.Choice;
import de.uka.ipd.sdq.pcm.designdecision.ClassChoice;
import de.uka.ipd.sdq.pcm.designdecision.specific.AllocationDegree;
import de.uka.ipd.sdq.pcm.designdecision.specific.FeatureCompletionDegree;
import edu.kit.ipd.are.dsexplore.featurecompletions.weaver.port.FCCWeaverException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import org.eclipse.emf.common.util.EList;
import org.palladiosimulator.pcm.resourceenvironment.ResourceContainer;

public class DesignSpaceConstraintManager {
    private static DesignSpaceConstraintManager instance = new DesignSpaceConstraintManager();
    private Map<Constraint, BiFunction<ArchitectureConstraints, DesignDecisionGenotype, Boolean>> constraintHandlers = new HashMap<Constraint, BiFunction<ArchitectureConstraints, DesignDecisionGenotype, Boolean>>();

    private DesignSpaceConstraintManager() {
        this.constraintHandlers.put(Constraint.ISOLATED, this::checkIsolatedConstraint);
        this.constraintHandlers.put(Constraint.SEPARATED, this::checkSeparatedConstraint);
        this.constraintHandlers.put(Constraint.TOGETHER, this::checkTogetherConstraint);
        this.constraintHandlers.put(Constraint.ANY, this::checkAnyConstraint);
    }

    public static Optional<DesignSpaceConstraintManager> getInstanceBy(DesignDecisionGenotype genotype) throws NullPointerException {
        Optional<FeatureCompletion> featureCompletion = DesignSpaceConstraintManager.getFCFrom(genotype);
        if (!featureCompletion.isPresent()) {
            return Optional.empty();
        }
        return Optional.of(instance);
    }

    private static Optional<FeatureCompletion> getFCFrom(DesignDecisionGenotype genotype) {
        return genotype.stream().filter(eachChoice -> eachChoice.getDegreeOfFreedomInstance() instanceof FeatureCompletionDegree).map(choice -> (FeatureCompletion)choice.getDegreeOfFreedomInstance().getPrimaryChanged()).findFirst();
    }

    public boolean violatesNoConstraint(DesignDecisionGenotype genotype) {
        Optional<FeatureCompletion> fc = DesignSpaceConstraintManager.getFCFrom(genotype);
        if (!fc.isPresent()) {
            return true;
        }
        EList archConstraints = fc.get().getArchitectureConstraints();
        for (ArchitectureConstraints ac : archConstraints) {
            boolean valid = this.constraintHandlers.get(ac.getConstraint()).apply(ac, genotype);
            if (valid) continue;
            return false;
        }
        return true;
    }

    private List<ClassChoice> getAllocationChoices(List<Choice> choices, boolean onlyFCCs) {
        ArrayList<ClassChoice> allocationChoices = new ArrayList<ClassChoice>();
        for (Choice c : choices) {
            if (!(c.getDegreeOfFreedomInstance() instanceof AllocationDegree) || onlyFCCs && !(c.getDegreeOfFreedomInstance().getPrimaryChanged() instanceof CompletionComponent)) continue;
            allocationChoices.add((ClassChoice)c);
        }
        return allocationChoices;
    }

    private ClassChoice findConstrainableElementInClassChoice(List<ClassChoice> allocationChoices, ConstrainableElement ce) {
        for (ClassChoice classChoice : allocationChoices) {
            CompletionComponent fcc = (CompletionComponent)((AllocationDegree)classChoice.getDegreeOfFreedomInstance()).getPrimaryChanged();
            if (!fcc.getId().equals(ce.getId())) continue;
            return classChoice;
        }
        throw new FCCWeaverException("no class choice found for " + ce);
    }

    private int countAllocationsOnResourceContainer(List<Choice> allChoices, ResourceContainer resource) {
        int counter = 0;
        List<ClassChoice> allocationChoices = this.getAllocationChoices(allChoices, false);
        for (ClassChoice choice : allocationChoices) {
            ResourceContainer rescont = (ResourceContainer)choice.getChosenValue();
            if (!rescont.getId().equals(resource.getId())) continue;
            ++counter;
        }
        return counter;
    }

    private Boolean checkIsolatedConstraint(ArchitectureConstraints archConstr, DesignDecisionGenotype ddg) {
        List<ClassChoice> allocationChoices = this.getAllocationChoices((List<Choice>)((Object)ddg), true);
        for (ConstrainableElement ce : archConstr.getArchitectureElements()) {
            ClassChoice allocationChoice = this.findConstrainableElementInClassChoice(allocationChoices, ce);
            ResourceContainer targetResource = (ResourceContainer)allocationChoice.getChosenValue();
            if (this.countAllocationsOnResourceContainer((List<Choice>)((Object)ddg), targetResource) == 1) continue;
            return false;
        }
        return true;
    }

    private Boolean checkTogetherConstraint(ArchitectureConstraints archConstr, DesignDecisionGenotype ddg) {
        List<ClassChoice> allocaChoices = this.getAllocationChoices((List<Choice>)((Object)ddg), true);
        EList ces = archConstr.getArchitectureElements();
        if (ces.size() == 0) {
            return true;
        }
        ResourceContainer targetResource = (ResourceContainer)this.findConstrainableElementInClassChoice(allocaChoices, (ConstrainableElement)ces.get(0)).getChosenValue();
        for (ConstrainableElement ce : ces) {
            ResourceContainer currentResource = (ResourceContainer)this.findConstrainableElementInClassChoice(allocaChoices, ce).getChosenValue();
            if (targetResource.getId().equals(currentResource.getId())) continue;
            return false;
        }
        return true;
    }

    private Boolean checkSeparatedConstraint(ArchitectureConstraints archConstr, DesignDecisionGenotype ddg) {
        List<ClassChoice> allocaChoices = this.getAllocationChoices((List<Choice>)((Object)ddg), true);
        EList ces = archConstr.getArchitectureElements();
        HashSet<String> resourceContainerIds = new HashSet<String>();
        for (ConstrainableElement ce : ces) {
            ResourceContainer currentResource = (ResourceContainer)this.findConstrainableElementInClassChoice(allocaChoices, ce).getChosenValue();
            if (resourceContainerIds.add(currentResource.getId())) continue;
            return false;
        }
        return true;
    }

    private Boolean checkAnyConstraint(ArchitectureConstraints archConstr, DesignDecisionGenotype ddg) {
        return true;
    }
}

