/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.dsexplore.opt4j.representation;

import com.google.inject.Inject;
import de.uka.ipd.sdq.dsexplore.analysis.IAnalysisResult;
import de.uka.ipd.sdq.dsexplore.analysis.IPerformanceAnalysisResult;
import de.uka.ipd.sdq.dsexplore.analysis.IStatisticAnalysisResult;
import de.uka.ipd.sdq.statistics.estimation.ConfidenceInterval;
import java.util.HashMap;
import java.util.Map;
import org.opt4j.core.Constraint;
import org.opt4j.core.Criterion;
import org.opt4j.core.Objective;
import org.opt4j.core.Objectives;
import org.opt4j.core.Value;
import org.opt4j.core.domination.DominationStrategy;
import org.palladiosimulator.analyzer.resultdecorator.ResultDecoratorRepository;
import org.palladiosimulator.solver.context.aggregatedUsageContext.ComputedAggregatedUsage;

public class DSEObjectives
extends Objectives {
    private Map<Criterion, ConfidenceInterval> confidence = new HashMap<Criterion, ConfidenceInterval>();
    private Map<Criterion, ResultDecoratorRepository> resultDecorators = new HashMap<Criterion, ResultDecoratorRepository>();
    private Map<Criterion, ComputedAggregatedUsage> computedAggregatedResult = new HashMap<Criterion, ComputedAggregatedUsage>();

    public void addResult(Objective o, IAnalysisResult result) {
        ConfidenceInterval ci = this.getConfidenceIntervalFromResult(result, o);
        if (ci != null) {
            this.confidence.put((Criterion)o, ci);
        }
        if (result instanceof IPerformanceAnalysisResult) {
            this.resultDecorators.put((Criterion)o, ((IPerformanceAnalysisResult)result).getResults());
            this.computedAggregatedResult.put((Criterion)o, ((IPerformanceAnalysisResult)result).getComputedAggregatedUsage());
        }
    }

    @Deprecated
    public DSEObjectives() {
    }

    @Inject
    public DSEObjectives(DominationStrategy strategy) {
        super(strategy);
    }

    public Objective get(Value<?> value) {
        return super.get(value);
    }

    public Value<?> getValueForCriterion(Criterion c) {
        if (c instanceof Objective) {
            return this.get((Objective)c);
        }
        if (c instanceof Constraint) {
            return this.getConstraints().get((Criterion)((Constraint)c));
        }
        throw new RuntimeException("A criterion that is neither Objective nor Constraints has been encountered, contact developers. Class: " + c.getClass());
    }

    public void addConfidence(Criterion o, ConfidenceInterval c) {
        this.confidence.put(o, c);
    }

    public Map<Criterion, ConfidenceInterval> getConfidenceIntervals() {
        return this.confidence;
    }

    public ConfidenceInterval getConfidenceIntervalForObjective(Criterion o) {
        return this.confidence.get(o);
    }

    private ConfidenceInterval getConfidenceIntervalFromResult(IAnalysisResult result, Objective o) {
        if (result instanceof IStatisticAnalysisResult) {
            IStatisticAnalysisResult statisticResult = (IStatisticAnalysisResult)result;
            ConfidenceInterval c = statisticResult.getConfidenceInterval((Criterion)o);
            return c;
        }
        return null;
    }

    public void addResultDecoratorFor(Criterion performance, ResultDecoratorRepository resultDecorator) {
        this.resultDecorators.put(performance, resultDecorator);
    }

    public ResultDecoratorRepository getResultDecoratorFor(Criterion o) {
        return this.resultDecorators.get(o);
    }

    public boolean hasResultDecoratorFor(Criterion o) {
        return this.resultDecorators.containsKey(o) && this.resultDecorators.get(o) != null;
    }

    public void addComputedAggregatedUsage(Criterion o, ComputedAggregatedUsage computedAggregatedUsage) {
        this.computedAggregatedResult.put(o, computedAggregatedUsage);
    }

    public ComputedAggregatedUsage getComputedAggregatedUsageFor(Criterion o) {
        return this.computedAggregatedResult.get(o);
    }

    public boolean hasComputedAggregatedUsageFor(Criterion o) {
        return this.computedAggregatedResult.containsKey(o) && this.computedAggregatedResult.get(o) != null;
    }

    public void addValueForCriterion(Criterion criterion, double d) {
        if (criterion instanceof Objective) {
            this.add((Objective)criterion, d);
        } else if (criterion instanceof Constraint) {
            this.getConstraints().add((Criterion)((Constraint)criterion), d);
        } else {
            throw new RuntimeException("A criterion that is neither Objective nor Constraints has been encountered, contact developers. Class: " + criterion.getClass());
        }
    }
}

