/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.dsexplore.opt4j.start;

import de.uka.ipd.sdq.dsexplore.helper.ResultsHandlerController;
import de.uka.ipd.sdq.dsexplore.helper.ResultsWriter;
import de.uka.ipd.sdq.dsexplore.launch.DSEWorkflowConfiguration;
import de.uka.ipd.sdq.dsexplore.opt4j.archive.PopulationTracker;
import de.uka.ipd.sdq.dsexplore.opt4j.start.Opt4JStarter;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.URI;
import org.opt4j.core.Individual;
import org.opt4j.core.optimizer.Optimizer;
import org.opt4j.core.optimizer.OptimizerIterationListener;

public class DSEListener
implements OptimizerIterationListener {
    int iteration = 0;
    private IProgressMonitor monitor;
    private URI resultFolder;
    private boolean asEMF;
    private boolean asCSV;
    private ResultsHandlerController rhc;

    public DSEListener(IProgressMonitor monitor, DSEWorkflowConfiguration dseConfig) {
        this.resultFolder = dseConfig.getResultFolder();
        this.asEMF = dseConfig.isResultsAsEMF();
        this.asCSV = dseConfig.isResultsAsCSV();
        this.monitor = monitor;
        this.rhc = new ResultsHandlerController(Platform.getExtensionRegistry(), dseConfig.getOriginalConfig());
        monitor.beginTask("DSE run", dseConfig.getMaxIterations());
    }

    public void iterationComplete(Optimizer optimizer, int iteration) {
        if (this.monitor.isCanceled()) {
            Opt4JStarter.terminate();
            this.monitor.setTaskName("DSE Run cancelling");
            this.monitor.done();
        } else {
            this.monitor.worked(1);
            this.storeIntermediateResults(iteration - 1);
        }
        this.iteration = iteration;
    }

    private void storeIntermediateResults(int iteration) {
        PopulationTracker individuals = Opt4JStarter.getAllIndividuals();
        ArrayList<Exception> exceptionList = new ArrayList<Exception>();
        ResultsWriter.writeDSEIndividualsToFile(individuals.getIndividuals(), this.resultFolder, "allCandidates", iteration, this.asEMF, this.asCSV, exceptionList);
        ResultsWriter.writeDSEIndividualsToFile(Opt4JStarter.getPopulationIndividuals(), this.resultFolder, "population", iteration, this.asEMF, this.asCSV, exceptionList);
        this.rhc.handleResults(Opt4JStarter.getPopulationIndividuals(), iteration);
        ResultsWriter.writeIndividualsToFile((Collection<Individual>)Opt4JStarter.getArchiveIndividuals(), this.resultFolder, "archiveCandidates", iteration, exceptionList, this.asEMF, this.asCSV);
    }

    public int getIteration() {
        return this.iteration;
    }
}

