/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.dsexplore.analysis;

import de.uka.ipd.sdq.dsexplore.analysis.AnalysisFailedException;
import de.uka.ipd.sdq.dsexplore.analysis.IAnalysis;
import de.uka.ipd.sdq.dsexplore.analysis.IAnalysisResult;
import de.uka.ipd.sdq.dsexplore.analysis.PCMPhenotype;
import de.uka.ipd.sdq.dsexplore.helper.ExtensionHelper;
import de.uka.ipd.sdq.dsexplore.launch.DSEConstantsContainer;
import de.uka.ipd.sdq.dsexplore.launch.DSELaunch;
import de.uka.ipd.sdq.dsexplore.launch.DSEWorkflowConfiguration;
import de.uka.ipd.sdq.workflow.jobs.JobFailedException;
import de.uka.ipd.sdq.workflow.jobs.UserCanceledException;
import de.uka.ipd.sdq.workflow.mdsd.blackboard.MDSDBlackboard;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.opt4j.core.Criterion;

public class AnalysisProxy
implements IAnalysis {
    private DSEWorkflowConfiguration configuration;
    private DSEConstantsContainer.QualityAttribute qualityAttribute;
    IAnalysis ana = null;
    private DSELaunch dseLaunch;
    private String methodName;
    private MDSDBlackboard blackboard;
    private static Logger logger = Logger.getLogger((String)"de.uka.ipd.sdq.dsexplore.analysis.AnalysisProxy");

    public AnalysisProxy(DSEWorkflowConfiguration configuration, DSEConstantsContainer.QualityAttribute qualityAttribute, DSELaunch dseLaunch, String methodName) {
        this.initialise(configuration);
        this.qualityAttribute = qualityAttribute;
        this.dseLaunch = dseLaunch;
        this.methodName = methodName;
    }

    @Override
    public void analyse(PCMPhenotype pheno, IProgressMonitor monitor) throws CoreException, UserCanceledException, AnalysisFailedException, JobFailedException {
        IAnalysis ana = this.getDecoratedAnalysis();
        logger.debug((Object)("Starting analysis of " + this.qualityAttribute.getPrettyName()));
        ana.analyse(pheno, monitor);
        logger.debug((Object)("Finished analysis of " + this.qualityAttribute.getPrettyName()));
        this.dseLaunch.resetLoggers();
    }

    private IAnalysis getDecoratedAnalysis() throws CoreException {
        if (this.ana == null) {
            this.ana = this.loadDecoratedAnalysis();
            this.ana.setBlackboard(this.blackboard);
            this.ana.initialise(this.configuration);
        }
        return this.ana;
    }

    private IAnalysis loadDecoratedAnalysis() throws CoreException {
        IExtension[] extensions;
        IExtension[] iExtensionArray = extensions = ExtensionHelper.loadAnalysisExtensions();
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement[] elements;
            IExtension ext = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = elements = ext.getConfigurationElements();
            int n3 = elements.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement element = iConfigurationElementArray[n4];
                if (element.getName().equals("analysis") && element.getAttribute("name").equals(this.methodName)) {
                    this.ana = (IAnalysis)ExtensionHelper.loadExecutableAttribute(element, "delegate");
                    return this.ana;
                }
                ++n4;
            }
            ++n2;
        }
        throw new CoreException((IStatus)new Status(4, "de.uka.ipd.sdq.dsexplore", "Cannot load analysis extension for " + this.methodName));
    }

    @Override
    public void initialise(DSEWorkflowConfiguration configuration) {
        this.configuration = configuration;
    }

    @Override
    public DSEConstantsContainer.QualityAttribute getQualityAttribute() throws CoreException {
        return this.getDecoratedAnalysis().getQualityAttribute();
    }

    @Override
    public boolean hasStatisticResultsFor() throws CoreException {
        return this.getDecoratedAnalysis().hasStatisticResultsFor();
    }

    @Override
    public List<Criterion> getCriterions() throws CoreException {
        return this.getDecoratedAnalysis().getCriterions();
    }

    @Override
    public IAnalysisResult retrieveResultsFor(PCMPhenotype pheno, Criterion criterion) throws CoreException, AnalysisFailedException {
        return this.getDecoratedAnalysis().retrieveResultsFor(pheno, criterion);
    }

    @Override
    public boolean hasObjectivePerUsageScenario() throws CoreException {
        if (this.ana != null) {
            this.ana = this.loadDecoratedAnalysis();
        }
        return this.ana.hasObjectivePerUsageScenario();
    }

    @Override
    public void setBlackboard(MDSDBlackboard blackboard) {
        this.blackboard = blackboard;
    }
}

