/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.dsexplore.helper;

import java.io.FileWriter;
import java.io.IOException;
import java.net.URL;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.emf.common.util.URI;

class DSEFileWriter {
    private FileWriter fileWriter;

    public DSEFileWriter(URI fileURL) throws IOException {
        String fileName = DSEFileWriter.getFilenameFor(fileURL);
        this.fileWriter = new FileWriter(fileName);
    }

    public static String getFilenameFor(URI fileURL) {
        String fileName = "";
        if (fileURL.isPlatform()) {
            try {
                URL solvedURL = FileLocator.resolve((URL)new URL(fileURL.toString()));
                fileName = solvedURL.getPath();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (fileURL.isFile()) {
            fileName = fileURL.toFileString();
        } else {
            Logger logger = Logger.getLogger((String)"de.uka.ipd.sdq.dsexplore.helper.DSEFileWriter");
            logger.warn((Object)("trying to write to or read from file with " + fileURL + " but this is neither a file URI not a platform URI. I will try anyway."));
            fileName = fileURL.toString();
        }
        return fileName;
    }

    public void write(String string) throws IOException {
        this.fileWriter.write(string);
    }

    public void close() throws IOException {
        this.fileWriter.close();
    }

    public void flush() throws IOException {
        this.fileWriter.flush();
    }
}

