/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.dsexplore.helper;

import de.uka.ipd.sdq.dsexplore.analysis.IAnalysisQualityAttributeDeclaration;
import de.uka.ipd.sdq.dsexplore.launch.DSEConstantsContainer;
import de.uka.ipd.sdq.dsexplore.qml.contracttype.QMLContractType.Dimension;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.Platform;

public class ExtensionHelper {
    private static Logger logger = Logger.getLogger((String)"de.uka.ipd.sdq.dsexplore");

    public static Collection<Object> loadExtension(String id) throws CoreException {
        IConfigurationElement[] ep = Platform.getExtensionRegistry().getConfigurationElementsFor(id);
        Vector<Object> result = null;
        if (ep.length == 0) {
            logger.error((Object)("Error: No Extension " + id + " found"));
        } else {
            result = new Vector<Object>();
            int i = 0;
            while (i < ep.length) {
                result.add(ep[i].createExecutableExtension("delegate"));
                ++i;
            }
        }
        return result;
    }

    public static IExtension[] loadAnalysisExtensions() {
        return Platform.getExtensionRegistry().getExtensionPoint("de.uka.ipd.sdq.dsexplore.analysis").getExtensions();
    }

    public static String loadStringAttribute(IExtension extension, String configurationElement, String attributeName) {
        IConfigurationElement[] elements;
        IConfigurationElement[] iConfigurationElementArray = elements = extension.getConfigurationElements();
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            if (element.getName().equals(configurationElement)) {
                String attribute = element.getAttribute(attributeName);
                return attribute;
            }
            ++n2;
        }
        return null;
    }

    public static Object loadExecutableAttribute(IConfigurationElement element, String attributeName) throws CoreException {
        return element.createExecutableExtension(attributeName);
    }

    public static List<IExtension> loadAnalysisExtensions(DSEConstantsContainer.QualityAttribute attribute) {
        IExtension[] exts = Platform.getExtensionRegistry().getExtensionPoint("de.uka.ipd.sdq.dsexplore.analysis").getExtensions();
        ArrayList<IExtension> results = new ArrayList<IExtension>();
        IExtension[] iExtensionArray = exts;
        int n = exts.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension iExtension = iExtensionArray[n2];
            DSEConstantsContainer.QualityAttribute supportedQA = ExtensionHelper.loadSupportedQualityAttributes(iExtension);
            if (supportedQA == attribute) {
                results.add(iExtension);
            }
            ++n2;
        }
        return results;
    }

    private static DSEConstantsContainer.QualityAttribute loadSupportedQualityAttributes(IExtension extension) {
        IConfigurationElement[] elements;
        IConfigurationElement[] iConfigurationElementArray = elements = extension.getConfigurationElements();
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            if (element.getName().equals("analysis")) {
                return DSEConstantsContainer.QualityAttribute.getQualityAttribute(element.getAttribute("qualityAttribute"));
            }
            ++n2;
        }
        return null;
    }

    public static List<IExtension> loadAnalysisExtensions(String dimensionId) {
        IExtension[] exts = Platform.getExtensionRegistry().getExtensionPoint("de.uka.ipd.sdq.dsexplore.analysis").getExtensions();
        ArrayList<IExtension> results = new ArrayList<IExtension>();
        IExtension[] iExtensionArray = exts;
        int n = exts.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            List<Dimension> dimensions = ExtensionHelper.loadQualityAttributeDimension(extension);
            for (Dimension dimension : dimensions) {
                if (!dimensionId.equals(dimension.getId())) continue;
                results.add(extension);
                break;
            }
            ++n2;
        }
        return results;
    }

    private static List<Dimension> loadQualityAttributeDimension(IExtension extension) {
        IConfigurationElement[] elements;
        IConfigurationElement[] iConfigurationElementArray = elements = extension.getConfigurationElements();
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            if (element.getName().equals("analysis")) {
                try {
                    IAnalysisQualityAttributeDeclaration attribute = (IAnalysisQualityAttributeDeclaration)element.createExecutableExtension("qualityAttributeHandler");
                    return attribute.getDimensions();
                }
                catch (CoreException e) {
                    logger.error((Object)"Error when querying analysis extension:");
                    e.printStackTrace();
                    return null;
                }
            }
            ++n2;
        }
        return null;
    }
}

