/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.dsexplore.helper;

import de.uka.ipd.sdq.dsexplore.opt4j.representation.DSEIndividual;
import de.uka.ipd.sdq.dsexplore.opt4j.representation.DSEObjectives;
import de.uka.ipd.sdq.dsexplore.opt4j.representation.NonListenableIndividual;
import de.uka.ipd.sdq.pcm.designdecision.DecisionSpace;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.opt4j.core.Individual;
import org.opt4j.core.Objective;
import org.opt4j.core.Value;
import org.opt4j.core.domination.DominationStrategy;
import org.opt4j.core.domination.ParetoDomination;

public class FilterParetoOptimalIndividuals {
    public static void main(String[] args) throws CoreException {
        if (args.length < 2) {
            System.out.println("You need to specify the number of columns to be read and compared as first argument and the cvs file(s) as second and optional further arguments");
        }
        int noColumns = Integer.parseInt(args[0]);
        ArrayList allIndividuals = new ArrayList();
        ArrayList<Object> files = new ArrayList<Object>();
        int i = 1;
        while (i < args.length) {
            String filename = args[i];
            File file = new File(filename);
            files.add(file);
            System.out.println("Input: " + file.getAbsolutePath());
            List<DSEIndividual> values = FilterParetoOptimalIndividuals.readInDoubles(file, noColumns);
            List<DSEIndividual> optimal = FilterParetoOptimalIndividuals.filterPareto(values);
            FilterParetoOptimalIndividuals.writeResults("results", file, optimal);
            ++i;
        }
        ArrayList overallList = new ArrayList();
        for (List list : allIndividuals) {
            overallList.addAll(list);
        }
        List overallOptimal = FilterParetoOptimalIndividuals.filterPareto(overallList);
        for (List list : allIndividuals) {
            ArrayList<DSEIndividual> toBeRemoved = new ArrayList<DSEIndividual>();
            for (DSEIndividual individual : list) {
                if (overallOptimal.contains((Object)individual)) continue;
                toBeRemoved.add(individual);
            }
            list.removeAll(toBeRemoved);
            System.out.println("Input: " + ((File)files.get(allIndividuals.indexOf(list))).getAbsolutePath());
            FilterParetoOptimalIndividuals.writeResults("resultsComparedWithOthers", (File)files.get(allIndividuals.indexOf(list)), list);
        }
    }

    private static void writeResults(String filenamePrefix, File oldFile, List<DSEIndividual> optimalIndividuals) {
        File file = new File(oldFile.getParentFile(), String.valueOf(filenamePrefix) + oldFile.getName());
        try {
            BufferedWriter w = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(file)));
            for (Individual individual : optimalIndividuals) {
                for (Value double1 : individual.getObjectives().getValues()) {
                    w.write(double1.getDouble() + ";");
                }
                w.newLine();
            }
            w.flush();
            w.close();
            System.out.println("Written results to " + file.getAbsolutePath());
        }
        catch (FileNotFoundException e) {
            System.out.println("Writing failed.");
            e.printStackTrace();
        }
        catch (IOException e) {
            System.out.println("Writing failed.");
            e.printStackTrace();
        }
    }

    public static final <AnyIndiv extends Individual> List<AnyIndiv> filterPareto(List<AnyIndiv> individuals) {
        ArrayList<Individual> toBeRemoved = new ArrayList<Individual>(individuals.size());
        ArrayList<AnyIndiv> result = new ArrayList<AnyIndiv>(individuals.size());
        result.addAll(individuals);
        int i = 0;
        while (i < individuals.size()) {
            Individual indiv1 = (Individual)individuals.get(i);
            int j = i + 1;
            while (j < individuals.size()) {
                Individual indiv2 = (Individual)individuals.get(j);
                if (indiv1.getObjectives().dominates(indiv2.getObjectives())) {
                    toBeRemoved.add(indiv2);
                } else if (indiv2.getObjectives().dominates(indiv1.getObjectives())) {
                    toBeRemoved.add(indiv1);
                }
                ++j;
            }
            ++i;
        }
        result.removeAll(toBeRemoved);
        return result;
    }

    private static List<DSEIndividual> readInDoubles(File file, int noColumns) {
        try {
            ArrayList<DSEIndividual> results = new ArrayList<DSEIndividual>();
            BufferedReader in = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
            String[] headLineArray = in.readLine().split(";");
            ArrayList<Objective> objectiveList = new ArrayList<Objective>();
            int i = 0;
            while (i < noColumns) {
                Objective o = new Objective(headLineArray[i]);
                objectiveList.add(o);
                ++i;
            }
            int noOfLine = 1;
            String line = "";
            while ((line = in.readLine()) != null) {
                DSEObjectives lineList = new DSEObjectives((DominationStrategy)new ParetoDomination());
                String[] lineArray = line.split(";");
                if (lineArray.length == 0) continue;
                int i2 = 0;
                while (i2 < noColumns) {
                    try {
                        Double value = Double.parseDouble(lineArray[i2]);
                        lineList.add((Objective)objectiveList.get(i2), value);
                    }
                    catch (NumberFormatException e) {
                        System.out.println("Line " + noOfLine + " column " + i2 + " is no double value, exiting");
                        in.close();
                        throw new Exception(e);
                    }
                    ++i2;
                }
                lineList.array();
                DummyDSECandidate indiv = new DummyDSECandidate(null, "" + noOfLine);
                indiv.setObjectives(lineList);
                indiv.setState(Individual.State.EVALUATED);
                results.add(indiv);
                ++noOfLine;
            }
            in.close();
            return results;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    static class DummyDSECandidate
    extends NonListenableIndividual {
        private String id;

        public DummyDSECandidate(DecisionSpace problem, String id) {
            super(problem);
            this.id = id;
        }

        @Override
        public String getGenotypeString() {
            return this.id;
        }
    }
}

