/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.dsexplore.opt4j.optimizer;

import com.google.inject.Inject;
import de.uka.ipd.sdq.dsexplore.constraints.DesignSpaceConstraintManager;
import de.uka.ipd.sdq.dsexplore.opt4j.genotype.DesignDecisionGenotype;
import de.uka.ipd.sdq.dsexplore.opt4j.optimizer.heuristic.startingPopulation.impl.StartingPopulationHeuristicImpl;
import de.uka.ipd.sdq.dsexplore.opt4j.representation.DSEIndividual;
import de.uka.ipd.sdq.dsexplore.opt4j.start.Opt4JStarter;
import java.util.Collection;
import java.util.Iterator;
import java.util.Optional;
import org.apache.log4j.Logger;
import org.opt4j.core.Genotype;
import org.opt4j.core.Individual;
import org.opt4j.core.IndividualFactory;
import org.opt4j.core.optimizer.Archive;
import org.opt4j.core.optimizer.Control;
import org.opt4j.core.optimizer.IndividualCompleter;
import org.opt4j.core.optimizer.Iteration;
import org.opt4j.core.optimizer.Population;
import org.opt4j.core.optimizer.StopException;
import org.opt4j.core.optimizer.TerminationException;
import org.opt4j.optimizer.ea.EvolutionaryAlgorithm;
import org.opt4j.optimizer.ea.Mating;
import org.opt4j.optimizer.ea.Selector;
import org.opt4j.start.Constant;

public class NoDuplicatesEvolutionaryAlgorithm
extends EvolutionaryAlgorithm {
    private static final int MAX_DUPLICATES = 100;
    private static Logger logger = Logger.getLogger((String)"de.uka.ipd.sdq.dsexplore.opt4j.optimizer.NoDuplicatesEvolutionaryAlgorithm");

    @Inject
    public NoDuplicatesEvolutionaryAlgorithm(Population population, Archive archive, IndividualFactory individualFactory, IndividualCompleter completer, Control control, Selector selector, Mating mating, Iteration generations, @Constant(value="alpha", namespace=EvolutionaryAlgorithm.class) @Constant(value="alpha", namespace=EvolutionaryAlgorithm.class) int alpha, @Constant(value="mu", namespace=EvolutionaryAlgorithm.class) @Constant(value="mu", namespace=EvolutionaryAlgorithm.class) int mu, @Constant(value="lambda", namespace=EvolutionaryAlgorithm.class) @Constant(value="lambda", namespace=EvolutionaryAlgorithm.class) int lambda) {
        super(population, archive, individualFactory, completer, control, selector, mating, generations, alpha, mu, lambda);
    }

    public void optimize() throws TerminationException, StopException {
        boolean usePredefinedPopulation;
        this.selector.init(this.alpha + this.lambda);
        boolean useGeneratedStartingPopulation = Opt4JStarter.getDSEWorkflowConfig().getUseStartingPopulationHeuristic();
        boolean bl = usePredefinedPopulation = Opt4JStarter.getDSEWorkflowConfig().getPredefinedInstancesFileName() != null;
        if (useGeneratedStartingPopulation && !usePredefinedPopulation) {
            DSEIndividual firstIndividual = (DSEIndividual)this.individualFactory.create();
            StartingPopulationHeuristicImpl startingPopulationHelper = new StartingPopulationHeuristicImpl(Opt4JStarter.getDSEWorkflowConfig());
            Collection<DSEIndividual> generatedStartingPopulation = startingPopulationHelper.getStartingPopulation(this.completer, this.individualFactory, firstIndividual);
            this.population.add((Individual)firstIndividual);
            this.population.addAll(generatedStartingPopulation);
        }
        this.removeInvalidIndividualsFrom((Collection<Individual>)this.population);
        int count = 0;
        while (this.population.size() < this.alpha && count < this.alpha + 200) {
            Individual i = this.individualFactory.create();
            if (!this.isValid(i)) continue;
            if (!this.population.contains((Object)i)) {
                this.population.add(i);
            }
            ++count;
        }
        this.nextIteration();
        while (this.iteration.value() < this.iteration.max()) {
            Collection parents = this.selector.getParents(this.mu, (Collection)this.population);
            Collection offspring = this.mating.getOffspring(this.lambda, parents);
            int sizeBefore = offspring.size();
            offspring.removeAll((Collection<?>)this.population);
            Iterator iterator = offspring.iterator();
            while (iterator.hasNext()) {
                Individual individual = (Individual)iterator.next();
                if (individual != null && individual.getGenotype().size() != 0) continue;
                iterator.remove();
                logger.warn((Object)"Encountered a null individual or empty genotype in offspring, removing it.");
            }
            int sizeAfter = offspring.size();
            this.removeInvalidIndividualsFrom(offspring);
            this.population.addAll(offspring);
            if (sizeBefore > sizeAfter) {
                int maximumTries = 100;
                count = sizeAfter;
                int duplicates = 0;
                while (count < sizeBefore && count < maximumTries + sizeAfter && duplicates < 100) {
                    Individual i = this.individualFactory.create();
                    if (!this.isValid(i)) continue;
                    if (!this.population.contains((Object)i)) {
                        this.completer.complete(new Individual[]{i});
                        this.population.add(i);
                        ++count;
                        continue;
                    }
                    ++duplicates;
                }
                if (duplicates == 100) {
                    logger.warn((Object)("Stopped candidate creation after finding " + duplicates + " duplicates."));
                }
            }
            this.completer.complete((Iterable)offspring);
            if (this.population.size() > this.alpha) {
                Collection lames = this.selector.getLames(this.population.size() - this.alpha, (Collection)this.population);
                this.population.removeAll(lames);
            }
            this.nextIteration();
        }
    }

    private boolean isValid(Individual individual) {
        Genotype genotype = individual.getGenotype();
        return genotype instanceof DesignDecisionGenotype ? this.isValid((DesignDecisionGenotype)genotype) : true;
    }

    private boolean isValid(DesignDecisionGenotype genotype) {
        Optional<DesignSpaceConstraintManager> constraintManager = DesignSpaceConstraintManager.getInstanceBy(genotype);
        return constraintManager.isPresent() ? constraintManager.get().violatesNoConstraint(genotype) : true;
    }

    private void removeInvalidIndividualsFrom(Collection<Individual> individuals) {
        individuals.removeIf(eachIndividual -> !this.isValid((Individual)eachIndividual));
    }
}

