/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.dsexplore.opt4j.optimizer.heuristic.operators.impl;

import de.uka.ipd.sdq.dsexplore.helper.EMFHelper;
import de.uka.ipd.sdq.dsexplore.launch.DSEWorkflowConfiguration;
import de.uka.ipd.sdq.dsexplore.opt4j.optimizer.heuristic.operators.AbstractTactic;
import de.uka.ipd.sdq.dsexplore.opt4j.optimizer.heuristic.operators.TacticsResultCandidate;
import de.uka.ipd.sdq.dsexplore.opt4j.representation.DSEIndividual;
import de.uka.ipd.sdq.dsexplore.opt4j.representation.DSEIndividualFactory;
import de.uka.ipd.sdq.pcm.designdecision.Choice;
import de.uka.ipd.sdq.pcm.designdecision.ContinousRangeChoice;
import de.uka.ipd.sdq.pcm.designdecision.DegreeOfFreedomInstance;
import de.uka.ipd.sdq.pcm.designdecision.DiscreteRangeChoice;
import de.uka.ipd.sdq.pcm.designdecision.specific.ContinuousProcessingRateDegree;
import de.uka.ipd.sdq.pcm.designdecision.specific.NumberOfCoresDegree;
import java.util.Collection;
import java.util.Iterator;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EObject;
import org.opt4j.core.Genotype;
import org.opt4j.operator.copy.Copy;
import org.palladiosimulator.analyzer.resultdecorator.resourceenvironmentdecorator.ProcessingResourceSpecificationResult;
import org.palladiosimulator.analyzer.resultdecorator.resourceenvironmentdecorator.UtilisationResult;
import org.palladiosimulator.pcm.resourceenvironment.ProcessingResourceSpecification;

public abstract class AbstractProcessingRateTactic
extends AbstractTactic {
    protected static Logger logger = Logger.getLogger((String)"de.uka.ipd.sdq.opt4j.optimizer.heuristic.operators.impl.ProcessingRateImpl");

    public AbstractProcessingRateTactic(Copy<Genotype> copy, DSEIndividualFactory individualFactory, DSEWorkflowConfiguration configuration, String[] improvesDimensionPath) {
        super(copy, individualFactory, configuration, improvesDimensionPath);
    }

    protected void addNewProcRateCandidate(DSEIndividual individual, Collection<TacticsResultCandidate> candidates, ProcessingResourceSpecificationResult utilisationResultToBeChanged, ProcessingResourceSpecification utilProcessingResourceToBeChanged) {
        TacticsResultCandidate candidate = this.individualFactory.buildCandidate(this.copy.copy((Genotype)individual.getGenotype()), individual);
        boolean hasAppliedChange = false;
        Iterator<Choice> iterator = candidate.getGenotype().iterator();
        while (iterator.hasNext()) {
            ContinuousProcessingRateDegree processingRateDegree;
            Choice choice = iterator.next();
            if (!(choice instanceof ContinousRangeChoice)) continue;
            ContinousRangeChoice continousRangeChoice = (ContinousRangeChoice)choice;
            DegreeOfFreedomInstance DegreeOfFreedomInstance2 = choice.getDegreeOfFreedomInstance();
            if (!(DegreeOfFreedomInstance2 instanceof ContinuousProcessingRateDegree) || !EMFHelper.checkIdentity((processingRateDegree = (ContinuousProcessingRateDegree)DegreeOfFreedomInstance2).getPrimaryChanged(), (EObject)utilProcessingResourceToBeChanged.getResourceContainer_ProcessingResourceSpecification()) || !EMFHelper.checkIdentity((EObject)processingRateDegree.getProcessingresourcetype(), (EObject)utilProcessingResourceToBeChanged.getActiveResourceType_ActiveResourceSpecification())) continue;
            double newProcessingRate = this.getUpdatedProcessingRate(continousRangeChoice, processingRateDegree);
            continousRangeChoice.setChosenValue(newProcessingRate);
            hasAppliedChange = true;
        }
        if (hasAppliedChange) {
            this.finalizeAndAddCandidate(candidates, utilisationResultToBeChanged, candidate);
        } else {
            logger.warn((Object)("Tried to apply Processing Rate Increase / Decrease Tactic, but the resource with the highest / lowest utilisation " + utilProcessingResourceToBeChanged.getActiveResourceType_ActiveResourceSpecification().getEntityName() + " of " + utilProcessingResourceToBeChanged.getResourceContainer_ProcessingResourceSpecification().getEntityName() + " is not in the degrees of freedom."));
        }
    }

    private void finalizeAndAddCandidate(Collection<TacticsResultCandidate> candidates, ProcessingResourceSpecificationResult utilisationResultToBeChanged, TacticsResultCandidate candidate) {
        candidate.setCandidateWeight(this.getCandidateWeight((UtilisationResult)utilisationResultToBeChanged));
        candidate.setHeuristic(this);
        candidates.add(candidate);
        this.increaseCounterOfGeneratedCandidates();
    }

    protected void addNewNumberOfCoresCandidate(DSEIndividual individual, Collection<TacticsResultCandidate> candidates, ProcessingResourceSpecificationResult maxUtilisationResult, ProcessingResourceSpecification maxUtilProcessingResource) {
        TacticsResultCandidate candidate = this.individualFactory.buildCandidate(this.copy.copy((Genotype)individual.getGenotype()), individual);
        Iterator<Choice> iterator = candidate.getGenotype().iterator();
        while (iterator.hasNext()) {
            int newNumberOfCores;
            Choice choice = iterator.next();
            if (!(choice instanceof DiscreteRangeChoice) || !(choice.getDegreeOfFreedomInstance() instanceof NumberOfCoresDegree)) continue;
            DiscreteRangeChoice discreteChoice = (DiscreteRangeChoice)choice;
            NumberOfCoresDegree numberOfCoresDegree = (NumberOfCoresDegree)choice.getDegreeOfFreedomInstance();
            if (!EMFHelper.checkIdentity((EObject)numberOfCoresDegree.getProcessingresourcetype(), (EObject)maxUtilProcessingResource.getActiveResourceType_ActiveResourceSpecification()) || !EMFHelper.checkIdentity(numberOfCoresDegree.getPrimaryChanged(), (EObject)maxUtilProcessingResource.getResourceContainer_ProcessingResourceSpecification()) || (newNumberOfCores = this.getUpdatedNumberOfCores(discreteChoice, numberOfCoresDegree)) == discreteChoice.getChosenValue()) continue;
            this.finalizeAndAddCandidate(candidates, maxUtilisationResult, candidate);
            break;
        }
    }

    protected abstract double getCandidateWeight(UtilisationResult var1);

    protected abstract double getUpdatedProcessingRate(ContinousRangeChoice var1, ContinuousProcessingRateDegree var2);

    protected abstract int getUpdatedNumberOfCores(DiscreteRangeChoice var1, NumberOfCoresDegree var2);
}

