/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package de.uka.ipd.sdq.pcm.cost.provider;

import java.util.ArrayList;
import java.util.Collection;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;

import de.uka.ipd.sdq.pcm.cost.util.costAdapterFactory;

/**
 * This is the factory that is used to provide the interfaces needed to support Viewers. The
 * adapters generated by this factory convert EMF adapter notifications into calls to
 * {@link #fireNotifyChanged fireNotifyChanged}. The adapters also support Eclipse property sheets.
 * Note that most of the adapters are shared among multiple instances. <!-- begin-user-doc --> <!--
 * end-user-doc -->
 *
 * @generated
 */
public class costItemProviderAdapterFactory extends costAdapterFactory implements ComposeableAdapterFactory,
        IChangeNotifier, IDisposable {
    /**
     * This keeps track of the root adapter factory that delegates to this adapter factory. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected ComposedAdapterFactory parentAdapterFactory;

    /**
     * This is used to implement {@link org.eclipse.emf.edit.provider.IChangeNotifier}. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected IChangeNotifier changeNotifier = new ChangeNotifier();

    /**
     * This keeps track of all the supported types checked by {@link #isFactoryForType
     * isFactoryForType}. <!-- begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected Collection<Object> supportedTypes = new ArrayList<Object>();

    /**
     * This constructs an instance. <!-- begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    public costItemProviderAdapterFactory() {
        this.supportedTypes.add(IEditingDomainItemProvider.class);
        this.supportedTypes.add(IStructuredItemContentProvider.class);
        this.supportedTypes.add(ITreeItemContentProvider.class);
        this.supportedTypes.add(IItemLabelProvider.class);
        this.supportedTypes.add(IItemPropertySource.class);
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link de.uka.ipd.sdq.pcm.cost.ComponentCost} instances. <!-- begin-user-doc --> <!--
     * end-user-doc -->
     *
     * @generated
     */
    protected ComponentCostItemProvider componentCostItemProvider;

    /**
     * This creates an adapter for a {@link de.uka.ipd.sdq.pcm.cost.ComponentCost}. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createComponentCostAdapter() {
        if (this.componentCostItemProvider == null)
        {
            this.componentCostItemProvider = new ComponentCostItemProvider(this);
        }

        return this.componentCostItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link de.uka.ipd.sdq.pcm.cost.FixedLinkingResourceCost} instances. <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     *
     * @generated
     */
    protected FixedLinkingResourceCostItemProvider fixedLinkingResourceCostItemProvider;

    /**
     * This creates an adapter for a {@link de.uka.ipd.sdq.pcm.cost.FixedLinkingResourceCost}. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createFixedLinkingResourceCostAdapter() {
        if (this.fixedLinkingResourceCostItemProvider == null)
        {
            this.fixedLinkingResourceCostItemProvider = new FixedLinkingResourceCostItemProvider(this);
        }

        return this.fixedLinkingResourceCostItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link de.uka.ipd.sdq.pcm.cost.FixedProcessingResourceCost} instances. <!-- begin-user-doc
     * --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected FixedProcessingResourceCostItemProvider fixedProcessingResourceCostItemProvider;

    /**
     * This creates an adapter for a {@link de.uka.ipd.sdq.pcm.cost.FixedProcessingResourceCost}.
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createFixedProcessingResourceCostAdapter() {
        if (this.fixedProcessingResourceCostItemProvider == null)
        {
            this.fixedProcessingResourceCostItemProvider = new FixedProcessingResourceCostItemProvider(this);
        }

        return this.fixedProcessingResourceCostItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link de.uka.ipd.sdq.pcm.cost.VariableLinkingResourceCost} instances. <!-- begin-user-doc
     * --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected VariableLinkingResourceCostItemProvider variableLinkingResourceCostItemProvider;

    /**
     * This creates an adapter for a {@link de.uka.ipd.sdq.pcm.cost.VariableLinkingResourceCost}.
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createVariableLinkingResourceCostAdapter() {
        if (this.variableLinkingResourceCostItemProvider == null)
        {
            this.variableLinkingResourceCostItemProvider = new VariableLinkingResourceCostItemProvider(this);
        }

        return this.variableLinkingResourceCostItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link de.uka.ipd.sdq.pcm.cost.VariableProcessingResourceCost} instances. <!-- begin-user-doc
     * --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected VariableProcessingResourceCostItemProvider variableProcessingResourceCostItemProvider;

    /**
     * This creates an adapter for a {@link de.uka.ipd.sdq.pcm.cost.VariableProcessingResourceCost}.
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createVariableProcessingResourceCostAdapter() {
        if (this.variableProcessingResourceCostItemProvider == null)
        {
            this.variableProcessingResourceCostItemProvider = new VariableProcessingResourceCostItemProvider(this);
        }

        return this.variableProcessingResourceCostItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link de.uka.ipd.sdq.pcm.cost.ScalarFunction} instances. <!-- begin-user-doc --> <!--
     * end-user-doc -->
     *
     * @generated
     */
    protected ScalarFunctionItemProvider scalarFunctionItemProvider;

    /**
     * This creates an adapter for a {@link de.uka.ipd.sdq.pcm.cost.ScalarFunction}. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createScalarFunctionAdapter() {
        if (this.scalarFunctionItemProvider == null)
        {
            this.scalarFunctionItemProvider = new ScalarFunctionItemProvider(this);
        }

        return this.scalarFunctionItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link de.uka.ipd.sdq.pcm.cost.CostRepository} instances. <!-- begin-user-doc --> <!--
     * end-user-doc -->
     *
     * @generated
     */
    protected CostRepositoryItemProvider costRepositoryItemProvider;

    /**
     * This creates an adapter for a {@link de.uka.ipd.sdq.pcm.cost.CostRepository}. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createCostRepositoryAdapter() {
        if (this.costRepositoryItemProvider == null)
        {
            this.costRepositoryItemProvider = new CostRepositoryItemProvider(this);
        }

        return this.costRepositoryItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link de.uka.ipd.sdq.pcm.cost.ComponentCostPerInstance} instances. <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     *
     * @generated
     */
    protected ComponentCostPerInstanceItemProvider componentCostPerInstanceItemProvider;

    /**
     * This creates an adapter for a {@link de.uka.ipd.sdq.pcm.cost.ComponentCostPerInstance}. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createComponentCostPerInstanceAdapter() {
        if (this.componentCostPerInstanceItemProvider == null)
        {
            this.componentCostPerInstanceItemProvider = new ComponentCostPerInstanceItemProvider(this);
        }

        return this.componentCostPerInstanceItemProvider;
    }

    /**
     * This returns the root adapter factory that contains this factory. <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public ComposeableAdapterFactory getRootAdapterFactory() {
        return this.parentAdapterFactory == null ? this : this.parentAdapterFactory.getRootAdapterFactory();
    }

    /**
     * This sets the composed adapter factory that contains this factory. <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public void setParentAdapterFactory(final ComposedAdapterFactory parentAdapterFactory) {
        this.parentAdapterFactory = parentAdapterFactory;
    }

    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public boolean isFactoryForType(final Object type) {
        return this.supportedTypes.contains(type) || super.isFactoryForType(type);
    }

    /**
     * This implementation substitutes the factory itself as the key for the adapter. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter adapt(final Notifier notifier, final Object type) {
        return super.adapt(notifier, this);
    }

    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Object adapt(final Object object, final Object type) {
        if (this.isFactoryForType(type))
        {
            final Object adapter = super.adapt(object, type);
            if (!(type instanceof Class<?>) || (((Class<?>) type).isInstance(adapter)))
            {
                return adapter;
            }
        }

        return null;
    }

    /**
     * This adds a listener. <!-- begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public void addListener(final INotifyChangedListener notifyChangedListener) {
        this.changeNotifier.addListener(notifyChangedListener);
    }

    /**
     * This removes a listener. <!-- begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public void removeListener(final INotifyChangedListener notifyChangedListener) {
        this.changeNotifier.removeListener(notifyChangedListener);
    }

    /**
     * This delegates to {@link #changeNotifier} and to {@link #parentAdapterFactory}. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public void fireNotifyChanged(final Notification notification) {
        this.changeNotifier.fireNotifyChanged(notification);

        if (this.parentAdapterFactory != null)
        {
            this.parentAdapterFactory.fireNotifyChanged(notification);
        }
    }

    /**
     * This disposes all of the item providers created by this factory. <!-- begin-user-doc --> <!--
     * end-user-doc -->
     *
     * @generated
     */
    @Override
    public void dispose() {
        if (this.componentCostItemProvider != null) {
            this.componentCostItemProvider.dispose();
        }
        if (this.fixedLinkingResourceCostItemProvider != null) {
            this.fixedLinkingResourceCostItemProvider.dispose();
        }
        if (this.fixedProcessingResourceCostItemProvider != null) {
            this.fixedProcessingResourceCostItemProvider.dispose();
        }
        if (this.variableLinkingResourceCostItemProvider != null) {
            this.variableLinkingResourceCostItemProvider.dispose();
        }
        if (this.variableProcessingResourceCostItemProvider != null) {
            this.variableProcessingResourceCostItemProvider.dispose();
        }
        if (this.scalarFunctionItemProvider != null) {
            this.scalarFunctionItemProvider.dispose();
        }
        if (this.costRepositoryItemProvider != null) {
            this.costRepositoryItemProvider.dispose();
        }
        if (this.componentCostPerInstanceItemProvider != null) {
            this.componentCostPerInstanceItemProvider.dispose();
        }
    }

}
