/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.tcfmoop.terminationcriteria;

import de.uka.ipd.sdq.tcfmoop.config.IConfiguration;
import de.uka.ipd.sdq.tcfmoop.config.ParetoOptimalSetStabilityConfig;
import de.uka.ipd.sdq.tcfmoop.outputtree.Node;
import de.uka.ipd.sdq.tcfmoop.terminationcriteria.AbstractTerminationCriterion;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.opt4j.core.Individual;
import org.opt4j.core.optimizer.Archive;
import org.opt4j.core.optimizer.Population;

public class ParetoOptimalSetStabilityCriterion
extends AbstractTerminationCriterion {
    private ParetoOptimalSetStabilityConfig.EvaluationMode mode;
    private int minimumSurvivors;
    private Double minimumSurvivorsInPercentage;
    private int minimumIterationsToSurvive;
    private Map<Individual, IndividualStatistics> survivalsCounter;
    private int numberOfIndividualsThatHasRemainedOptimalTheLongest;
    private int currentlyReachedMaxNumberOfIterations;
    private Node evaluationModeNode;
    private Node survivedGenerationsNode;
    private Node survivorsNode;

    public ParetoOptimalSetStabilityCriterion(IConfiguration conf, Population population, Archive archive) {
        super(conf, population, archive);
        if (conf instanceof ParetoOptimalSetStabilityConfig && conf.validateConfiguration()) {
            this.minimumIterationsToSurvive = ((ParetoOptimalSetStabilityConfig)conf).getMinimumIterationsToSurvive();
            this.mode = ((ParetoOptimalSetStabilityConfig)conf).getEvaluationMode();
            if (this.mode == ParetoOptimalSetStabilityConfig.EvaluationMode.EXACT_NUMBER) {
                this.minimumSurvivors = ((ParetoOptimalSetStabilityConfig)conf).getMinimumSurvivors();
            } else {
                this.minimumSurvivorsInPercentage = ((ParetoOptimalSetStabilityConfig)conf).getMinimumSurvivorsInPercentage();
            }
        } else {
            throw new RuntimeException("ParetoOptimalSetStabilityCriterion.initialize: wrong or invalid configuration object");
        }
        this.survivalsCounter = new HashMap<Individual, IndividualStatistics>();
        this.initializeOutputTree(archive);
    }

    private void initializeOutputTree(Archive archive) {
        this.outputInformation.updateValue("Pareto Optimal Set Stability");
        this.outputInformation.getChildren().clear();
        this.evaluationModeNode = this.outputInformation.addChild("Evaluation Mode: " + this.mode.name(), Node.NodeType.PARAMETER);
        this.survivedGenerationsNode = this.outputInformation.addChild("Survived Generations: " + this.currentlyReachedMaxNumberOfIterations + "/" + this.minimumIterationsToSurvive, Node.NodeType.PARAMETER);
        this.survivorsNode = this.mode == ParetoOptimalSetStabilityConfig.EvaluationMode.EXACT_NUMBER ? this.outputInformation.addChild("Survivors: " + this.numberOfIndividualsThatHasRemainedOptimalTheLongest + "/" + this.minimumSurvivors, Node.NodeType.PARAMETER) : this.outputInformation.addChild("Survivors: " + (double)this.numberOfIndividualsThatHasRemainedOptimalTheLongest / (double)archive.size() * 100.0 + "%/" + this.minimumSurvivorsInPercentage * 100.0 + "%", Node.NodeType.PARAMETER);
        this.outputInformation.getChildren().add(this.suggestedStop);
    }

    @Override
    public void evaluateImpl(int iteration, long currentTime) {
        for (Individual indi : this.archive) {
            if (this.survivalsCounter.containsKey(indi)) {
                this.survivalsCounter.get(indi).renewSurvivalStatus(iteration);
                continue;
            }
            this.survivalsCounter.put(indi, new IndividualStatistics(iteration));
        }
        LinkedList<Individual> individualsToRemove = new LinkedList<Individual>();
        for (Map.Entry<Individual, IndividualStatistics> mapEntry : this.survivalsCounter.entrySet()) {
            if (mapEntry.getValue().hasSurvived(iteration)) continue;
            individualsToRemove.add(mapEntry.getKey());
        }
        for (Individual i : individualsToRemove) {
            this.survivalsCounter.remove(i);
        }
        this.currentlyReachedMaxNumberOfIterations = 0;
        this.numberOfIndividualsThatHasRemainedOptimalTheLongest = 0;
        for (IndividualStatistics iStat : this.survivalsCounter.values()) {
            if (this.currentlyReachedMaxNumberOfIterations == this.minimumIterationsToSurvive) {
                if (iStat.getNumberOfSurvivedGenerations() < this.minimumIterationsToSurvive) continue;
                ++this.numberOfIndividualsThatHasRemainedOptimalTheLongest;
                continue;
            }
            if (iStat.getNumberOfSurvivedGenerations() > this.currentlyReachedMaxNumberOfIterations) {
                this.numberOfIndividualsThatHasRemainedOptimalTheLongest = 1;
                this.currentlyReachedMaxNumberOfIterations = iStat.getNumberOfSurvivedGenerations();
                if (this.currentlyReachedMaxNumberOfIterations <= this.minimumIterationsToSurvive) continue;
                this.currentlyReachedMaxNumberOfIterations = this.minimumIterationsToSurvive;
                continue;
            }
            if (iStat.getNumberOfSurvivedGenerations() != this.currentlyReachedMaxNumberOfIterations) continue;
            ++this.numberOfIndividualsThatHasRemainedOptimalTheLongest;
        }
        this.evaluationResult = this.currentlyReachedMaxNumberOfIterations == this.minimumIterationsToSurvive && (this.mode == ParetoOptimalSetStabilityConfig.EvaluationMode.EXACT_NUMBER && this.numberOfIndividualsThatHasRemainedOptimalTheLongest >= this.minimumSurvivors || this.mode == ParetoOptimalSetStabilityConfig.EvaluationMode.PERCENTAGE && (double)this.numberOfIndividualsThatHasRemainedOptimalTheLongest / (double)this.archive.size() >= this.minimumSurvivorsInPercentage);
    }

    @Override
    public void updateOutputInformation() {
        this.survivedGenerationsNode.updateValue("Survived Generations: " + this.currentlyReachedMaxNumberOfIterations + "/" + this.minimumIterationsToSurvive);
        if (this.mode == ParetoOptimalSetStabilityConfig.EvaluationMode.EXACT_NUMBER) {
            this.survivorsNode.updateValue("Survivors: " + this.numberOfIndividualsThatHasRemainedOptimalTheLongest + "/" + this.minimumSurvivors);
        } else {
            this.survivorsNode.updateValue("Survivors: " + (double)this.numberOfIndividualsThatHasRemainedOptimalTheLongest / (double)this.archive.size() * 100.0 + "%/" + this.minimumSurvivorsInPercentage * 100.0 + "%");
        }
    }

    private class IndividualStatistics {
        private int survivedGenerations = 1;
        private int lastUpdated;

        public IndividualStatistics(int generationNumber) {
            this.lastUpdated = generationNumber;
        }

        public void renewSurvivalStatus(int generationNumber) {
            ++this.survivedGenerations;
            this.lastUpdated = generationNumber;
        }

        public boolean hasSurvived(int iterationNumber) {
            return this.lastUpdated >= iterationNumber;
        }

        public int getNumberOfSurvivedGenerations() {
            return this.survivedGenerations;
        }
    }
}

