/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.tcfmoop.config;

import de.uka.ipd.sdq.tcfmoop.config.AbstractConfiguration;
import de.uka.ipd.sdq.tcfmoop.config.TerminationCriteriaNames;
import de.uka.ipd.sdq.tcfmoop.config.exceptions.InvalidConfigException;

public class InsignificantParetoFrontChangeConfig
extends AbstractConfiguration {
    private Double percentageDifference;
    private Integer pastInterationNumber;

    public InsignificantParetoFrontChangeConfig() {
        super(TerminationCriteriaNames.INSIGNIFICANT_PARETO_FRONT_CHANGE);
    }

    @Override
    public boolean validateConfiguration() {
        return this.getTerminationCriterionName() == TerminationCriteriaNames.INSIGNIFICANT_PARETO_FRONT_CHANGE && this.percentageDifference != null && this.pastInterationNumber != null;
    }

    public void setMinimumAllowedDifference(double percentages) throws InvalidConfigException {
        if (percentages < 0.0 || percentages > 1.0) {
            throw new InvalidConfigException("InsignificantParetoFrontChangeConfig.setDifference: the supplied parameter should be in range 0 - 1");
        }
        this.percentageDifference = percentages;
    }

    public double getMinimumAllowedDifference() {
        return this.percentageDifference;
    }

    public void setPastIterationNumber(int pastInterationNumber) throws InvalidConfigException {
        if (pastInterationNumber < 1) {
            throw new InvalidConfigException("InsignificantParetoFrontChangeConfig.setDifference: the supplied parameter should be >= 1");
        }
        this.pastInterationNumber = pastInterationNumber;
    }

    public int getPastIterationNumber() {
        return this.pastInterationNumber;
    }
}

