/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.tcfmoop.terminationcriteria;

import de.uka.ipd.sdq.tcfmoop.config.IConfiguration;
import de.uka.ipd.sdq.tcfmoop.config.TerminationCriteriaNames;
import de.uka.ipd.sdq.tcfmoop.outputtree.Node;
import de.uka.ipd.sdq.tcfmoop.outputtree.Tree;
import de.uka.ipd.sdq.tcfmoop.terminationcriteria.ITerminationCriterion;
import org.opt4j.core.optimizer.Archive;
import org.opt4j.core.optimizer.Population;

public abstract class AbstractTerminationCriterion
implements ITerminationCriterion {
    protected boolean evaluationResult = false;
    protected Tree outputInformation;
    protected Population population;
    protected Archive archive;
    protected TerminationCriteriaNames name;
    private int stopSuggestedIn = -1;
    protected Node suggestedStop;
    protected boolean outputNeedsUpdate = false;

    protected AbstractTerminationCriterion(IConfiguration conf, Population population, Archive archive) {
        this.archive = archive;
        this.population = population;
        this.name = conf.getTerminationCriterionName();
        this.outputInformation = new Tree("Abstract Termination Criterion", Node.NodeType.TERMINATION_CRITERIA);
        this.suggestedStop = this.outputInformation.addChild("Termination suggested: " + this.evaluationResult + "; During: " + this.stopSuggestedIn, Node.NodeType.PARAMETER);
        this.outputNeedsUpdate = true;
    }

    @Override
    public final boolean getEvaluationResult() {
        return this.evaluationResult;
    }

    @Override
    public final void evaluate(int iteration, long currentTime) {
        if (!this.evaluationResult) {
            this.evaluateImpl(iteration, currentTime);
            if (this.evaluationResult) {
                this.stopSuggestedIn = iteration;
            }
            this.outputNeedsUpdate = true;
        }
    }

    protected abstract void evaluateImpl(int var1, long var2);

    @Override
    public TerminationCriteriaNames getName() {
        return this.name;
    }

    @Override
    public final Tree getOutputInformation() {
        if (this.outputNeedsUpdate) {
            this.outputNeedsUpdate = false;
            this.updateOutputInformation();
            this.suggestedStop.updateValue("Termination suggested: " + this.evaluationResult + "; During: " + this.stopSuggestedIn);
        }
        return this.outputInformation;
    }

    public abstract void updateOutputInformation();
}

