/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.tcfmoop.views;

import de.uka.ipd.sdq.tcfmoop.Activator;
import de.uka.ipd.sdq.tcfmoop.outputtree.Node;
import de.uka.ipd.sdq.tcfmoop.outputtree.Tree;
import de.uka.ipd.sdq.tcfmoop.tcmanager.IOptimizationTerminatedListener;
import de.uka.ipd.sdq.tcfmoop.tcmanager.IOutputChangedListener;
import de.uka.ipd.sdq.tcfmoop.tcmanager.IRequestManualTerminationListener;
import de.uka.ipd.sdq.tcfmoop.tcmanager.IRequestManualTerminationProvider;
import de.uka.ipd.sdq.tcfmoop.tcmanager.ITerminationCriteriaManager;
import de.uka.ipd.sdq.tcfmoop.tcmanager.ITerminationCriteriaManagerInitializedListener;
import de.uka.ipd.sdq.tcfmoop.tcmanager.TerminationCriteriaManager;
import de.uka.ipd.sdq.tcfmoop.views.TerminationCriteriaViewContentProvider;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

public class TerminationCriteriaView
extends ViewPart
implements IOutputChangedListener,
ITerminationCriteriaManagerInitializedListener,
IOptimizationTerminatedListener,
IRequestManualTerminationProvider {
    public static final String ID = "de.uka.ipd.sdq.tcfmoop.views.TerminationCriteriaView";
    public Tree terminationCriteriaManagerOutput;
    private List<IRequestManualTerminationListener> requestManualTerminationListeners = new ArrayList<IRequestManualTerminationListener>();
    private TreeViewer viewer;
    private Action requestTerminationAction;
    private Action expandAllaction;
    private Action colapseAllAction;
    private Action copyAllAction;
    private Action doubleClickAction;
    private Map<ImageDescriptor, Image> imageCache = new HashMap<ImageDescriptor, Image>(11);

    public TerminationCriteriaView() {
        TerminationCriteriaManager.addTerminationCriteriaManagerInitializedListener(this);
    }

    public void createPartControl(Composite parent) {
        this.viewer = new TreeViewer(parent, 770);
        this.viewer.setContentProvider((IContentProvider)new TerminationCriteriaViewContentProvider(this));
        this.viewer.setLabelProvider((IBaseLabelProvider)new ViewLabelProvider());
        this.viewer.setSorter((ViewerSorter)new NameSorter());
        this.viewer.setInput((Object)this.getViewSite());
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.viewer.getControl(), "de.uka.ipd.sdq.tcfmoop.viewer");
        this.makeActions();
        this.hookContextMenu();
        this.hookDoubleClickAction();
        this.contributeToActionBars();
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                TerminationCriteriaView.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.requestTerminationAction);
        manager.add((IAction)this.copyAllAction);
        manager.add((IAction)this.colapseAllAction);
        manager.add((IAction)this.expandAllaction);
    }

    private void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.requestTerminationAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.copyAllAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.expandAllaction);
        manager.add((IAction)this.colapseAllAction);
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.requestTerminationAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.copyAllAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.expandAllaction);
        manager.add((IAction)this.colapseAllAction);
    }

    private void makeActions() {
        this.requestTerminationAction = new Action(){

            public void run() {
                TerminationCriteriaView.this.fireRequestManualTerminationEvent();
            }
        };
        this.requestTerminationAction.setText("Request Manual Stop");
        this.requestTerminationAction.setToolTipText("Request Manual Stop: Stops the optimization after the execution of the current iteration.");
        this.requestTerminationAction.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_ELCL_STOP"));
        this.requestTerminationAction.setEnabled(false);
        this.expandAllaction = new Action(){

            public void run() {
                TerminationCriteriaView.this.viewer.expandAll();
            }
        };
        this.expandAllaction.setText("Expand All");
        this.expandAllaction.setToolTipText("Expand All Nodes");
        this.expandAllaction.setImageDescriptor(Activator.getImageDescriptor("icons/expandall.gif"));
        this.colapseAllAction = new Action(){

            public void run() {
                TerminationCriteriaView.this.viewer.collapseAll();
            }
        };
        this.colapseAllAction.setText("Colapse All");
        this.colapseAllAction.setToolTipText("Colapse All Nodes");
        this.colapseAllAction.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_ELCL_COLLAPSEALL"));
        this.copyAllAction = new Action(){

            public void run() {
                Clipboard cb = new Clipboard(Display.getDefault());
                String clipBoardText = TerminationCriteriaView.this.terminationCriteriaManagerOutput.subTreeToString("\t", 0);
                TextTransfer textTransfer = TextTransfer.getInstance();
                cb.setContents(new Object[]{clipBoardText}, new Transfer[]{textTransfer});
            }
        };
        this.copyAllAction.setText("Copy to Clipboard");
        this.copyAllAction.setToolTipText("Copy the content of this view to the clipboard in a suitable Tree representation.");
        this.copyAllAction.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_COPY"));
        this.doubleClickAction = new Action(){

            public void run() {
                Object obj = ((IStructuredSelection)TerminationCriteriaView.this.viewer.getSelection()).iterator().next();
                if (TerminationCriteriaView.this.viewer.getExpandedState(obj)) {
                    TerminationCriteriaView.this.viewer.collapseToLevel(obj, 1);
                } else {
                    TerminationCriteriaView.this.viewer.expandToLevel(obj, 1);
                }
            }
        };
    }

    private void hookDoubleClickAction() {
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                TerminationCriteriaView.this.doubleClickAction.run();
            }
        });
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    @Override
    public void handleTerminationCriteriaManagerInitializedEvent(ITerminationCriteriaManager instance) {
        instance.addOutputChangedListener(this);
        instance.addOptimizationTerminatedListener(this);
        this.requestTerminationAction.setEnabled(true);
    }

    @Override
    public void handleOutputChangedEvent(final Tree outPut) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                TerminationCriteriaView.this.terminationCriteriaManagerOutput = outPut;
                TerminationCriteriaView.this.viewer.refresh();
            }
        });
    }

    @Override
    public void handleOptimizationTerminatedListener(TerminationCriteriaManager instance) {
        instance.removeOutputChangedListener(this);
        instance.removeOptimizationTerminatedListener(this);
        this.requestTerminationAction.setEnabled(false);
    }

    private void fireRequestManualTerminationEvent() {
        for (IRequestManualTerminationListener listener : this.requestManualTerminationListeners) {
            listener.handleManualTerminationRequest();
        }
        this.requestTerminationAction.setEnabled(false);
    }

    @Override
    public void addRequestManualTerminationListener(IRequestManualTerminationListener listener) {
        this.requestManualTerminationListeners.add(listener);
    }

    @Override
    public void removeRequestManualTerminationListener(IRequestManualTerminationListener listener) {
        this.requestManualTerminationListeners.remove(listener);
    }

    private class NameSorter
    extends ViewerSorter {
        private NameSorter() {
        }

        public void sort(Viewer viewer, Object[] elements) {
        }
    }

    private class ViewLabelProvider
    extends LabelProvider {
        private ViewLabelProvider() {
        }

        public String getText(Object obj) {
            return obj.toString();
        }

        public Image getImage(Object obj) {
            Image image;
            ImageDescriptor descriptor = null;
            if (obj instanceof Node) {
                switch (((Node)obj).type) {
                    case EXPRESSION: {
                        descriptor = Activator.getImageDescriptor("icons/expression.gif");
                        break;
                    }
                    case MANAGER: {
                        descriptor = Activator.getImageDescriptor("icons/manager.gif");
                        break;
                    }
                    case PARAMETER: {
                        descriptor = Activator.getImageDescriptor("icons/parameter.gif");
                        break;
                    }
                    case PARAMETER_GROUP: {
                        descriptor = Activator.getImageDescriptor("icons/parameterGroup.gif");
                        break;
                    }
                    case TERMINATION_CRITERIA: {
                        descriptor = Activator.getImageDescriptor("icons/terminationCriteria.gif");
                        break;
                    }
                    case WARNING: {
                        descriptor = Activator.getImageDescriptor("icons/warning.gif");
                    }
                }
            }
            if ((image = TerminationCriteriaView.this.imageCache.get(descriptor)) == null) {
                image = descriptor.createImage();
                TerminationCriteriaView.this.imageCache.put(descriptor, image);
            }
            return image;
        }
    }
}

