/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.tcfmoop.config;

import de.uka.ipd.sdq.tcfmoop.config.AbstractConfiguration;
import de.uka.ipd.sdq.tcfmoop.config.TerminationCriteriaNames;
import de.uka.ipd.sdq.tcfmoop.config.exceptions.InvalidConfigException;
import java.util.HashMap;
import java.util.Map;
import org.opt4j.core.Objective;
import org.opt4j.core.Value;

public class MinimalQualityCriteriaValueConfig
extends AbstractConfiguration {
    private Map<String, Value<?>> unresolvedObjectives = new HashMap();
    private Map<Objective, Value<?>> configuredObjectives = new HashMap();
    private Integer numberOfCandidatesToConform;

    public MinimalQualityCriteriaValueConfig() {
        super(TerminationCriteriaNames.MINIMAL_QUALITY_CIRTERIA_VALUE);
    }

    @Override
    public boolean validateConfiguration() {
        return this.getTerminationCriterionName() == TerminationCriteriaNames.MINIMAL_QUALITY_CIRTERIA_VALUE && this.configuredObjectives != null && !this.configuredObjectives.isEmpty() && this.numberOfCandidatesToConform != null;
    }

    public void setObjectiveMinimalValues(Map<Objective, Value<?>> configuredObjectives) throws InvalidConfigException {
        if (configuredObjectives == null || configuredObjectives.isEmpty()) {
            throw new InvalidConfigException("MinimalQualityCriteriaValueConfig.setObjectiveMinimalValue: the supplied parameter should not be null or empty");
        }
        this.configuredObjectives.putAll(configuredObjectives);
    }

    public Map<Objective, Value<?>> getObjectiveMinimalValues() {
        return this.configuredObjectives;
    }

    public void setUnresolvedObjectiveMinimalValue(Map<String, Value<?>> unresolvedObjectives) {
        this.unresolvedObjectives.putAll(unresolvedObjectives);
    }

    public Map<String, Value<?>> getUnresolvedObjectiveMinimalValue() {
        return this.unresolvedObjectives;
    }

    public void setNumberOfCandidatesToConform(int numberOfCandidates) throws InvalidConfigException {
        if (numberOfCandidates < 1) {
            throw new InvalidConfigException("MinimalQualityCriteriaValueConfig.setNumberOfCandidatesToConform: the provided number of candidates to conform to the conditions must be at least 1");
        }
        this.numberOfCandidatesToConform = numberOfCandidates;
    }

    public int getNumberOfCandidatesToConform() {
        return this.numberOfCandidatesToConform;
    }
}

