/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.tcfmoop.tests;

import de.uka.ipd.sdq.tcfmoop.config.InsignificantParetoFrontChangeConfig;
import de.uka.ipd.sdq.tcfmoop.terminationcriteria.InsignificantParetoFrontChangeCriterion;
import java.util.HashSet;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opt4j.common.archive.DefaultArchive;
import org.opt4j.core.Individual;
import org.opt4j.core.Objective;
import org.opt4j.core.Objectives;
import org.opt4j.core.domination.DominationStrategy;
import org.opt4j.core.domination.ParetoDomination;
import org.opt4j.core.optimizer.Archive;

public class InsignificantParetoFrontChangeCriterionTest {
    InsignificantParetoFrontChangeConfig ipfcconf;
    InsignificantParetoFrontChangeCriterion ipfccrit;
    Archive archive = new DefaultArchive();
    Objectives o1 = new Objectives((DominationStrategy)new ParetoDomination());
    Objectives o2 = new Objectives((DominationStrategy)new ParetoDomination());
    Objectives o3 = new Objectives((DominationStrategy)new ParetoDomination());
    Objectives o4 = new Objectives((DominationStrategy)new ParetoDomination());
    Objectives o5 = new Objectives((DominationStrategy)new ParetoDomination());
    Objectives o6 = new Objectives((DominationStrategy)new ParetoDomination());
    MyIndividual i1 = new MyIndividual();
    MyIndividual i2 = new MyIndividual();
    MyIndividual i3 = new MyIndividual();
    MyIndividual i4 = new MyIndividual();
    MyIndividual i5 = new MyIndividual();
    MyIndividual i6 = new MyIndividual();
    Objective X = new Objective("X", Objective.Sign.MIN);
    Objective Y = new Objective("Y", Objective.Sign.MIN);

    @Before
    public void setUp() throws Exception {
        this.ipfcconf = new InsignificantParetoFrontChangeConfig();
        this.o1.add(this.X, 2);
        this.o1.add(this.Y, 6);
        this.o2.add(this.X, 4);
        this.o2.add(this.Y, 3);
        this.o3.add(this.X, 6);
        this.o3.add(this.Y, 1);
        this.o4.add(this.X, 8);
        this.o4.add(this.Y, 0.5);
        this.o5.add(this.X, 3);
        this.o5.add(this.Y, 2);
        this.o6.add(this.X, 1);
        this.o6.add(this.Y, 5);
        this.i1.setObjectives(this.o1);
        this.i2.setObjectives(this.o2);
        this.i3.setObjectives(this.o3);
        this.i4.setObjectives(this.o4);
        this.i5.setObjectives(this.o5);
        this.i6.setObjectives(this.o6);
        this.ipfcconf.setMinimumAllowedDifference(0.35);
        this.ipfcconf.setPastIterationNumber(2);
        if (!this.ipfcconf.validateConfiguration()) {
            throw new Exception();
        }
    }

    @Test
    public void testWithAnEmptyArchive() {
        this.ipfccrit = new InsignificantParetoFrontChangeCriterion(this.ipfcconf, null, this.archive);
        this.ipfccrit.evaluate(0, 0L);
        Assert.assertFalse((boolean)this.ipfccrit.getEvaluationResult());
        this.ipfccrit.evaluate(0, 0L);
        Assert.assertFalse((boolean)this.ipfccrit.getEvaluationResult());
        this.ipfccrit.evaluate(0, 0L);
        Assert.assertTrue((boolean)this.ipfccrit.getEvaluationResult());
    }

    @Test
    public void testInsignificantChange() {
        this.archive.add((Individual)this.i1);
        this.archive.add((Individual)this.i2);
        this.archive.add((Individual)this.i3);
        this.archive.add((Individual)this.i4);
        this.ipfccrit = new InsignificantParetoFrontChangeCriterion(this.ipfcconf, null, this.archive);
        this.ipfccrit.evaluate(0, 0L);
        Assert.assertFalse((boolean)this.ipfccrit.getEvaluationResult());
        this.ipfccrit.evaluate(0, 0L);
        Assert.assertFalse((boolean)this.ipfccrit.getEvaluationResult());
        this.archive.remove((Object)this.i2);
        this.archive.add((Individual)this.i5);
        this.ipfccrit.evaluate(0, 0L);
        Assert.assertTrue((boolean)this.ipfccrit.getEvaluationResult());
        this.archive.clear();
        this.archive.add((Individual)this.i1);
        this.archive.add((Individual)this.i2);
        this.archive.add((Individual)this.i3);
        this.archive.add((Individual)this.i4);
    }

    @Test
    public void testSignificantChange() {
        this.ipfccrit = new InsignificantParetoFrontChangeCriterion(this.ipfcconf, null, this.archive);
        this.ipfccrit.evaluate(0, 0L);
        Assert.assertFalse((boolean)this.ipfccrit.getEvaluationResult());
        this.ipfccrit.evaluate(0, 0L);
        Assert.assertFalse((boolean)this.ipfccrit.getEvaluationResult());
        this.archive.remove((Object)this.i1);
        this.archive.remove((Object)this.i2);
        this.archive.add((Individual)this.i5);
        this.archive.add((Individual)this.i6);
        this.ipfccrit.evaluate(0, 0L);
        Assert.assertFalse((boolean)this.ipfccrit.getEvaluationResult());
    }

    public class MyIndividual
    extends Individual {
        public MyIndividual() {
            this.setIndividualStatusListeners(new HashSet());
        }
    }
}

