/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.tcfmoop.config;

import de.uka.ipd.sdq.tcfmoop.config.AbstractConfiguration;
import de.uka.ipd.sdq.tcfmoop.config.TerminationCriteriaNames;
import de.uka.ipd.sdq.tcfmoop.config.exceptions.InvalidConfigException;

public class MaxGenerationNumberConfig
extends AbstractConfiguration {
    private Integer maximumNumberOfIterations;

    public MaxGenerationNumberConfig() {
        super(TerminationCriteriaNames.MAXIMUM_NUMBER_OF_GENERATIONS);
    }

    @Override
    public boolean validateConfiguration() {
        return this.getTerminationCriterionName() == TerminationCriteriaNames.MAXIMUM_NUMBER_OF_GENERATIONS && this.maximumNumberOfIterations != null;
    }

    public void setMaximumNumberOfIterations(int maximumNumberOfIterations) throws InvalidConfigException {
        if (maximumNumberOfIterations <= 0) {
            throw new InvalidConfigException("MaxGenerationNumberConfig.setMaximumNumberOfIterations: The supplied Parameter is < 1");
        }
        this.maximumNumberOfIterations = maximumNumberOfIterations;
    }

    public int getMaximumNumberOfIterations() {
        return this.maximumNumberOfIterations;
    }
}

