/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.tcfmoop.terminationcriteria;

import de.uka.ipd.sdq.tcfmoop.config.IConfiguration;
import de.uka.ipd.sdq.tcfmoop.config.InsignificantParetoFrontChangeConfig;
import de.uka.ipd.sdq.tcfmoop.outputtree.Node;
import de.uka.ipd.sdq.tcfmoop.terminationcriteria.AbstractTerminationCriterion;
import java.util.Collection;
import java.util.LinkedList;
import org.opt4j.core.Individual;
import org.opt4j.core.Objectives;
import org.opt4j.core.optimizer.Archive;
import org.opt4j.core.optimizer.Population;

public class InsignificantParetoFrontChangeCriterion
extends AbstractTerminationCriterion {
    private double requiredPercentageDifference;
    private double currentPercentageDifference;
    private int pastInterationNumber;
    private LinkedList<LinkedList<Objectives>> paretoFrontMemory = new LinkedList();
    private Node generationToCompareWithNode;
    private Node currentDifferenceNode;

    public InsignificantParetoFrontChangeCriterion(IConfiguration conf, Population population, Archive archive) {
        super(conf, population, archive);
        if (!(conf instanceof InsignificantParetoFrontChangeConfig) || !conf.validateConfiguration()) {
            throw new RuntimeException("InsignificantParetoFrontChangeCriterion.initialize: wrong or invalid configuration object");
        }
        this.requiredPercentageDifference = ((InsignificantParetoFrontChangeConfig)conf).getMinimumAllowedDifference();
        this.pastInterationNumber = ((InsignificantParetoFrontChangeConfig)conf).getPastIterationNumber();
        this.initializeOutputTree();
    }

    private void initializeOutputTree() {
        this.outputInformation.updateValue("Insignificant Pareto Front Change");
        this.outputInformation.getChildren().clear();
        this.generationToCompareWithNode = this.outputInformation.addChild("Current Generation is compared with: " + this.pastInterationNumber + " generation ago", Node.NodeType.PARAMETER);
        this.currentDifferenceNode = this.outputInformation.addChild("Current Difference: " + this.currentPercentageDifference + "/" + this.requiredPercentageDifference, Node.NodeType.PARAMETER);
        this.outputInformation.getChildren().add(this.suggestedStop);
    }

    @Override
    public void evaluateImpl(int iteration, long currentTime) {
        this.memorizeCurrentParetoFront();
        this.clearOutDatedParetoFronts();
        if (this.paretoFrontMemory.size() <= this.pastInterationNumber) {
            this.evaluationResult = false;
            return;
        }
        this.currentPercentageDifference = this.calcuteDifference((Collection<Objectives>)this.paretoFrontMemory.getFirst(), (Collection<Objectives>)this.paretoFrontMemory.getLast());
        this.evaluationResult = this.currentPercentageDifference < this.requiredPercentageDifference;
    }

    private void memorizeCurrentParetoFront() {
        LinkedList<Objectives> newFront = new LinkedList<Objectives>();
        for (Individual indi : this.archive) {
            newFront.add(indi.getObjectives());
        }
        this.paretoFrontMemory.addFirst(newFront);
    }

    private void clearOutDatedParetoFronts() {
        while (this.paretoFrontMemory.size() > this.pastInterationNumber + 1) {
            this.paretoFrontMemory.removeLast();
        }
    }

    private double calcuteDifference(Collection<Objectives> newFront, Collection<Objectives> oldFront) {
        int numberOfDominatedIndividualsInCoveredFront = 0;
        int numberOfIndividualsInCoveredFront = oldFront.size();
        block0: for (Objectives indiToBeDominated : oldFront) {
            for (Objectives coveringIndi : newFront) {
                if (!coveringIndi.dominates(indiToBeDominated)) continue;
                ++numberOfDominatedIndividualsInCoveredFront;
                continue block0;
            }
        }
        if (numberOfIndividualsInCoveredFront == 0) {
            if (newFront.size() == 0) {
                return 0.0;
            }
            return 1.0;
        }
        return (double)numberOfDominatedIndividualsInCoveredFront / (double)numberOfIndividualsInCoveredFront;
    }

    @Override
    public void updateOutputInformation() {
        this.currentDifferenceNode.updateValue("Current Difference: " + this.currentPercentageDifference + "/" + this.requiredPercentageDifference);
    }
}

