/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.tcfmoop.terminationcriteria;

import de.uka.ipd.sdq.tcfmoop.config.IConfiguration;
import de.uka.ipd.sdq.tcfmoop.config.InsignificantSetQualityImprovementConfig;
import de.uka.ipd.sdq.tcfmoop.outputtree.Node;
import de.uka.ipd.sdq.tcfmoop.outputtree.Tree;
import de.uka.ipd.sdq.tcfmoop.terminationcriteria.AbstractTerminationCriterion;
import java.util.LinkedList;
import java.util.List;
import org.opt4j.core.DoubleValue;
import org.opt4j.core.Individual;
import org.opt4j.core.Objective;
import org.opt4j.core.Value;
import org.opt4j.core.optimizer.Archive;
import org.opt4j.core.optimizer.Population;

public class InsignificantSetQualityImprovementCriterion
extends AbstractTerminationCriterion {
    private List<AverageValuesArchive> averageValueArchive = new LinkedList<AverageValuesArchive>();
    private Integer pastIterationNumber;
    private Node generationToCompareWithNode;
    private Node objectivesNode;

    public InsignificantSetQualityImprovementCriterion(IConfiguration conf, Population population, Archive archive) {
        super(conf, population, archive);
        if (!(conf instanceof InsignificantSetQualityImprovementConfig) || !conf.validateConfiguration()) {
            throw new RuntimeException("InsignificantSetQualityImprovementCriterion.initialize: wrong or invalid configuration object");
        }
        this.pastIterationNumber = ((InsignificantSetQualityImprovementConfig)conf).getComparisionGenerations();
        this.initializeObjectives(((InsignificantSetQualityImprovementConfig)conf).getValueDifferences());
        this.initializeOutputTree();
    }

    private void initializeOutputTree() {
        this.outputInformation.updateValue("Insignificant Set Quality Improvement");
        this.outputInformation.getChildren().clear();
        this.objectivesNode = this.outputInformation.addChild("Objectives", Node.NodeType.PARAMETER_GROUP);
        for (AverageValuesArchive ava : this.averageValueArchive) {
            Tree temp = new Tree(ava.objective.getName(), Node.NodeType.PARAMETER_GROUP);
            temp.addChild("Current Average: " + ava.getCurrentAverage(), Node.NodeType.PARAMETER);
            temp.addChild("Difference current/required: " + ava.getCurrentAverageDifference() + "/" + ava.requiredAveragesDifference, Node.NodeType.PARAMETER);
            this.objectivesNode.attachSubtree(temp);
        }
        this.generationToCompareWithNode = this.outputInformation.addChild("Current Generation is compared with : " + this.pastIterationNumber + " generations ago", Node.NodeType.PARAMETER);
        this.outputInformation.getChildren().add(this.suggestedStop);
    }

    private void initializeObjectives(List<InsignificantSetQualityImprovementConfig.ValueDifference> valueDiferencesList) {
        for (InsignificantSetQualityImprovementConfig.ValueDifference vd : valueDiferencesList) {
            try {
                this.averageValueArchive.add(new AverageValuesArchive(vd.objective, (Value<?>)new DoubleValue(vd.averageImprovement), (Value<?>)new DoubleValue(vd.maxMinImprovement), this.pastIterationNumber));
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
                e.printStackTrace();
            }
        }
    }

    @Override
    public void evaluateImpl(int iteration, long currentTime) {
        this.evaluationResult = true;
        for (AverageValuesArchive ava : this.averageValueArchive) {
            double newAverage = this.getAverage(ava.objective);
            double newMaxMin = this.getMaxMin(ava.objective);
            ava.update(newAverage, newMaxMin);
            if (!this.evaluationResult) continue;
            this.evaluationResult = ava.getIsChangeInsignificant();
        }
    }

    private double getAverage(Objective o) {
        double sum = 0.0;
        for (Individual indi : this.archive) {
            sum += indi.getObjectives().get(o).getDouble().doubleValue();
        }
        return sum / (double)this.archive.size();
    }

    private double getMaxMin(Objective o) {
        double currentMaxMin;
        if (o.getSign() == Objective.Sign.MAX) {
            currentMaxMin = Double.NEGATIVE_INFINITY;
            for (Individual indi : this.archive) {
                if (!(indi.getObjectives().get(o).getDouble() > currentMaxMin)) continue;
                currentMaxMin = indi.getObjectives().get(o).getDouble();
            }
        } else {
            currentMaxMin = Double.POSITIVE_INFINITY;
            for (Individual indi : this.archive) {
                if (!(indi.getObjectives().get(o).getDouble() < currentMaxMin)) continue;
                currentMaxMin = indi.getObjectives().get(o).getDouble();
            }
        }
        return currentMaxMin;
    }

    @Override
    public void updateOutputInformation() {
        for (Node objectiveNode : this.objectivesNode.getChildren()) {
            for (AverageValuesArchive ava : this.averageValueArchive) {
                if (!objectiveNode.getValue().equals(ava.objective.getName())) continue;
                objectiveNode.getChildren().get(0).updateValue("Current Average: " + ava.getCurrentAverage());
                objectiveNode.getChildren().get(1).updateValue("Difference current/required: " + ava.getCurrentAverageDifference() + "/" + ava.requiredAveragesDifference);
            }
        }
        this.generationToCompareWithNode.updateValue("Current Generation is compared with : " + this.pastIterationNumber + " generations ago");
    }

    private class AverageValuesArchive {
        public final Objective objective;
        public final Value<?> requiredAveragesDifference;
        public final Value<?> requiredMaxMinDifference;
        private LinkedList<Double> averageValues = new LinkedList();
        private LinkedList<Double> maxMinValues = new LinkedList();
        private double currentAveragesDifference = 0.0;
        private double currentMaxMinDifference = 0.0;
        private int pastIterationNumber = 0;
        private boolean isChangeInsignificant = false;

        public AverageValuesArchive(Objective objective, Value<?> requiredAveragesDifference, Value<?> requiredMaxMinDifference, int pastIterationNumber) throws Exception {
            if (requiredAveragesDifference == null || objective == null || requiredAveragesDifference.getDouble() < 0.0 || requiredAveragesDifference.getDouble() > 1.0 || pastIterationNumber < 1 || requiredMaxMinDifference.getDouble() < 0.0 || requiredMaxMinDifference.getDouble() > 1.0) {
                throw new Exception("AverageValuesArchive.AverageValuesArchive: None of the supplied parameters should be null, maximumPercentageImprovement and minimumPercentageHighestValue must be a percentage values between 0 and 1pastIterationNumber must be at least 1");
            }
            this.objective = objective;
            this.requiredAveragesDifference = requiredAveragesDifference;
            this.requiredMaxMinDifference = requiredMaxMinDifference;
            this.pastIterationNumber = pastIterationNumber;
        }

        public void update(double newAverageValue, double newMaxMinValue) {
            this.averageValues.addFirst(newAverageValue);
            this.maxMinValues.addFirst(newMaxMinValue);
            if (this.averageValues.size() > this.pastIterationNumber) {
                this.currentAveragesDifference = Math.abs(this.averageValues.getFirst() / this.averageValues.getLast() - 1.0);
                this.currentMaxMinDifference = Math.abs(this.maxMinValues.getFirst() / this.maxMinValues.getLast() - 1.0);
                this.isChangeInsignificant = this.currentAveragesDifference <= this.requiredAveragesDifference.getDouble() && this.currentMaxMinDifference <= this.requiredMaxMinDifference.getDouble();
                this.averageValues.removeLast();
                this.maxMinValues.removeLast();
            }
        }

        public boolean getIsChangeInsignificant() {
            return this.isChangeInsignificant;
        }

        public double getCurrentAverageDifference() {
            return this.currentAveragesDifference;
        }

        public double getCurrentMaxMinDifference() {
            return this.currentMaxMinDifference;
        }

        public double getCurrentAverage() {
            if (this.averageValues.isEmpty()) {
                return 0.0;
            }
            return this.averageValues.getFirst();
        }
    }
}

