/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.tcfmoop.terminationcriteria;

import de.uka.ipd.sdq.tcfmoop.config.IConfiguration;
import de.uka.ipd.sdq.tcfmoop.config.NoNewParetoOptimalCandidatesFoundConfig;
import de.uka.ipd.sdq.tcfmoop.outputtree.Node;
import de.uka.ipd.sdq.tcfmoop.terminationcriteria.AbstractTerminationCriterion;
import java.util.LinkedList;
import java.util.List;
import org.opt4j.core.Individual;
import org.opt4j.core.optimizer.Archive;
import org.opt4j.core.optimizer.Population;

public class NoNewParetoOptimalCandidatesFoundCriterion
extends AbstractTerminationCriterion {
    private boolean newParetoCandidatesFound = false;
    private int requiredIterationsWithoutNewParetoOptimalCandidate;
    private int currentIterationsWithoutNewParetoOptimalCandidate = 0;
    private List<Individual> localArchive = new LinkedList<Individual>();
    private Node generationsWithoutNewCandidate;

    public NoNewParetoOptimalCandidatesFoundCriterion(IConfiguration conf, Population population, Archive archive) {
        super(conf, population, archive);
        if (!(conf instanceof NoNewParetoOptimalCandidatesFoundConfig) || !conf.validateConfiguration()) {
            throw new RuntimeException("NoNewParetoOptimalCandidatesFoundCriterion.initialize: wrong or invalid configuration object");
        }
        this.requiredIterationsWithoutNewParetoOptimalCandidate = ((NoNewParetoOptimalCandidatesFoundConfig)conf).getIterationsWithoutNewCandidates();
        this.initializeOutputTree();
    }

    private void initializeOutputTree() {
        this.outputInformation.updateValue("No New Pareto Optimal Candidates Found");
        this.outputInformation.getChildren().clear();
        this.generationsWithoutNewCandidate = this.outputInformation.addChild("No new pareto optimal candidate for: " + this.currentIterationsWithoutNewParetoOptimalCandidate + "/" + this.requiredIterationsWithoutNewParetoOptimalCandidate + " generations", Node.NodeType.PARAMETER);
        this.outputInformation.getChildren().add(this.suggestedStop);
    }

    @Override
    public void evaluateImpl(int iteration, long currentTime) {
        this.newParetoCandidatesFound = false;
        for (Individual indi : this.archive) {
            if (this.localArchive.contains(indi)) continue;
            this.newParetoCandidatesFound = true;
            this.localArchive.add(indi);
        }
        LinkedList<Individual> individualsToRemove = new LinkedList<Individual>();
        for (Individual indi : this.localArchive) {
            if (this.archive.contains((Object)indi)) continue;
            individualsToRemove.add(indi);
        }
        this.localArchive.removeAll(individualsToRemove);
        this.currentIterationsWithoutNewParetoOptimalCandidate = !this.newParetoCandidatesFound ? ++this.currentIterationsWithoutNewParetoOptimalCandidate : 0;
        this.evaluationResult = this.currentIterationsWithoutNewParetoOptimalCandidate == this.requiredIterationsWithoutNewParetoOptimalCandidate;
    }

    @Override
    public void updateOutputInformation() {
        this.generationsWithoutNewCandidate.updateValue("No new pareto optimal candidate for: " + this.currentIterationsWithoutNewParetoOptimalCandidate + "/" + this.requiredIterationsWithoutNewParetoOptimalCandidate + " generations");
    }
}

