/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.tcfmoop.tests;

import de.uka.ipd.sdq.tcfmoop.config.GivenParetoFrontIsReachedConfig;
import de.uka.ipd.sdq.tcfmoop.config.exceptions.InvalidConfigException;
import de.uka.ipd.sdq.tcfmoop.terminationcriteria.GivenParetoFrontIsReachedCriterion;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opt4j.common.archive.DefaultArchive;
import org.opt4j.core.Individual;
import org.opt4j.core.Objective;
import org.opt4j.core.Objectives;
import org.opt4j.core.domination.DominationStrategy;
import org.opt4j.core.domination.ParetoDomination;
import org.opt4j.core.optimizer.Archive;

public class GivenParetoFrontIsReachedCriterionTest {
    GivenParetoFrontIsReachedConfig gpfirconf;
    GivenParetoFrontIsReachedCriterion gpfircrit;
    Archive front25 = new DefaultArchive();
    Archive front75 = new DefaultArchive();
    Archive front100 = new DefaultArchive();
    List<Objectives> paretoFront = new LinkedList<Objectives>();
    Objectives o1 = new Objectives((DominationStrategy)new ParetoDomination());
    Objectives o2 = new Objectives((DominationStrategy)new ParetoDomination());
    Objectives o3 = new Objectives((DominationStrategy)new ParetoDomination());
    Objectives o4 = new Objectives((DominationStrategy)new ParetoDomination());

    @Before
    public void setUp() throws Exception {
        Objective X = new Objective("X", Objective.Sign.MIN);
        Objective Y = new Objective("Y", Objective.Sign.MAX);
        this.gpfirconf = new GivenParetoFrontIsReachedConfig();
        this.o1.add(X, 5);
        this.o1.add(Y, 5);
        this.o2.add(X, 4);
        this.o2.add(Y, 4);
        this.o3.add(X, 3);
        this.o3.add(Y, 3);
        this.o4.add(X, 2);
        this.o4.add(Y, 2);
        this.paretoFront.add(this.o1);
        this.paretoFront.add(this.o2);
        this.paretoFront.add(this.o3);
        this.paretoFront.add(this.o4);
        this.gpfirconf.setParetoFront(this.paretoFront);
        this.gpfirconf.setPercentagesToCover(0.75);
        if (!this.gpfirconf.validateConfiguration()) {
            throw new Exception();
        }
        MyIndividual i1 = new MyIndividual();
        i1.setObjectives(this.o1);
        MyIndividual i2 = new MyIndividual();
        i2.setObjectives(this.o2);
        MyIndividual i3 = new MyIndividual();
        i3.setObjectives(this.o3);
        MyIndividual i4 = new MyIndividual();
        i4.setObjectives(this.o4);
        this.front25.add((Individual)i1);
        this.front75.add((Individual)i1);
        this.front75.add((Individual)i2);
        this.front75.add((Individual)i3);
        this.front100.add((Individual)i1);
        this.front100.add((Individual)i2);
        this.front100.add((Individual)i3);
        this.front100.add((Individual)i4);
    }

    @Test
    public void test25PercentCoverage() {
        int initialParetoFrontSize = this.paretoFront.size();
        this.gpfircrit = new GivenParetoFrontIsReachedCriterion(this.gpfirconf, null, this.front25);
        this.gpfircrit.evaluate(0, 0L);
        Assert.assertFalse((boolean)this.gpfircrit.getEvaluationResult());
        Assert.assertTrue((this.paretoFront.size() == initialParetoFrontSize ? 1 : 0) != 0);
    }

    @Test
    public void test55PercentCoverage() {
        int initialParetoFrontSize = this.paretoFront.size();
        try {
            this.gpfirconf.setParetoFront(this.paretoFront);
        }
        catch (InvalidConfigException e) {
            e.printStackTrace();
        }
        this.gpfircrit = new GivenParetoFrontIsReachedCriterion(this.gpfirconf, null, this.front75);
        this.gpfircrit.evaluate(0, 0L);
        Assert.assertTrue((boolean)this.gpfircrit.getEvaluationResult());
        Assert.assertTrue((this.paretoFront.size() == initialParetoFrontSize ? 1 : 0) != 0);
    }

    @Test
    public void test100PercentCoverage() {
        int initialParetoFrontSize = this.paretoFront.size();
        try {
            this.gpfirconf.setParetoFront(this.paretoFront);
        }
        catch (InvalidConfigException e) {
            e.printStackTrace();
        }
        this.gpfircrit = new GivenParetoFrontIsReachedCriterion(this.gpfirconf, null, this.front100);
        this.gpfircrit.evaluate(0, 0L);
        Assert.assertTrue((boolean)this.gpfircrit.getEvaluationResult());
        Assert.assertTrue((this.paretoFront.size() == initialParetoFrontSize ? 1 : 0) != 0);
    }

    public class MyIndividual
    extends Individual {
        public MyIndividual() {
            this.setIndividualStatusListeners(new HashSet());
        }
    }
}

