/*
 * Decompiled with CFR 0.152.
 */
package edu.kit.ipd.are.dsexplore.analysis.security;

import componentSecurity.ComponentSecurity;
import de.uka.ipd.sdq.dsexplore.analysis.AbstractAnalysis;
import de.uka.ipd.sdq.dsexplore.analysis.AnalysisFailedException;
import de.uka.ipd.sdq.dsexplore.analysis.IAnalysis;
import de.uka.ipd.sdq.dsexplore.analysis.IAnalysisQualityAttributeDeclaration;
import de.uka.ipd.sdq.dsexplore.analysis.IAnalysisResult;
import de.uka.ipd.sdq.dsexplore.analysis.PCMPhenotype;
import de.uka.ipd.sdq.dsexplore.launch.DSEWorkflowConfiguration;
import de.uka.ipd.sdq.workflow.mdsd.blackboard.MDSDBlackboard;
import edu.kit.ipd.are.dsexplore.analysis.security.SecurityAnalysisResult;
import edu.kit.ipd.are.dsexplore.analysis.security.SecuritySolverQualityAttributeDeclaration;
import edu.kit.ipd.are.dsexplore.analysis.security.model.Attacker;
import edu.kit.ipd.are.dsexplore.analysis.security.model.Component;
import edu.kit.ipd.are.dsexplore.analysis.security.model.Scenario;
import edu.kit.ipd.are.dsexplore.exception.SecurityComponentAnnotationMissingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.modelversioning.emfprofile.Stereotype;
import org.modelversioning.emfprofileapplication.StereotypeApplication;
import org.opt4j.core.Criterion;
import org.palladiosimulator.mdsdprofiles.api.StereotypeAPI;
import org.palladiosimulator.pcm.core.composition.AssemblyConnector;
import org.palladiosimulator.pcm.core.composition.AssemblyContext;
import org.palladiosimulator.pcm.core.composition.Connector;
import org.palladiosimulator.pcm.system.System;
import org.palladiosimulator.solver.core.models.PCMInstance;

public class SecurityEvaluator
extends AbstractAnalysis
implements IAnalysis {
    private static Logger logger = Logger.getLogger((String)"edu.kit.ipd.are.dsexplore.analysis.security");
    private final Map<Long, SecurityAnalysisResult> previousSecurityResults = new HashMap<Long, SecurityAnalysisResult>();
    private Attacker attacker = new Attacker(0.01, 100.0, 200.0);

    public SecurityEvaluator() {
        super((IAnalysisQualityAttributeDeclaration)new SecuritySolverQualityAttributeDeclaration());
    }

    public void analyse(PCMPhenotype pheno, IProgressMonitor monitor) {
        PCMInstance pcm = pheno.getPCMInstance();
        System system = pcm.getSystem();
        int atk_entry_length = system.getProvidedRoles_InterfaceProvidingEntity().size();
        EList connectors = system.getConnectors__ComposedStructure();
        HashMap<AssemblyContext, List<AssemblyContext>> assMap = new HashMap<AssemblyContext, List<AssemblyContext>>();
        for (AssemblyContext assContext : system.getAssemblyContexts__ComposedStructure()) {
            List<AssemblyContext> targets = this.getRequiringAssemblyContexts(assContext, (List<Connector>)connectors);
            assMap.put(assContext, targets);
        }
        List<Component> components = this.createComponents(assMap.keySet());
        int[][] theta = this.getTheta(assMap);
        Scenario scenario = new Scenario(theta, components.toArray(new Component[0]));
        int securityValue = (int)scenario.calcMTTSF(atk_entry_length, this.attacker);
        logger.debug((Object)securityValue);
        this.previousSecurityResults.put(pheno.getNumericID(), new SecurityAnalysisResult(securityValue, pcm, this.criterionToAspect, (SecuritySolverQualityAttributeDeclaration)this.qualityAttribute));
    }

    private List<AssemblyContext> getRequiringAssemblyContexts(AssemblyContext assContext, List<Connector> connectors) {
        ArrayList<AssemblyContext> targets = new ArrayList<AssemblyContext>();
        for (Connector connector : connectors) {
            AssemblyConnector assConnector;
            if (!(connector instanceof AssemblyConnector) || !(assConnector = (AssemblyConnector)connector).getRequiringAssemblyContext_AssemblyConnector().equals(assContext)) continue;
            targets.add(assConnector.getProvidingAssemblyContext_AssemblyConnector());
        }
        return targets;
    }

    private List<Component> createComponents(Set<AssemblyContext> assSet) throws RuntimeException {
        ArrayList<Component> components = new ArrayList<Component>();
        for (AssemblyContext assContext : assSet) {
            EList stereotypeApplications = StereotypeAPI.getStereotypeApplications((EObject)assContext);
            ComponentSecurity annotatedCompSec = null;
            for (StereotypeApplication stApp : stereotypeApplications) {
                Stereotype stereotype = stApp.getStereotype();
                if (!stereotype.getName().equals("SecurityAnnotation")) continue;
                EStructuralFeature feat = stereotype.getEStructuralFeature("secAnnotation");
                annotatedCompSec = (ComponentSecurity)stApp.eGet(feat);
            }
            Component.Builder component = new Component.Builder().name(assContext.getEntityName());
            if (annotatedCompSec == null) {
                logger.error((Object)("Could not find an annotation for " + assContext.getEntityName()));
                throw new SecurityComponentAnnotationMissingException("No SecurityAnnotation found. Set the Stereotype for all AssemblyContexts!");
            }
            component.TTDV(annotatedCompSec.getTTDV());
            component.PoCoB(annotatedCompSec.getPoCoB());
            components.add(component.build());
        }
        return components;
    }

    private int[][] getTheta(Map<AssemblyContext, List<AssemblyContext>> assMap) {
        int theta_size = assMap.keySet().size() + 1;
        int[][] theta = new int[theta_size][theta_size];
        theta = this.basicFillTheta(assMap, theta);
        theta = this.updateTheta(theta);
        theta = this.updateTheta(theta);
        return theta;
    }

    private int[][] basicFillTheta(Map<AssemblyContext, List<AssemblyContext>> assMap, int[][] theta) {
        List<AssemblyContext> targets = this.getTargets(assMap.keySet());
        ArrayList<AssemblyContext> assList = new ArrayList<AssemblyContext>(assMap.keySet());
        int i = 0;
        while (i < assList.size()) {
            AssemblyContext assContext = (AssemblyContext)assList.get(i);
            if (targets.contains(assContext)) {
                int[] nArray = theta[i];
                int n = theta[0].length - 1;
                nArray[n] = nArray[n] + 1;
            }
            for (AssemblyContext reqAssContext : assMap.get(assContext)) {
                int reqIndex = assList.indexOf(reqAssContext);
                int[] nArray = theta[i];
                int n = reqIndex;
                nArray[n] = nArray[n] + 1;
            }
            ++i;
        }
        return theta;
    }

    private int[][] updateTheta(int[][] theta) {
        int i = 0;
        while (i < theta.length) {
            int sum = 0;
            int[][] nArray = theta;
            int n = theta.length;
            int n2 = 0;
            while (n2 < n) {
                int[] element = nArray[n2];
                sum += element[i];
                ++n2;
            }
            sum = Math.max(1, sum);
            int j = 0;
            while (j < theta[i].length) {
                if (theta[i][j] > 0) {
                    theta[i][j] = sum;
                }
                ++j;
            }
            ++i;
        }
        return theta;
    }

    private List<AssemblyContext> getTargets(Collection<AssemblyContext> assCollection) {
        ArrayList<AssemblyContext> targets = new ArrayList<AssemblyContext>();
        block0: for (AssemblyContext assContext : assCollection) {
            EList stereotypes = StereotypeAPI.getAppliedStereotypes((EObject)assContext);
            for (Stereotype stereotype : stereotypes) {
                if (!stereotype.getName().equals("SecurityTarget")) continue;
                targets.add(assContext);
                continue block0;
            }
        }
        return targets;
    }

    private double calcMttsfForMockingScenario() {
        int[][] theta = new int[6][6];
        theta[0][2] = 1;
        theta[1][3] = 1;
        theta[2][3] = 1;
        theta[3][4] = 2;
        theta[4][5] = 2;
        Component[] components = new Component[]{new Component.Builder().TTDV(200.0).PoCoB(0.2).build(), new Component(250.0, 0.3), new Component(125.0, 0.4), new Component(150.0, 0.2), new Component(300.0, 0.2)};
        Attacker a = this.attacker;
        Scenario s = new Scenario(theta, components);
        return s.calcMTTSF(2, a);
    }

    public void initialise(DSEWorkflowConfiguration configuration) throws CoreException {
        this.initialiseCriteria(configuration);
        ILaunchConfiguration origConfig = configuration.getOriginalConfig();
        try {
            double lambda = Double.parseDouble(origConfig.getAttribute("attacker_lambda", "0.01"));
            double delta = Double.parseDouble(origConfig.getAttribute("attacker_delta", "100"));
            double mtoa = Double.parseDouble(origConfig.getAttribute("attacker_mtoa", "200"));
            this.attacker = new Attacker(lambda, delta, mtoa);
            logger.debug((Object)("Initialised with " + this.attacker));
        }
        catch (NumberFormatException e) {
            logger.error((Object)"ERR! Started evaluating while attacker values are invalid!");
            e.printStackTrace();
        }
    }

    public boolean hasStatisticResultsFor() throws CoreException {
        return false;
    }

    public IAnalysisResult retrieveResultsFor(PCMPhenotype pheno, Criterion criterion) throws CoreException, AnalysisFailedException {
        return this.previousSecurityResults.get(pheno.getNumericID());
    }

    public boolean hasObjectivePerUsageScenario() throws CoreException {
        return false;
    }

    public void setBlackboard(MDSDBlackboard blackboard) {
        this.blackboard = blackboard;
    }
}

