/*
 * Decompiled with CFR 0.152.
 */
package edu.kit.ipd.are.dsexplore.analysis.security.model;

import edu.kit.ipd.are.dsexplore.analysis.security.model.Attacker;

public class Component {
    private final double TTDV;
    private final double PoCoB;
    private final String name;

    public Component(double TTDV, double PoCoB, String name) {
        this.TTDV = TTDV;
        this.PoCoB = PoCoB;
        this.name = name;
    }

    public Component(double TTDV, double PoCoB) {
        this.TTDV = TTDV;
        this.PoCoB = PoCoB;
        this.name = "UNNAMED";
    }

    private Component(Builder builder) {
        this.TTDV = builder.TTDV;
        this.PoCoB = builder.PoCoB;
        this.name = builder.name;
    }

    private double calcPoCoBAttacker(Attacker a) {
        return a.calcAttacker() * this.PoCoB;
    }

    public double calcMTTBC(Attacker a) {
        return this.TTDV / this.calcPoCoBAttacker(a);
    }

    public double getTTDV() {
        return this.TTDV;
    }

    public double getPoCoB() {
        return this.PoCoB;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return "Component{Name=\"" + this.name + "\"" + ", TTDV=" + this.TTDV + ", PoCoB=" + this.PoCoB + "}";
    }

    public static class Builder {
        private double TTDV = Double.NaN;
        private double PoCoB = Double.NaN;
        private String name = "UNNAMED";

        public Builder TTDV(double val) {
            this.TTDV = val;
            return this;
        }

        public Builder PoCoB(double val) {
            this.PoCoB = val;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Component build() throws IllegalArgumentException {
            if (this.TTDV == Double.NaN || this.PoCoB == Double.NaN) {
                throw new IllegalArgumentException("TTDV or PoCoB not set!");
            }
            return new Component(this);
        }
    }
}

