/**
 */
package FeatureCompletionModel.provider;

import FeatureCompletionModel.util.FeatureCompletionAdapterFactory;

import java.util.ArrayList;
import java.util.Collection;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;

import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;

/**
 * This is the factory that is used to provide the interfaces needed to support Viewers.
 * The adapters generated by this factory convert EMF adapter notifications into calls to {@link #fireNotifyChanged fireNotifyChanged}.
 * The adapters also support Eclipse property sheets.
 * Note that most of the adapters are shared among multiple instances.
 * <!-- begin-user-doc -->
 * <!-- end-user-doc -->
 * @generated
 */
public class FeatureCompletionItemProviderAdapterFactory extends FeatureCompletionAdapterFactory implements ComposeableAdapterFactory, IChangeNotifier, IDisposable {
	/**
	 * This keeps track of the root adapter factory that delegates to this adapter factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ComposedAdapterFactory parentAdapterFactory;

	/**
	 * This is used to implement {@link org.eclipse.emf.edit.provider.IChangeNotifier}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IChangeNotifier changeNotifier = new ChangeNotifier();

	/**
	 * This keeps track of all the supported types checked by {@link #isFactoryForType isFactoryForType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Collection<Object> supportedTypes = new ArrayList<Object>();

	/**
	 * This constructs an instance.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public FeatureCompletionItemProviderAdapterFactory() {
		supportedTypes.add(IEditingDomainItemProvider.class);
		supportedTypes.add(IStructuredItemContentProvider.class);
		supportedTypes.add(ITreeItemContentProvider.class);
		supportedTypes.add(IItemLabelProvider.class);
		supportedTypes.add(IItemPropertySource.class);
	}

	/**
	 * This keeps track of the one adapter used for all {@link FeatureCompletionModel.FeatureCompletionRepository} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected FeatureCompletionRepositoryItemProvider featureCompletionRepositoryItemProvider;

	/**
	 * This creates an adapter for a {@link FeatureCompletionModel.FeatureCompletionRepository}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createFeatureCompletionRepositoryAdapter() {
		if (featureCompletionRepositoryItemProvider == null) {
			featureCompletionRepositoryItemProvider = new FeatureCompletionRepositoryItemProvider(this);
		}

		return featureCompletionRepositoryItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link FeatureCompletionModel.FeatureCompletion} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected FeatureCompletionItemProvider featureCompletionItemProvider;

	/**
	 * This creates an adapter for a {@link FeatureCompletionModel.FeatureCompletion}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createFeatureCompletionAdapter() {
		if (featureCompletionItemProvider == null) {
			featureCompletionItemProvider = new FeatureCompletionItemProvider(this);
		}

		return featureCompletionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link FeatureCompletionModel.CompletionComponent} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CompletionComponentItemProvider completionComponentItemProvider;

	/**
	 * This creates an adapter for a {@link FeatureCompletionModel.CompletionComponent}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createCompletionComponentAdapter() {
		if (completionComponentItemProvider == null) {
			completionComponentItemProvider = new CompletionComponentItemProvider(this);
		}

		return completionComponentItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link FeatureCompletionModel.DescribedElement} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected DescribedElementItemProvider describedElementItemProvider;

	/**
	 * This creates an adapter for a {@link FeatureCompletionModel.DescribedElement}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createDescribedElementAdapter() {
		if (describedElementItemProvider == null) {
			describedElementItemProvider = new DescribedElementItemProvider(this);
		}

		return describedElementItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link FeatureCompletionModel.NamedElement} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected NamedElementItemProvider namedElementItemProvider;

	/**
	 * This creates an adapter for a {@link FeatureCompletionModel.NamedElement}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createNamedElementAdapter() {
		if (namedElementItemProvider == null) {
			namedElementItemProvider = new NamedElementItemProvider(this);
		}

		return namedElementItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link FeatureCompletionModel.PerimeterProviding} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected PerimeterProvidingItemProvider perimeterProvidingItemProvider;

	/**
	 * This creates an adapter for a {@link FeatureCompletionModel.PerimeterProviding}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createPerimeterProvidingAdapter() {
		if (perimeterProvidingItemProvider == null) {
			perimeterProvidingItemProvider = new PerimeterProvidingItemProvider(this);
		}

		return perimeterProvidingItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link FeatureCompletionModel.ComplementumVisnetis} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ComplementumVisnetisItemProvider complementumVisnetisItemProvider;

	/**
	 * This creates an adapter for a {@link FeatureCompletionModel.ComplementumVisnetis}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createComplementumVisnetisAdapter() {
		if (complementumVisnetisItemProvider == null) {
			complementumVisnetisItemProvider = new ComplementumVisnetisItemProvider(this);
		}

		return complementumVisnetisItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link FeatureCompletionModel.Complementum} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ComplementumItemProvider complementumItemProvider;

	/**
	 * This creates an adapter for a {@link FeatureCompletionModel.Complementum}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createComplementumAdapter() {
		if (complementumItemProvider == null) {
			complementumItemProvider = new ComplementumItemProvider(this);
		}

		return complementumItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link FeatureCompletionModel.ArchitectureConstraints} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ArchitectureConstraintsItemProvider architectureConstraintsItemProvider;

	/**
	 * This creates an adapter for a {@link FeatureCompletionModel.ArchitectureConstraints}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createArchitectureConstraintsAdapter() {
		if (architectureConstraintsItemProvider == null) {
			architectureConstraintsItemProvider = new ArchitectureConstraintsItemProvider(this);
		}

		return architectureConstraintsItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link FeatureCompletionModel.ConstrainableElement} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ConstrainableElementItemProvider constrainableElementItemProvider;

	/**
	 * This creates an adapter for a {@link FeatureCompletionModel.ConstrainableElement}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createConstrainableElementAdapter() {
		if (constrainableElementItemProvider == null) {
			constrainableElementItemProvider = new ConstrainableElementItemProvider(this);
		}

		return constrainableElementItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link FeatureCompletionModel.PerimeterRequiring} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected PerimeterRequiringItemProvider perimeterRequiringItemProvider;

	/**
	 * This creates an adapter for a {@link FeatureCompletionModel.PerimeterRequiring}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createPerimeterRequiringAdapter() {
		if (perimeterRequiringItemProvider == null) {
			perimeterRequiringItemProvider = new PerimeterRequiringItemProvider(this);
		}

		return perimeterRequiringItemProvider;
	}

	/**
	 * This returns the root adapter factory that contains this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ComposeableAdapterFactory getRootAdapterFactory() {
		return parentAdapterFactory == null ? this : parentAdapterFactory.getRootAdapterFactory();
	}

	/**
	 * This sets the composed adapter factory that contains this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setParentAdapterFactory(ComposedAdapterFactory parentAdapterFactory) {
		this.parentAdapterFactory = parentAdapterFactory;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean isFactoryForType(Object type) {
		return supportedTypes.contains(type) || super.isFactoryForType(type);
	}

	/**
	 * This implementation substitutes the factory itself as the key for the adapter.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter adapt(Notifier notifier, Object type) {
		return super.adapt(notifier, this);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object adapt(Object object, Object type) {
		if (isFactoryForType(type)) {
			Object adapter = super.adapt(object, type);
			if (!(type instanceof Class<?>) || (((Class<?>)type).isInstance(adapter))) {
				return adapter;
			}
		}

		return null;
	}

	/**
	 * This adds a listener.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void addListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.addListener(notifyChangedListener);
	}

	/**
	 * This removes a listener.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void removeListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.removeListener(notifyChangedListener);
	}

	/**
	 * This delegates to {@link #changeNotifier} and to {@link #parentAdapterFactory}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void fireNotifyChanged(Notification notification) {
		changeNotifier.fireNotifyChanged(notification);

		if (parentAdapterFactory != null) {
			parentAdapterFactory.fireNotifyChanged(notification);
		}
	}

	/**
	 * This disposes all of the item providers created by this factory. 
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void dispose() {
		if (featureCompletionRepositoryItemProvider != null) featureCompletionRepositoryItemProvider.dispose();
		if (featureCompletionItemProvider != null) featureCompletionItemProvider.dispose();
		if (completionComponentItemProvider != null) completionComponentItemProvider.dispose();
		if (describedElementItemProvider != null) describedElementItemProvider.dispose();
		if (namedElementItemProvider != null) namedElementItemProvider.dispose();
		if (perimeterProvidingItemProvider != null) perimeterProvidingItemProvider.dispose();
		if (complementumVisnetisItemProvider != null) complementumVisnetisItemProvider.dispose();
		if (complementumItemProvider != null) complementumItemProvider.dispose();
		if (architectureConstraintsItemProvider != null) architectureConstraintsItemProvider.dispose();
		if (constrainableElementItemProvider != null) constrainableElementItemProvider.dispose();
		if (perimeterRequiringItemProvider != null) perimeterRequiringItemProvider.dispose();
	}

}
